/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.safetycases.model.Strategy;
import org.fortiss.af3.safetycases.ui.AF3SafetyCasesUIActivator;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuContributor;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;

public class StrategyUndevelopedEntity
implements IContextMenuContributor {
    public List<IContributionItem> getContributedItems(EObject selection, ContextMenuContextProvider contextProvider) {
        if (selection instanceof Strategy && !((Strategy)selection).isToBeDeveloped()) {
            ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
            contributionItems.add((IContributionItem)new ActionContributionItem((IAction)new StrategyUndevelopedEntityAction((Strategy)selection)));
            return contributionItems;
        }
        if (selection instanceof Strategy && ((Strategy)selection).isToBeDeveloped()) {
            ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
            contributionItems.add((IContributionItem)new ActionContributionItem((IAction)new StrategyDevelopedEntityAction((Strategy)selection)));
            return contributionItems;
        }
        return Collections.emptyList();
    }

    public String getMenuSectionID() {
        return "afterglobal";
    }

    private class StrategyDevelopedEntityAction
    extends Action {
        private Strategy selectedStrategy;

        StrategyDevelopedEntityAction(Strategy selectedStrategy) {
            super("Set Developed Entity", AF3SafetyCasesUIActivator.getImageDescriptor("icons/check.png"));
            this.selectedStrategy = selectedStrategy;
        }

        public void run() {
            ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)this.selectedStrategy);
            topLevel.runAsCommand(new Runnable(){

                @Override
                public void run() {
                    boolean go = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"", (String)"Are you sure you want to set this strategy as developed?");
                    if (!go) {
                        return;
                    }
                    if (StrategyDevelopedEntityAction.this.selectedStrategy.isToBeDeveloped()) {
                        StrategyDevelopedEntityAction.this.selectedStrategy.setToBeDeveloped(false);
                    }
                }
            });
        }
    }

    private class StrategyUndevelopedEntityAction
    extends Action {
        private Strategy selectedStrategy;

        StrategyUndevelopedEntityAction(Strategy selectedStrategy) {
            super("Set Undeveloped Entity", AF3SafetyCasesUIActivator.getImageDescriptor("icons/todo.png"));
            this.selectedStrategy = selectedStrategy;
        }

        public void run() {
            ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)this.selectedStrategy);
            topLevel.runAsCommand(new Runnable(){

                @Override
                public void run() {
                    boolean go = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"", (String)"Are you sure you want to set this strategy as undeveloped?");
                    if (!go) {
                        return;
                    }
                    if (!StrategyUndevelopedEntityAction.this.selectedStrategy.isToBeDeveloped()) {
                        StrategyUndevelopedEntityAction.this.selectedStrategy.setToBeDeveloped(true);
                    }
                }
            });
        }
    }
}

