/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.editor.structure.visual;

import javafx.scene.image.Image;
import javafx.scene.paint.Paint;
import org.fortiss.af3.safetycases.model.Assumption;
import org.fortiss.af3.safetycases.model.Change;
import org.fortiss.af3.safetycases.model.maintenanceStatus;
import org.fortiss.af3.safetycases.ui.AF3SafetyCasesUIActivator;
import org.fortiss.af3.safetycases.ui.DefaultStyle;
import org.fortiss.af3.safetycases.ui.editor.structure.visual.LayoutedEllipticContentVisualBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;

public class AssumptionVisual
extends LayoutedEllipticContentVisualBase<Assumption> {
    private static final Image ICON = AF3SafetyCasesUIActivator.getFXImage("/icons/assumption.png");
    private boolean isPotentiallyImpacted = false;
    private boolean isActuallyImpacted = false;
    private Assumption assumption = this.getAssumption();

    public AssumptionVisual(IContentMVCBundle mvcb) {
        super(mvcb, Assumption.class);
        Object model = mvcb.getModel();
        if (!(model instanceof Assumption)) {
            throw new IllegalArgumentException("Expected model of type Assumption, but was " + model.getClass().getSimpleName());
        }
    }

    private Assumption getAssumption() {
        return (Assumption)this.getModel();
    }

    protected Paint getFillColor() {
        if (!this.assumption.getAffectedByCurrentChanges().isEmpty()) {
            for (Change assumptionTypeOfChange : this.assumption.getAffectedByCurrentChanges()) {
                if (assumptionTypeOfChange.getMaintainanceCause().equals((Object)maintenanceStatus.CHALLENGED)) {
                    return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.CHALLENGED_COLOR);
                }
                if (assumptionTypeOfChange.getMaintainanceCause().equals((Object)maintenanceStatus.ACTUALLY_IMPACTED)) {
                    this.isActuallyImpacted = true;
                }
                if (!assumptionTypeOfChange.getMaintainanceCause().equals((Object)maintenanceStatus.POTENTIALLY_IMPACTED)) continue;
                this.isPotentiallyImpacted = true;
            }
        }
        if (this.isActuallyImpacted) {
            this.isActuallyImpacted = false;
            return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.ACTUALLY_IMPACTED_COLOR);
        }
        if (this.isPotentiallyImpacted) {
            this.isPotentiallyImpacted = false;
            return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.POTENTIALLY_IMPACTED_COLOR);
        }
        return this.assumption.isToBeInstantiated() ? AF3SafetyCasesUIActivator.convertColor(DefaultStyle.TO_BE_FINALIZED_COLOR) : AF3SafetyCasesUIActivator.convertColor(DefaultStyle.DEFAULT);
    }

    protected Image getIcon() {
        return ICON;
    }

    @Override
    protected String getName() {
        return this.assumption.getName() + ": \n" + this.assumption.getTextualInformation();
    }
}

