/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.editor.structure.visual;

import javafx.geometry.Dimension2D;
import javafx.scene.image.Image;
import javafx.scene.paint.Paint;
import org.fortiss.af3.safetycases.model.AwayContext;
import org.fortiss.af3.safetycases.model.Change;
import org.fortiss.af3.safetycases.model.maintenanceStatus;
import org.fortiss.af3.safetycases.ui.AF3SafetyCasesUIActivator;
import org.fortiss.af3.safetycases.ui.DefaultStyle;
import org.fortiss.tooling.base.ui.editor.fx.visual.NamedLayoutedRectangularContentVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;

public class AwayContextVisual
extends NamedLayoutedRectangularContentVisual<AwayContext> {
    private static final Image ICON = AF3SafetyCasesUIActivator.getFXImage("/icons/context.png");
    private boolean isPotentiallyImpacted = false;
    private boolean isActuallyImpacted = false;
    AwayContext awayContext = this.getAwayContext();

    public AwayContextVisual(IContentMVCBundle mvcb) {
        super(mvcb, AwayContext.class);
        Object model = mvcb.getModel();
        if (!(model instanceof AwayContext)) {
            throw new IllegalArgumentException("Expected model of type Away Context, but was " + model.getClass().getSimpleName());
        }
    }

    private AwayContext getAwayContext() {
        return (AwayContext)this.getModel();
    }

    protected Paint getFillColor() {
        if (!this.awayContext.getAffectedByCurrentChanges().isEmpty()) {
            for (Change goalTypeOfChange : this.awayContext.getAffectedByCurrentChanges()) {
                if (goalTypeOfChange.getMaintainanceCause().equals((Object)maintenanceStatus.CHALLENGED)) {
                    return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.CHALLENGED_COLOR);
                }
                if (goalTypeOfChange.getMaintainanceCause().equals((Object)maintenanceStatus.ACTUALLY_IMPACTED)) {
                    this.isActuallyImpacted = true;
                    continue;
                }
                if (!goalTypeOfChange.getMaintainanceCause().equals((Object)maintenanceStatus.POTENTIALLY_IMPACTED)) continue;
                this.isPotentiallyImpacted = true;
            }
        }
        if (this.isActuallyImpacted) {
            this.isActuallyImpacted = false;
            return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.ACTUALLY_IMPACTED_COLOR);
        }
        if (this.isPotentiallyImpacted) {
            this.isPotentiallyImpacted = false;
            return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.POTENTIALLY_IMPACTED_COLOR);
        }
        return this.awayContext.isToBeInstantiated() ? AF3SafetyCasesUIActivator.convertColor(DefaultStyle.TO_BE_FINALIZED_COLOR) : AF3SafetyCasesUIActivator.convertColor(DefaultStyle.DEFAULT);
    }

    protected Image getIcon() {
        return ICON;
    }

    protected String getName() {
        return this.awayContext.getName() + ": \n" + this.awayContext.getTextualInformation();
    }

    protected Dimension2D getCornerArcDimensions() {
        return new Dimension2D(40.0, 40.0);
    }
}

