/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.editor.structure.visual;

import javafx.geometry.Dimension2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.image.Image;
import javafx.scene.paint.Paint;
import org.fortiss.af3.safetycases.model.AwaySolution;
import org.fortiss.af3.safetycases.model.Change;
import org.fortiss.af3.safetycases.model.EvidenceStatus;
import org.fortiss.af3.safetycases.model.Solution;
import org.fortiss.af3.safetycases.model.VISIBILITY;
import org.fortiss.af3.safetycases.model.maintenanceStatus;
import org.fortiss.af3.safetycases.ui.AF3SafetyCasesUIActivator;
import org.fortiss.af3.safetycases.ui.DefaultStyle;
import org.fortiss.af3.safetycases.ui.editor.structure.visual.LayoutedCircularContentVisualBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.layout.IAngleLayout;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IContentAnchorageVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.elliptic.EllipticBorderLocation;

public class AwaySolutionVisual
extends LayoutedCircularContentVisualBase<AwaySolution> {
    private static final Image ICON = AF3SafetyCasesUIActivator.getFXImage("/icons/solution.png");
    private boolean isPotentiallyImpacted = false;
    private boolean isActuallyImpacted = false;
    AwaySolution awaySolution = this.getAwaySolution();

    public AwaySolutionVisual(IContentMVCBundle mvcb) {
        super(mvcb, AwaySolution.class);
        Object model = mvcb.getModel();
        if (!(model instanceof AwaySolution)) {
            throw new IllegalArgumentException("Expected model of type Away Solution, but was " + model.getClass().getSimpleName());
        }
    }

    @Override
    public DiagramCoordinate getAnchorageLocation(IContentAnchorageVisual visual) {
        Rectangle2D pb = this.getCurrentBounds();
        double angleDeg = ((IAngleLayout)visual.getLayout(IAngleLayout.class)).getAngleInDegree();
        double w2 = pb.getWidth() / 2.0;
        double h2 = pb.getHeight() / 2.0;
        double radius = Math.max(w2, h2);
        EllipticBorderLocation ebl = new EllipticBorderLocation(angleDeg, new Dimension2D(radius, radius), new Dimension2D(0.0, 0.0));
        return ebl.getLocation();
    }

    private AwaySolution getAwaySolution() {
        return (AwaySolution)this.getModel();
    }

    protected Paint getFillColor() {
        if (!this.awaySolution.getAffectedByCurrentChanges().isEmpty()) {
            for (Change goalTypeOfChange : this.awaySolution.getAffectedByCurrentChanges()) {
                if (goalTypeOfChange.getMaintainanceCause().equals((Object)maintenanceStatus.CHALLENGED)) {
                    return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.CHALLENGED_COLOR);
                }
                if (goalTypeOfChange.getMaintainanceCause().equals((Object)maintenanceStatus.ACTUALLY_IMPACTED)) {
                    this.isActuallyImpacted = true;
                    continue;
                }
                if (!goalTypeOfChange.getMaintainanceCause().equals((Object)maintenanceStatus.POTENTIALLY_IMPACTED)) continue;
                this.isPotentiallyImpacted = true;
            }
        }
        if (this.isActuallyImpacted) {
            this.isActuallyImpacted = false;
            return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.ACTUALLY_IMPACTED_COLOR);
        }
        if (this.isPotentiallyImpacted) {
            this.isPotentiallyImpacted = false;
            return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.POTENTIALLY_IMPACTED_COLOR);
        }
        if ((Solution)this.awaySolution.getPointsTo() != null) {
            if (((Solution)this.awaySolution.getPointsTo()).getStatus() == EvidenceStatus.OK) {
                return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.DEFAULT);
            }
            if (((Solution)this.awaySolution.getPointsTo()).getStatus() == EvidenceStatus.NOT_OK) {
                return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.CHALLENGED_COLOR);
            }
            if (((Solution)this.awaySolution.getPointsTo()).getVisibility() == VISIBILITY.PRIVATE) {
                return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.PRIVATE);
            }
            return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.DEFAULT);
        }
        return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.TO_BE_FINALIZED_COLOR);
    }

    protected Image getIcon() {
        return ICON;
    }

    @Override
    protected String getName() {
        return this.awaySolution.getName() + ": \n" + this.awaySolution.getTextualInformation();
    }
}

