/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.editor.structure.visual;

import java.util.Objects;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;

public class EllipticBorderLocation {
    private final double angle;
    private final Rectangle2D contentBounds;
    private final Dimension2D correction;

    public EllipticBorderLocation(double angle, Rectangle2D contentBounds, Dimension2D anchorageSize) {
        this.angle = angle;
        this.contentBounds = Objects.requireNonNull(contentBounds);
        this.correction = Objects.requireNonNull(anchorageSize);
    }

    public double getAngle() {
        return this.angle;
    }

    public Rectangle2D getContentBounds() {
        return this.contentBounds;
    }

    public Dimension2D getAnchorageSize() {
        return this.correction;
    }

    public DiagramCoordinate getLocation() {
        double rh = this.contentBounds.getWidth() / 2.0;
        double rv = this.contentBounds.getHeight() / 2.0;
        DiagramCoordinate middle = new DiagramCoordinate(rh, rv);
        double cos = Math.cos(this.angle);
        double sin = Math.sin(this.angle);
        double tan = sin / cos;
        double x = rh * rv / Math.sqrt(rv * rv + rh * rh * tan * tan);
        double y = rh * rv * Math.signum(tan) / Math.sqrt(rv * rv / (tan * tan) + rh * rh);
        return middle.add(x * Math.signum(cos), -y * Math.signum(cos)).subtract(this.correction.getWidth() / 2.0, this.correction.getHeight() / 2.0);
    }

    public static final EllipticBorderLocation getClosestLocationOnBounds(Point2D point, Rectangle2D ellipse, Dimension2D size) {
        double w2 = ellipse.getWidth() / 2.0;
        double h2 = ellipse.getHeight() / 2.0;
        double dx = point.getX() - w2;
        double dy = h2 - point.getY();
        double angle = Math.atan2(dy, dx);
        return new EllipticBorderLocation(angle, ellipse, size);
    }
}

