/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.editor.structure.visual;

import javafx.scene.image.Image;
import javafx.scene.paint.Paint;
import org.fortiss.af3.safetycases.model.Change;
import org.fortiss.af3.safetycases.model.Justification;
import org.fortiss.af3.safetycases.model.maintenanceStatus;
import org.fortiss.af3.safetycases.ui.AF3SafetyCasesUIActivator;
import org.fortiss.af3.safetycases.ui.DefaultStyle;
import org.fortiss.af3.safetycases.ui.editor.structure.visual.LayoutedEllipticContentVisualBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;

public class JustificationVisual
extends LayoutedEllipticContentVisualBase<Justification> {
    private static final Image ICON = AF3SafetyCasesUIActivator.getFXImage("/icons/justification.png");
    private boolean isPotentiallyImpacted = false;
    private boolean isActuallyImpacted = false;
    Justification justification = this.getJustification();

    public JustificationVisual(IContentMVCBundle mvcb) {
        super(mvcb, Justification.class);
        Object model = mvcb.getModel();
        if (!(model instanceof Justification)) {
            throw new IllegalArgumentException("Expected model of type Justification, but was " + model.getClass().getSimpleName());
        }
    }

    private Justification getJustification() {
        return (Justification)this.getModel();
    }

    protected Paint getFillColor() {
        if (!this.justification.getAffectedByCurrentChanges().isEmpty()) {
            for (Change justificationTypeOfChange : this.justification.getAffectedByCurrentChanges()) {
                if (justificationTypeOfChange.getMaintainanceCause().equals((Object)maintenanceStatus.CHALLENGED)) {
                    return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.CHALLENGED_COLOR);
                }
                if (justificationTypeOfChange.getMaintainanceCause().equals((Object)maintenanceStatus.ACTUALLY_IMPACTED)) {
                    this.isActuallyImpacted = true;
                    continue;
                }
                if (!justificationTypeOfChange.getMaintainanceCause().equals((Object)maintenanceStatus.POTENTIALLY_IMPACTED)) continue;
                this.isPotentiallyImpacted = true;
            }
        }
        if (this.isActuallyImpacted) {
            this.isActuallyImpacted = false;
            return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.ACTUALLY_IMPACTED_COLOR);
        }
        if (this.isPotentiallyImpacted) {
            this.isPotentiallyImpacted = false;
            return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.POTENTIALLY_IMPACTED_COLOR);
        }
        return this.justification.isToBeInstantiated() ? AF3SafetyCasesUIActivator.convertColor(DefaultStyle.TO_BE_FINALIZED_COLOR) : AF3SafetyCasesUIActivator.convertColor(DefaultStyle.DEFAULT);
    }

    protected Image getIcon() {
        return ICON;
    }

    @Override
    protected String getName() {
        return this.justification.getName() + ": \n" + this.justification.getTextualInformation();
    }
}

