/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.editor.structure.visual;

import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.geometry.Side;
import org.fortiss.af3.safetycases.ui.editor.structure.visual.EllipticBorderLocation;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.model.layout.Rectangle;
import org.fortiss.tooling.base.ui.editor.fx.visual.CoordinateCorrections;
import org.fortiss.tooling.base.utils.LayoutDataUtils;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.layout.IOffsetLayout;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.layout.ISideLayout;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IContentAnchorageVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.elliptic.EllipticContentVisualBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.rectangular.RectangularBorderLocation;
import org.fortiss.tooling.kernel.model.INamedElement;

public class LayoutedEllipticContentVisualBase<T extends INamedElement & ILayoutedModelElement>
extends EllipticContentVisualBase {
    public LayoutedEllipticContentVisualBase(IContentMVCBundle mvcb, Class<T> modelType) {
        super(mvcb);
        Object model = mvcb.getModel();
        if (model == null) {
            throw new IllegalArgumentException("The given model is null!");
        }
        if (!modelType.isAssignableFrom(model.getClass())) {
            throw new IllegalArgumentException("Expected model of type " + modelType.getSimpleName() + ", but was " + model.getClass().getSimpleName());
        }
    }

    protected String getName() {
        return this.getModelElement().getName();
    }

    protected T getModelElement() {
        return (T)((INamedElement)this.getModel());
    }

    public Rectangle2D getModelBounds() {
        Rectangle rectangle = LayoutDataUtils.getNodeBounds((ILayoutedModelElement)((ILayoutedModelElement)this.getModelElement()));
        double insetRadius = CoordinateCorrections.RECTANGLE_INSETS.getWidth();
        double insetDiameter = insetRadius * 2.0;
        return new Rectangle2D((double)rectangle.getX() + insetRadius, (double)rectangle.getY() + insetRadius, (double)rectangle.getWidth() - insetDiameter, (double)rectangle.getHeight() - insetDiameter);
    }

    public DiagramCoordinate getAnchorageLocation(IContentAnchorageVisual visual) {
        Rectangle2D contentRectangle = this.getCurrentBounds();
        Dimension2D connectorSize = visual.getDimensions();
        Side rectangleSide = ((ISideLayout)visual.getLayout(ISideLayout.class)).getSide();
        double sideOffset = ((IOffsetLayout)visual.getLayout(IOffsetLayout.class)).getOffset();
        DiagramCoordinate location = new RectangularBorderLocation(rectangleSide, sideOffset, contentRectangle, connectorSize).getLocation();
        EllipticBorderLocation ellipticLocation = EllipticBorderLocation.getClosestLocationOnBounds((Point2D)location.add(connectorSize.getWidth() / 2.0, connectorSize.getHeight() / 2.0), contentRectangle, connectorSize);
        return ellipticLocation.getLocation();
    }
}

