/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.editor.structure.visual;

import javafx.scene.image.Image;
import javafx.scene.paint.Paint;
import org.fortiss.af3.safetycases.model.ArgumentModule;
import org.fortiss.af3.safetycases.model.ContractModule;
import org.fortiss.af3.safetycases.model.SafetyModule;
import org.fortiss.af3.safetycases.ui.AF3SafetyCasesUIActivator;
import org.fortiss.af3.safetycases.ui.DefaultStyle;
import org.fortiss.af3.safetycases.ui.utils.Utils;
import org.fortiss.tooling.base.ui.editor.fx.visual.NamedLayoutedRectangularContentVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;

public class SafetyModuleVisual
extends NamedLayoutedRectangularContentVisual<SafetyModule> {
    private static final Image ICON = AF3SafetyCasesUIActivator.getFXImage("/icons/module.png");
    private static final Image CONTRACT_ICON = AF3SafetyCasesUIActivator.getFXImage("/icons/contract.png");

    public SafetyModuleVisual(IContentMVCBundle mvcb) {
        super(mvcb, SafetyModule.class);
        Object model = mvcb.getModel();
        if (!(model instanceof SafetyModule)) {
            throw new IllegalArgumentException("Expected model of type Argument Module, but was " + model.getClass().getSimpleName());
        }
    }

    private SafetyModule getModule() {
        return (SafetyModule)this.getModel();
    }

    protected Paint getFillColor() {
        ArgumentModule argumentModule;
        SafetyModule m = this.getModule();
        if (m instanceof ContractModule) {
            return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.CONTRACT_COLOR);
        }
        if (m instanceof ArgumentModule && (Utils.hasToBeDevelopedElements(argumentModule = (ArgumentModule)m) || Utils.hasToBeInstantiatedElements(argumentModule))) {
            return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.TO_BE_FINALIZED_COLOR);
        }
        return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.DEFAULT);
    }

    protected Image getIcon() {
        if (this.getModule() instanceof ContractModule) {
            return CONTRACT_ICON;
        }
        return ICON;
    }

    protected String getName() {
        return this.getModule().getName();
    }
}

