/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.editor.structure.visual;

import javafx.scene.image.Image;
import javafx.scene.paint.Paint;
import org.fortiss.af3.safetycases.model.Change;
import org.fortiss.af3.safetycases.model.EvidenceStatus;
import org.fortiss.af3.safetycases.model.Solution;
import org.fortiss.af3.safetycases.model.VISIBILITY;
import org.fortiss.af3.safetycases.model.maintenanceStatus;
import org.fortiss.af3.safetycases.ui.AF3SafetyCasesUIActivator;
import org.fortiss.af3.safetycases.ui.DefaultStyle;
import org.fortiss.af3.safetycases.ui.editor.structure.visual.LayoutedCircularContentVisualBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;

public class SolutionVisual
extends LayoutedCircularContentVisualBase<Solution> {
    private static final Image ICON = AF3SafetyCasesUIActivator.getFXImage("/icons/solution.png");
    Solution solution = this.getSolution();
    private boolean isPotentiallyImpacted = false;
    private boolean isActuallyImpacted = false;

    public SolutionVisual(IContentMVCBundle mvcb) {
        super(mvcb, Solution.class);
        Object model = mvcb.getModel();
        if (!(model instanceof Solution)) {
            throw new IllegalArgumentException("Expected model of type Solution, but was " + model.getClass().getSimpleName());
        }
    }

    private Solution getSolution() {
        return (Solution)this.getModel();
    }

    protected Paint getFillColor() {
        if (!this.solution.getAffectedByCurrentChanges().isEmpty()) {
            for (Change solutionTypeOfChange : this.solution.getAffectedByCurrentChanges()) {
                if (solutionTypeOfChange.getMaintainanceCause().equals((Object)maintenanceStatus.CHALLENGED)) {
                    return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.CHALLENGED_COLOR);
                }
                if (solutionTypeOfChange.getMaintainanceCause().equals((Object)maintenanceStatus.ACTUALLY_IMPACTED)) {
                    this.isActuallyImpacted = true;
                    continue;
                }
                if (!solutionTypeOfChange.getMaintainanceCause().equals((Object)maintenanceStatus.POTENTIALLY_IMPACTED)) continue;
                this.isPotentiallyImpacted = true;
            }
        }
        if (this.isActuallyImpacted) {
            this.isActuallyImpacted = false;
            return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.ACTUALLY_IMPACTED_COLOR);
        }
        if (this.isPotentiallyImpacted) {
            this.isPotentiallyImpacted = false;
            return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.POTENTIALLY_IMPACTED_COLOR);
        }
        if (this.solution.getStatus() == EvidenceStatus.OK) {
            return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.DEFAULT);
        }
        if (this.solution.getStatus() == EvidenceStatus.NOT_OK) {
            return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.CHALLENGED_COLOR);
        }
        if (this.solution.isToBeInstantiated()) {
            return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.TO_BE_FINALIZED_COLOR);
        }
        if (this.solution.getVisibility() == VISIBILITY.PRIVATE) {
            return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.PRIVATE);
        }
        return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.DEFAULT);
    }

    protected Image getIcon() {
        return ICON;
    }

    @Override
    protected String getName() {
        return this.solution.getName() + ": \n" + this.solution.getTextualInformation();
    }
}

