/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.editor.structure.visual;

import javafx.scene.image.Image;
import javafx.scene.paint.Paint;
import org.fortiss.af3.safetycases.model.Change;
import org.fortiss.af3.safetycases.model.Strategy;
import org.fortiss.af3.safetycases.model.maintenanceStatus;
import org.fortiss.af3.safetycases.ui.AF3SafetyCasesUIActivator;
import org.fortiss.af3.safetycases.ui.DefaultStyle;
import org.fortiss.af3.safetycases.ui.editor.structure.visual.LayoutedRhomboidContentVisualBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramLayers;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;

public class StrategyVisual
extends LayoutedRhomboidContentVisualBase<Strategy> {
    private static final Image ICON = AF3SafetyCasesUIActivator.getFXImage("/icons/strategy.png");
    private boolean isPotentiallyImpacted = false;
    private boolean isActuallyImpacted = false;
    Strategy strategy = this.getStrategy();

    public StrategyVisual(IContentMVCBundle mvcb) {
        super(mvcb, Strategy.class);
        Object model = mvcb.getModel();
        if (!(model instanceof Strategy)) {
            throw new IllegalArgumentException("Expected model of type Strategy, but was " + model.getClass().getSimpleName());
        }
    }

    private Strategy getStrategy() {
        return (Strategy)this.getModel();
    }

    protected Paint getFillColor() {
        if (!this.strategy.getAffectedByCurrentChanges().isEmpty()) {
            for (Change strategyTypeOfChange : this.strategy.getAffectedByCurrentChanges()) {
                if (strategyTypeOfChange.getMaintainanceCause().equals((Object)maintenanceStatus.CHALLENGED)) {
                    return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.CHALLENGED_COLOR);
                }
                if (strategyTypeOfChange.getMaintainanceCause().equals((Object)maintenanceStatus.ACTUALLY_IMPACTED)) {
                    this.isActuallyImpacted = true;
                    continue;
                }
                if (!strategyTypeOfChange.getMaintainanceCause().equals((Object)maintenanceStatus.POTENTIALLY_IMPACTED)) continue;
                this.isPotentiallyImpacted = true;
            }
        }
        if (this.isActuallyImpacted) {
            this.isActuallyImpacted = false;
            return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.ACTUALLY_IMPACTED_COLOR);
        }
        if (this.isPotentiallyImpacted) {
            this.isPotentiallyImpacted = false;
            return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.POTENTIALLY_IMPACTED_COLOR);
        }
        if (this.strategy.isToBeDeveloped() || this.strategy.isToBeInstantiated()) {
            return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.TO_BE_FINALIZED_COLOR);
        }
        return AF3SafetyCasesUIActivator.convertColor(DefaultStyle.DEFAULT);
    }

    public void updateNodes(DiagramLayers layers) {
        super.updateNodes(layers);
        this.text.setWrappingWidth(this.text.getWrappingWidth() - this.getOffset());
    }

    protected Image getIcon() {
        return ICON;
    }

    @Override
    protected String getName() {
        return this.strategy.getName() + ": \n" + this.strategy.getTextualInformation();
    }
}

