/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.properties;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fortiss.af3.allocation.utils.AllocationUtils;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.mira.model.Analysis;
import org.fortiss.af3.mira.model.Requirement;
import org.fortiss.af3.mira.model.RequirementsContainer;
import org.fortiss.af3.mira.model.RequirementsPackage;
import org.fortiss.af3.mode.model.Mode;
import org.fortiss.af3.mode.model.ModeAutomaton;
import org.fortiss.af3.platform.model.IPlatformArchitectureElement;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.platform.model.allocation.ComponentToExecutionUnitAllocationTable;
import org.fortiss.af3.safetycases.model.ASSESSMENT_STATUS;
import org.fortiss.af3.safetycases.model.ArgumentElement;
import org.fortiss.af3.safetycases.model.ArgumentElementBase;
import org.fortiss.af3.safetycases.model.AwayArgumentElement;
import org.fortiss.af3.safetycases.model.AwaySolution;
import org.fortiss.af3.safetycases.model.OptionEntity;
import org.fortiss.af3.safetycases.model.SafetyCasesPackage;
import org.fortiss.af3.safetycases.model.SafetyModule;
import org.fortiss.af3.safetycases.model.Solution;
import org.fortiss.af3.safetycases.utils.SafetyCasesUtils;
import org.fortiss.af3.state.model.State;
import org.fortiss.af3.state.model.StateAutomaton;
import org.fortiss.af3.state.ui.utils.StateFieldAssistUtils;
import org.fortiss.tooling.base.model.base.HierarchicElementBase;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.ui.fieldassist.FieldAssist;
import org.fortiss.tooling.base.ui.fieldassist.IProposalProvider;
import org.fortiss.tooling.base.ui.fieldassist.ProposalProviderBase;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.base.PropertySectionBase;
import org.fortiss.tooling.kernel.ui.util.DataBindingUtils;
import org.fortiss.tooling.kernel.ui.util.ObservableUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class ArgumentElementPropertySection
extends PropertySectionBase {
    private ArgumentElementBase currentlySelectedGSNElement;
    private int MAX_NUMBER_OF_AF3_ELEMENTS = 100;
    protected Text idText;
    private Text claimText;
    private Text documentReferenceExplText;
    private Button addDocumentReferenceButton;
    private Button removeDocumentReferenceButton;
    private Label documentReferenceLabel;
    private Link documentReferenceLink;
    private Text creatorText;
    private Text lastModifiedText;
    private ComboViewer assessmentStatusCombo;
    private Text lastAssessedText;
    private boolean userSelection;

    public void createControls(final Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.idText = this.createFormText("ID");
        this.idText.setData(DataBindingUtils.DECORATION_KEY, (Object)new ControlDecoration((Control)this.idText, 16512));
        this.idText.setVisible(true);
        if (!(this.currentlySelectedGSNElement instanceof Solution) && !(this.currentlySelectedGSNElement instanceof AwaySolution)) {
            this.claimText = this.createFormText("Claim", 2);
            this.claimText.setData(DataBindingUtils.DECORATION_KEY, (Object)new ControlDecoration((Control)this.claimText, 16512));
            try {
                this.setupFieldAssist();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.creatorText = this.createFormText("Creator");
        this.lastModifiedText = this.createFormText("Last modified");
        this.createLastAssessmentDate(this.lastModifiedText);
        this.createAssessmentDropDown();
        this.lastAssessedText = this.createFormText("Last assessment");
        this.createLastAssessmentDate(this.lastAssessedText);
        this.createDocumentReference();
        this.addDocumentReferenceButton = this.getWidgetFactory().createButton(this.composite, "         Add document         ", 0x800000);
        this.addDocumentReferenceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean go;
                if (ArgumentElementPropertySection.this.currentlySelectedGSNElement.getDocumentReference() != null && ArgumentElementPropertySection.this.currentlySelectedGSNElement.getDocumentReference() != "" && !(go = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"", (String)"This element already has a document reference.Are you sure you want to replace the reference to this document?"))) {
                    return;
                }
                final String filenameStr = ArgumentElementPropertySection.this.openFileDialog(parent.getShell());
                ArgumentElementPropertySection.this.documentReferenceLink.setText("<a>" + filenameStr + "</a>");
                ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)ArgumentElementPropertySection.this.currentlySelectedGSNElement);
                topLevel.runAsCommand(new Runnable(){

                    @Override
                    public void run() {
                        (this).ArgumentElementPropertySection.this.currentlySelectedGSNElement.setDocumentReference(filenameStr);
                        (this).ArgumentElementPropertySection.this.documentReferenceLink.setText("<a>" + (this).ArgumentElementPropertySection.this.currentlySelectedGSNElement.getDocumentReference() + "</a>");
                        (this).ArgumentElementPropertySection.this.documentReferenceLink.setEnabled(true);
                        (this).ArgumentElementPropertySection.this.removeDocumentReferenceButton.setEnabled(true);
                    }
                });
                ArgumentElementPropertySection.this.openDocument(filenameStr);
            }
        });
        this.removeDocument();
    }

    private void removeDocument() {
        this.removeDocumentReferenceButton = this.getWidgetFactory().createButton(this.composite, "        Remove document        ", 0x800000);
        this.removeDocumentReferenceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)ArgumentElementPropertySection.this.currentlySelectedGSNElement);
                topLevel.runAsCommand(new Runnable(){

                    @Override
                    public void run() {
                        boolean go = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"", (String)"Are you sure you want to delete the reference to this document?");
                        if (!go) {
                            return;
                        }
                        (this).ArgumentElementPropertySection.this.currentlySelectedGSNElement.setDocumentReference("");
                        (this).ArgumentElementPropertySection.this.currentlySelectedGSNElement.setInfoDocumentReference("");
                        (this).ArgumentElementPropertySection.this.documentReferenceLink.setText("");
                        (this).ArgumentElementPropertySection.this.documentReferenceExplText.setText("");
                        (this).ArgumentElementPropertySection.this.removeDocumentReferenceButton.setEnabled(false);
                    }
                });
            }
        });
    }

    protected void setSectionInput(Object input) {
        this.currentlySelectedGSNElement = (ArgumentElementBase)input;
        this.userSelection = false;
        this.assessmentStatusCombo.setSelection((ISelection)new StructuredSelection((Object)((ArgumentElement)this.currentlySelectedGSNElement).getAssessmentStatus()));
        this.userSelection = true;
    }

    private void createDocumentReference() {
        this.documentReferenceLabel = this.getWidgetFactory().createLabel(this.composite, "Document Ref");
        this.documentReferenceLabel.setToolTipText("The claim made by this argument element is backed by this document");
        this.documentReferenceLink = new Link(this.composite, 2);
        this.documentReferenceLink.setText("<a>No referenced file</a>");
        this.documentReferenceLink.setToolTipText("The referenced file");
        this.documentReferenceExplText = this.createFormText("Ref Explanation");
    }

    private void createLastAssessmentDate(Text text) {
        text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Text text = (Text)e.getSource();
                String oldS = text.getText();
                String newS = oldS.substring(0, e.start) + e.text + oldS.substring(e.end);
                if (newS.length() > 0) {
                    int lastChar = newS.length() - 1;
                    e.doit = newS.charAt(lastChar) == '/' || newS.charAt(lastChar) == '.' || newS.charAt(lastChar) == '-' || "dd/MM/yyyy".contains(newS) || Character.isDigit(newS.charAt(lastChar));
                }
            }
        });
    }

    public void refresh() {
        super.refresh();
        boolean isSolution = this.currentlySelectedGSNElement instanceof Solution;
        if (this.claimText != null) {
            this.claimText.setEnabled(isSolution);
        }
        if (this.currentlySelectedGSNElement instanceof OptionEntity || this.currentlySelectedGSNElement instanceof SafetyModule || this.currentlySelectedGSNElement instanceof AwayArgumentElement) {
            this.addDocumentReferenceButton.setEnabled(false);
            this.removeDocumentReferenceButton.setEnabled(false);
            this.documentReferenceExplText.setEnabled(false);
            this.claimText.setEnabled(false);
        } else {
            this.addDocumentReferenceButton.setEnabled(true);
            this.removeDocumentReferenceButton.setEnabled(true);
            this.documentReferenceExplText.setEnabled(true);
            this.claimText.setEnabled(true);
        }
        DataBindingUtils.performComplexTextBinding((DataBindingContext)this.dbc, (Control)this.idText, (IObservableValue)ObservableUtils.observeValue((EObject)this.currentlySelectedGSNElement, (EStructuralFeature)SafetyCasesPackage.Literals.ARGUMENT_ELEMENT_BASE__GSN_ID), null, null, null, null);
        DataBindingUtils.performComplexTextBinding((DataBindingContext)this.dbc, (Control)this.claimText, (IObservableValue)ObservableUtils.observeValue((EObject)this.currentlySelectedGSNElement, (EStructuralFeature)SafetyCasesPackage.Literals.ARGUMENT_ELEMENT__TEXTUAL_INFORMATION), null, null, null, null);
        DataBindingUtils.performComplexTextBinding((DataBindingContext)this.dbc, (Control)this.creatorText, (IObservableValue)ObservableUtils.observeValue((EObject)this.currentlySelectedGSNElement, (EStructuralFeature)SafetyCasesPackage.Literals.ARGUMENT_ELEMENT__CREATOR), null, null, null, null);
        DataBindingUtils.performComplexTextBinding((DataBindingContext)this.dbc, (Control)this.lastModifiedText, (IObservableValue)ObservableUtils.observeValue((EObject)this.currentlySelectedGSNElement, (EStructuralFeature)SafetyCasesPackage.Literals.ARGUMENT_ELEMENT__LAST_MODIFIED), null, null, null, null);
        DataBindingUtils.performComplexTextBinding((DataBindingContext)this.dbc, (Control)this.documentReferenceExplText, (IObservableValue)ObservableUtils.observeValue((EObject)this.currentlySelectedGSNElement, (EStructuralFeature)SafetyCasesPackage.Literals.ARGUMENT_ELEMENT_BASE__INFO_DOCUMENT_REFERENCE), null, null, null, null);
        DataBindingUtils.performComplexTextBinding((DataBindingContext)this.dbc, (Control)this.lastAssessedText, (IObservableValue)ObservableUtils.observeValue((EObject)this.currentlySelectedGSNElement, (EStructuralFeature)SafetyCasesPackage.Literals.ARGUMENT_ELEMENT__LAST_ASSESSMENT_DATE), null, null, null, null);
        if (this.currentlySelectedGSNElement.getDocumentReference() != null && this.currentlySelectedGSNElement.getDocumentReference() != "") {
            this.documentReferenceLink.setText("<a>" + this.currentlySelectedGSNElement.getDocumentReference() + "</a>");
            this.documentReferenceLink.setEnabled(true);
            this.removeDocumentReferenceButton.setEnabled(true);
        } else {
            this.documentReferenceLink.setText("");
            this.removeDocumentReferenceButton.setEnabled(false);
        }
    }

    private void setupFieldAssist() {
        new FieldAssist(this.claimText, (IProposalProvider)new ProposalProviderBase(){

            public String[] getProposals(String currentWord) {
                String[] af3ElementsNames = new String[ArgumentElementPropertySection.this.MAX_NUMBER_OF_AF3_ELEMENTS];
                ArrayList<INamedElement> list = new ArrayList<INamedElement>();
                int index = 0;
                ArrayList componentsList = SafetyCasesUtils.getAllLogicalComponents((HierarchicElementBase)ArgumentElementPropertySection.this.currentlySelectedGSNElement);
                list.addAll(componentsList);
                List analysisList = KernelModelElementUtils.getRootElements((EObject)ArgumentElementPropertySection.this.currentlySelectedGSNElement, Analysis.class);
                af3ElementsNames[index++] = "@requirement(<no requirement>)";
                for (Analysis an : analysisList) {
                    EList<Requirement> req = ArgumentElementPropertySection.this.getRequirements(an);
                    Iterator iterator = req.iterator();
                    while (iterator.hasNext()) {
                        Requirement r = (Requirement)iterator.next();
                        if (r == null || r.getName() == null) continue;
                        af3ElementsNames[index++] = "@requirement(" + r.getName() + ")";
                        list.add((INamedElement)r);
                    }
                }
                af3ElementsNames[index++] = "@component(<no component>)";
                if (!componentsList.isEmpty()) {
                    af3ElementsNames[index++] = "@state(<no state>)";
                    af3ElementsNames[index++] = "@mode(<no mode>)";
                }
                for (Component comp : componentsList) {
                    af3ElementsNames[index++] = "@component(" + comp.getName() + ")";
                    EList modeAutomata = EcoreUtils.pickInstanceOf(ModeAutomaton.class, (List)comp.getSpecifications());
                    for (ModeAutomaton ma : modeAutomata) {
                        for (Mode m : ma.getRootMode().getSubModes()) {
                            af3ElementsNames[index++] = "@mode(" + m.getName() + ")";
                            list.add((INamedElement)m);
                        }
                    }
                    EList stateAutomata = EcoreUtils.pickInstanceOf(StateAutomaton.class, (List)comp.getSpecifications());
                    for (StateAutomaton sa : stateAutomata) {
                        for (State s : sa.getRootState().getSubStates()) {
                            af3ElementsNames[index++] = "@state(" + s.getName() + ")";
                            list.add((INamedElement)s);
                        }
                        ArrayList dataStateVar = StateFieldAssistUtils.getDataStateVariables((StateAutomaton)sa);
                        for (String dsv : dataStateVar) {
                            af3ElementsNames[index++] = "@stateVariable(" + dsv + ")";
                        }
                    }
                }
                List parchList = KernelModelElementUtils.getRootElements((EObject)ArgumentElementPropertySection.this.currentlySelectedGSNElement, PlatformArchitecture.class);
                af3ElementsNames[index++] = "@platform(<no platform>)";
                for (PlatformArchitecture pa : parchList) {
                    af3ElementsNames[index++] = "@platform(" + pa.getName() + ")";
                    list.add((INamedElement)pa);
                    for (IHierarchicElement ihe : pa.getContainedElements()) {
                        if (!(ihe instanceof INamedElement)) continue;
                        af3ElementsNames[index++] = "@platform(" + ((INamedElement)ihe).getName() + ")";
                        list.add((INamedElement)ihe);
                    }
                }
                EList ca2hwList = AllocationUtils.getAllocationTables((EObject)ArgumentElementPropertySection.this.currentlySelectedGSNElement, ComponentToExecutionUnitAllocationTable.class);
                af3ElementsNames[index++] = "@allocation(<no allocation>)";
                for (ComponentToExecutionUnitAllocationTable ca2hw : ca2hwList) {
                    af3ElementsNames[index++] = "@allocation(" + ca2hw.getName() + ")";
                    list.add((INamedElement)ca2hw);
                }
                String[] proposals = new String[index];
                index = 0;
                String[] stringArray = af3ElementsNames;
                int n = af3ElementsNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (s != null) {
                        proposals[index++] = s;
                    }
                    ++n2;
                }
                if ((proposals = ArgumentElementPropertySection.this.matchPattern(proposals, list)).equals(null)) {
                    return new String[1];
                }
                return proposals;
            }
        });
    }

    private String openFileDialog(Shell shell) {
        FileDialog fileChooser = new FileDialog(shell, 4096);
        fileChooser.setText("Open files");
        fileChooser.setFilterExtensions(new String[]{"*.pdf;*.doc;*.xslx;"});
        return fileChooser.open();
    }

    private void openDocument(String path) {
        File file = new File(path);
        Desktop desktop = Desktop.getDesktop();
        if (file.exists()) {
            try {
                desktop.open(file);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public String[] matchPattern(String[] proposals, ArrayList<INamedElement> list) {
        block22: {
            if (this.containsPattern().equals("")) break block22;
            switch (this.containsPattern()) {
                case "component": {
                    proposals = (String[])list.stream().filter(i -> i instanceof Component).map(e -> e.getName()).toArray(String[]::new);
                    proposals = (String[])ArrayUtils.add((Object[])proposals, (int)0, (Object)"<no component>");
                    break;
                }
                case "state": {
                    proposals = (String[])list.stream().filter(i -> i instanceof State).map(e -> e.getName()).toArray(String[]::new);
                    proposals = (String[])ArrayUtils.add((Object[])proposals, (int)0, (Object)"<no state>");
                    break;
                }
                case "mode": {
                    proposals = (String[])list.stream().filter(i -> i instanceof Mode).map(e -> e.getName()).toArray(String[]::new);
                    proposals = (String[])ArrayUtils.add((Object[])proposals, (int)0, (Object)"<no mode>");
                    break;
                }
                case "allocation": {
                    proposals = (String[])list.stream().filter(i -> i instanceof ComponentToExecutionUnitAllocationTable).map(e -> e.getName()).toArray(String[]::new);
                    proposals = (String[])ArrayUtils.add((Object[])proposals, (int)0, (Object)"<no allocation>");
                    break;
                }
                case "requirement": {
                    proposals = (String[])list.stream().filter(i -> i instanceof Requirement).map(e -> e.getName()).toArray(String[]::new);
                    proposals = (String[])ArrayUtils.add((Object[])proposals, (int)0, (Object)"<no requirement>");
                    break;
                }
                case "platform": {
                    proposals = (String[])list.stream().filter(i -> i instanceof PlatformArchitecture || i instanceof IPlatformArchitectureElement).map(e -> e.getName()).toArray(String[]::new);
                    proposals = (String[])ArrayUtils.add((Object[])proposals, (int)0, (Object)"<no platform>");
                    break;
                }
            }
        }
        return proposals;
    }

    private void createAssessmentDropDown() {
        this.assessmentStatusCombo = this.createFormComboViewer("Assessment status");
        this.assessmentStatusCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.assessmentStatusCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ASSESSMENT_STATUS) {
                    ASSESSMENT_STATUS status = (ASSESSMENT_STATUS)element;
                    if (status.equals((Object)ASSESSMENT_STATUS.NOT_REVIEWED)) {
                        return "Not Reviewed";
                    }
                    if (status.equals((Object)ASSESSMENT_STATUS.REVIEW_LATER)) {
                        return "Review Later";
                    }
                    if (status.equals((Object)ASSESSMENT_STATUS.ACCEPTED)) {
                        return "Accepted";
                    }
                    if (status.equals((Object)ASSESSMENT_STATUS.WEAK)) {
                        return "Weak";
                    }
                    return "Incorrect";
                }
                return null;
            }
        });
        this.assessmentStatusCombo.setInput((Object)ASSESSMENT_STATUS.values());
        this.assessmentStatusCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                ASSESSMENT_STATUS value = (ASSESSMENT_STATUS)sel.getFirstElement();
                if (ArgumentElementPropertySection.this.userSelection && sel.getFirstElement() instanceof ASSESSMENT_STATUS) {
                    ArgumentElementPropertySection.this.assessmentStatusChangeHandler(value);
                }
            }
        });
    }

    private void assessmentStatusChangeHandler(final ASSESSMENT_STATUS value) {
        ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)this.currentlySelectedGSNElement);
        topLevel.runAsCommand(new Runnable(){

            @Override
            public void run() {
                ((ArgumentElement)ArgumentElementPropertySection.this.currentlySelectedGSNElement).setAssessmentStatus(value);
            }
        });
    }

    private String containsPattern() {
        Matcher m = Pattern.compile("\\@(.*?)\\((.*?)\\)").matcher(this.claimText.getText());
        int pos = this.claimText.getCaretPosition();
        while (m.find()) {
            if (pos < m.start() || pos > m.end() || pos <= 0 || pos > this.claimText.getText().length() - 1 || this.claimText.getText().charAt(pos - 1) != '(' || this.claimText.getText().charAt(pos) != ')') continue;
            return m.group(1);
        }
        return "";
    }

    private EList<Requirement> getRequirements(Analysis analysis) {
        return EcoreUtils.pickInstanceOf(Arrays.asList(RequirementsContainer.class, RequirementsPackage.class, Requirement.class), (List)analysis.getRequirementsList());
    }
}

