/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.properties;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fortiss.af3.safetycases.model.Change;
import org.fortiss.af3.safetycases.ui.utils.Utils;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.ui.extension.base.PropertySectionBase;
import org.fortiss.tooling.kernel.ui.service.IModelEditorBindingService;

public class ChangePropertySection
extends PropertySectionBase {
    private Link referenceLink;
    private Change selectedChange;
    private Label maintenanceStatusContent;
    private Label typeOfChange;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.getWidgetFactory().createLabel(this.composite, "Maintenance Status:");
        this.maintenanceStatusContent = this.getWidgetFactory().createLabel(this.composite, "");
        this.getWidgetFactory().createLabel(this.composite, "Type of change:");
        this.typeOfChange = this.getWidgetFactory().createLabel(this.composite, "");
        this.getWidgetFactory().createLabel(this.composite, "Referenced ModelElement:");
        this.referenceLink = new Link(this.composite, 2);
        this.referenceLink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IModelEditorBindingService.getInstance().openInEditor((EObject)ChangePropertySection.this.selectedChange.getModelElement());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void setSectionInput(Object input) {
        this.selectedChange = (Change)input;
    }

    public void refresh() {
        super.refresh();
        if (this.selectedChange.getPersonalizedTypeOfChange() != null) {
            this.typeOfChange.setText(this.selectedChange.getPersonalizedTypeOfChange());
        } else if (this.selectedChange.getPredefinedTypeOfChange() != null) {
            this.typeOfChange.setText(this.selectedChange.getPredefinedTypeOfChange().toString());
        }
        this.maintenanceStatusContent.setText(Utils.returnStringTypeOfMaintenance(this.selectedChange.getMaintainanceCause()));
        if (this.selectedChange.getModelElement() != null) {
            String name = ((INamedCommentedElement)this.selectedChange.getModelElement()).getName();
            this.referenceLink.setText("<a>" + name + "</a>");
        }
    }
}

