/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.properties;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fortiss.af3.safetycases.model.SafetyCasesConnection;
import org.fortiss.af3.safetycases.model.SafetyCasesPackage;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.base.PropertySectionBase;
import org.fortiss.tooling.kernel.ui.util.DataBindingUtils;
import org.fortiss.tooling.kernel.ui.util.ObservableUtils;

public class ConnectionPropertySection
extends PropertySectionBase {
    private SafetyCasesConnection currentlySelectedConnection;
    private Text multiplicityExplText;
    private Button isOptionalButton;
    private Button isMultipliableButton;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.multiplicityExplText = this.createFormText("Multiplicity Explanation");
        this.multiplicityExplText.setEnabled(false);
        this.multiplicityExplText.setEditable(false);
        this.isOptionalButton = this.getWidgetFactory().createButton(this.composite, "Is optional", 32);
        this.isOptionalButton.setToolTipText("Optional and alternative relationships between GSN elements.");
        this.isOptionalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConnectionPropertySection.this.currentlySelectedConnection != null) {
                    ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)ConnectionPropertySection.this.currentlySelectedConnection);
                    topLevel.runAsCommand(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).ConnectionPropertySection.this.isOptionalButton.getSelection()) {
                                (this).ConnectionPropertySection.this.currentlySelectedConnection.setOptional(true);
                                (this).ConnectionPropertySection.this.isOptionalButton.setEnabled(true);
                            } else {
                                (this).ConnectionPropertySection.this.currentlySelectedConnection.setOptional(false);
                            }
                        }
                    });
                }
            }
        });
        this.isMultipliableButton = this.getWidgetFactory().createButton(this.composite, "Is Multipliable", 32);
        this.isMultipliableButton.setToolTipText("Multiplicity of a GSN element.");
        this.isMultipliableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConnectionPropertySection.this.currentlySelectedConnection != null) {
                    ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)ConnectionPropertySection.this.currentlySelectedConnection);
                    topLevel.runAsCommand(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).ConnectionPropertySection.this.isMultipliableButton.getSelection()) {
                                (this).ConnectionPropertySection.this.currentlySelectedConnection.setMultipliable(true);
                                (this).ConnectionPropertySection.this.isMultipliableButton.setEnabled(true);
                            } else {
                                (this).ConnectionPropertySection.this.currentlySelectedConnection.setMultipliable(false);
                            }
                        }
                    });
                }
            }
        });
    }

    protected void setSectionInput(Object input) {
        this.currentlySelectedConnection = (SafetyCasesConnection)input;
    }

    public void refresh() {
        super.refresh();
        this.multiplicityExplText.setEnabled(false);
        if (this.currentlySelectedConnection.isOptional()) {
            this.isOptionalButton.setEnabled(true);
            this.isOptionalButton.setSelection(true);
        } else {
            this.isOptionalButton.setSelection(false);
        }
        if (this.currentlySelectedConnection.isMultipliable()) {
            this.isMultipliableButton.setEnabled(true);
            this.isMultipliableButton.setSelection(true);
        } else {
            this.isMultipliableButton.setSelection(false);
        }
        IObservableValue modelObservableMultiplicityExpl = ObservableUtils.observeValue((EObject)this.currentlySelectedConnection, (EStructuralFeature)SafetyCasesPackage.Literals.SAFETY_CASES_CONNECTION__MULTIPLICITY_EXPLANATION);
        this.dbc.bindValue((IObservableValue)DataBindingUtils.observeText((Control)this.multiplicityExplText, (int)0), modelObservableMultiplicityExpl, null, null);
    }
}

