/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.properties;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fortiss.af3.component.AF3ComponentActivator;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.PortSpecification;
import org.fortiss.af3.component.ui.AF3ComponentUIActivator;
import org.fortiss.af3.component.utils.ComponentArchitectureUtils;
import org.fortiss.af3.expression.model.types.TInt;
import org.fortiss.af3.safetycases.model.Context;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.base.PropertySectionBase;
import org.fortiss.tooling.kernel.ui.util.WidgetsFactory;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class ContextPropertySection
extends PropertySectionBase {
    private static final int MAX_CHARACTERS_NUMBER = 6;
    private boolean inputPortsFlag = false;
    private boolean outputPortsFlag = false;
    private Port port;
    private PortSpecification spec = null;
    private Label referencedInputPortsLabel;
    private Label referencedOutputPortsLabel;
    private Label testLabel;
    private Label emptyLabel;
    private ITopLevelElement topLevel;
    private Context currentlySelectedContext;
    private Composite variableBounds;
    private Text upperBound;
    private Text lowerBound;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
    }

    protected void setSectionInput(Object input) {
        if (input instanceof EObject) {
            this.topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)input);
        }
        this.currentlySelectedContext = (Context)input;
        if (!this.inputPortsFlag && !this.currentlySelectedContext.getInputPorts().isEmpty()) {
            this.createReferencedInputPortsInfo();
            this.inputPortsFlag = true;
        }
        if (!this.outputPortsFlag && !this.currentlySelectedContext.getOutputPorts().isEmpty()) {
            this.createReferencedOutputInfo();
            this.outputPortsFlag = true;
        }
    }

    public void refresh() {
        if (this.currentlySelectedContext != null) {
            this.refreshBoundsControls();
        }
    }

    public void createReferencedInputPortsInfo() {
        this.referencedInputPortsLabel = this.getWidgetFactory().createLabel(this.composite, "Referenced Input Ports");
        this.testLabel = this.getWidgetFactory().createLabel(this.composite, "                    ");
        this.referencedInputPortsLabel.setToolTipText("The referenced input ports to the assumption");
        if (!this.currentlySelectedContext.getInputPorts().isEmpty()) {
            int i = 0;
            while (i < this.currentlySelectedContext.getInputPorts().size()) {
                this.port = (Port)this.currentlySelectedContext.getInputPorts().get(i);
                this.spec = ((InputPort)this.currentlySelectedContext.getInputPorts().get(i)).getPortSpecification();
                this.variableBounds = this.getWidgetFactory().createComposite(this.composite);
                this.variableBounds.setLayout((Layout)new GridLayout(12, false));
                this.lowerBound = WidgetsFactory.createText((Composite)this.variableBounds, (int)2048, (String)"", (int)6);
                this.getWidgetFactory().createLabel(this.variableBounds, "...");
                this.lowerBound.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        ContextPropertySection.this.topLevel.runAsCommand(new Runnable(){

                            @Override
                            public void run() {
                                ContextPropertySection.this.lowerBoundHandler();
                            }
                        });
                    }
                });
                this.upperBound = WidgetsFactory.createText((Composite)this.variableBounds, (int)2048, (String)"", (int)6);
                this.upperBound.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        ContextPropertySection.this.topLevel.runAsCommand(new Runnable(){

                            @Override
                            public void run() {
                                ContextPropertySection.this.upperBoundHandler();
                            }
                        });
                    }
                });
                this.getWidgetFactory().createLabel(this.variableBounds, "U");
                WidgetsFactory.createText((Composite)this.variableBounds, (int)2048, (String)"", (int)6);
                this.getWidgetFactory().createLabel(this.variableBounds, "...");
                WidgetsFactory.createText((Composite)this.variableBounds, (int)2048, (String)"", (int)6);
                this.getWidgetFactory().createLabel(this.variableBounds, "U");
                WidgetsFactory.createText((Composite)this.variableBounds, (int)2048, (String)"", (int)6);
                this.getWidgetFactory().createLabel(this.variableBounds, "...");
                WidgetsFactory.createText((Composite)this.variableBounds, (int)2048, (String)"", (int)6);
                this.createFormEntry((Control)this.variableBounds, ((InputPort)this.currentlySelectedContext.getInputPorts().get(i)).getName());
                if (this.spec == null) {
                    LoggingUtils.error((Plugin)AF3ComponentUIActivator.getDefault(), (String)"PortSpecificationPropertySection input is null!");
                } else {
                    try {
                        this.refreshBoundsControls();
                    }
                    catch (ClassCastException ex) {
                        LoggingUtils.error((Plugin)AF3ComponentActivator.getDefault(), (String)"The port parent component was not found.", (Throwable)ex);
                    }
                }
                ++i;
            }
        }
    }

    public void createReferencedOutputInfo() {
        this.referencedOutputPortsLabel = this.getWidgetFactory().createLabel(this.composite, "Referenced Output Ports");
        this.emptyLabel = this.getWidgetFactory().createLabel(this.composite, "                    ");
        this.referencedOutputPortsLabel.setToolTipText("The input ports referenced by the assumption");
        if (!this.currentlySelectedContext.getOutputPorts().isEmpty()) {
            int i = 0;
            while (i < this.currentlySelectedContext.getOutputPorts().size()) {
                this.port = (Port)this.currentlySelectedContext.getOutputPorts().get(i);
                this.spec = ((OutputPort)this.currentlySelectedContext.getOutputPorts().get(i)).getPortSpecification();
                this.variableBounds = this.getWidgetFactory().createComposite(this.composite);
                this.variableBounds.setLayout((Layout)new GridLayout(12, false));
                this.lowerBound = WidgetsFactory.createText((Composite)this.variableBounds, (int)2048, (String)"", (int)6);
                this.getWidgetFactory().createLabel(this.variableBounds, "...");
                this.lowerBound.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        ContextPropertySection.this.topLevel.runAsCommand(new Runnable(){

                            @Override
                            public void run() {
                                ContextPropertySection.this.lowerBoundHandler();
                            }
                        });
                    }
                });
                this.upperBound = WidgetsFactory.createText((Composite)this.variableBounds, (int)2048, (String)"", (int)6);
                this.upperBound.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        ContextPropertySection.this.topLevel.runAsCommand(new Runnable(){

                            @Override
                            public void run() {
                                ContextPropertySection.this.upperBoundHandler();
                            }
                        });
                    }
                });
                this.getWidgetFactory().createLabel(this.variableBounds, "U");
                WidgetsFactory.createText((Composite)this.variableBounds, (int)2048, (String)"", (int)6);
                this.getWidgetFactory().createLabel(this.variableBounds, "...");
                WidgetsFactory.createText((Composite)this.variableBounds, (int)2048, (String)"", (int)6);
                this.getWidgetFactory().createLabel(this.variableBounds, "U");
                WidgetsFactory.createText((Composite)this.variableBounds, (int)2048, (String)"", (int)6);
                this.getWidgetFactory().createLabel(this.variableBounds, "...");
                WidgetsFactory.createText((Composite)this.variableBounds, (int)2048, (String)"", (int)6);
                this.createFormEntry((Control)this.variableBounds, ((OutputPort)this.currentlySelectedContext.getOutputPorts().get(i)).getName());
                if (this.spec == null) {
                    LoggingUtils.error((Plugin)AF3ComponentUIActivator.getDefault(), (String)"PortSpecificationPropertySection input is null!");
                } else {
                    try {
                        this.refreshBoundsControls();
                    }
                    catch (ClassCastException ex) {
                        LoggingUtils.error((Plugin)AF3ComponentActivator.getDefault(), (String)"The port parent component was not found.", (Throwable)ex);
                    }
                }
                ++i;
            }
        }
    }

    private void lowerBoundHandler() {
        if (this.spec != null && this.spec.getType() instanceof TInt) {
            TInt intType = (TInt)this.spec.getType();
            Integer boundValue = Integer.parseInt(this.lowerBound.getText());
            intType.setLowerBound(boundValue.intValue());
        }
    }

    private void upperBoundHandler() {
        if (this.spec.getType() instanceof TInt) {
            TInt intType = (TInt)this.spec.getType();
            Integer boundValue = Integer.parseInt(this.upperBound.getText());
            intType.setUpperBound(boundValue.intValue());
        }
    }

    private void refreshBoundsControls() {
        if (!this.currentlySelectedContext.getInputPorts().isEmpty() || !this.currentlySelectedContext.getOutputPorts().isEmpty()) {
            if (this.spec.getType() instanceof TInt) {
                TInt intType = (TInt)this.spec.getType();
                this.lowerBound.setText("" + intType.getLowerBound());
                this.upperBound.setText("" + intType.getUpperBound());
                if (ComponentArchitectureUtils.hasReadOnlyBehaviorSpecification((Component)this.port.getComponent())) {
                    this.disableBoundControls();
                } else {
                    this.enableBoundControls();
                }
            } else {
                this.upperBound.setText(" ");
                this.lowerBound.setText(" ");
                this.disableBoundControls();
            }
        }
    }

    public void enableBoundControls() {
        this.lowerBound.setEnabled(true);
        this.upperBound.setEnabled(true);
    }

    public void disableBoundControls() {
        this.lowerBound.setEnabled(false);
        this.upperBound.setEnabled(false);
    }
}

