/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.properties;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fortiss.af3.safetycases.model.ArgumentElement;
import org.fortiss.af3.safetycases.model.Context;
import org.fortiss.af3.safetycases.model.Goal;
import org.fortiss.af3.safetycases.model.Solution;
import org.fortiss.af3.safetycases.model.Strategy;
import org.fortiss.af3.safetycases.model.VISIBILITY;
import org.fortiss.af3.safetycases.model.maintenanceStatus;
import org.fortiss.af3.safetycases.ui.utils.MaintenanceUtils;
import org.fortiss.af3.safetycases.ui.utils.Utils;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.base.PropertySectionBase;

public class GSNStatesPropertySection
extends PropertySectionBase {
    private Button isInstantiatedCheckbox;
    private Button isChallengedCheckbox;
    private Button isUndevelopedCheckbox;
    private Button isPrivateCheckbox;
    private Button isPotentiallyImpactedCheckbox;
    private Button isActuallyImpactedCheckbox;
    private ArgumentElement currentlySelectedSection;
    private Label state;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.state = this.getWidgetFactory().createLabel(this.composite, "State");
        this.state.setToolTipText("The state of the GSN element");
        this.getWidgetFactory().createLabel(this.composite, "");
        this.isChallenged();
        this.isPotentiallyImpacted();
        this.isActuallyImpacted();
        this.isInstantiated();
        if (this.currentlySelectedSection instanceof Solution) {
            this.isPrivateCheckbox = this.getWidgetFactory().createButton(this.composite, "Is Private", 32);
            this.isPrivate();
            this.isUndevelopedCheckbox = this.getWidgetFactory().createButton(this.composite, "Is Developed", 32);
            this.isUndeveloped();
        } else {
            this.isUndevelopedCheckbox = this.getWidgetFactory().createButton(this.composite, "Is Developed", 32);
            this.isPrivateCheckbox = this.getWidgetFactory().createButton(this.composite, "Is Private", 32);
            this.isUndeveloped();
            this.isPrivate();
        }
    }

    private void isInstantiated() {
        this.isInstantiatedCheckbox = this.getWidgetFactory().createButton(this.composite, "Is Instantiated", 32);
        this.isInstantiatedCheckbox.setToolTipText("Shows whether the GSN entity was instatiated.");
        this.isInstantiatedCheckbox.setLayoutData((Object)new GridData(4, 16384, false, false));
        this.isInstantiatedCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GSNStatesPropertySection.this.currentlySelectedSection != null) {
                    ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)GSNStatesPropertySection.this.currentlySelectedSection);
                    topLevel.runAsCommand(new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).GSNStatesPropertySection.this.isInstantiatedCheckbox.getSelection()) {
                                (this).GSNStatesPropertySection.this.currentlySelectedSection.setToBeInstantiated(true);
                            } else {
                                Utils.cannotBeInstantiated((this).GSNStatesPropertySection.this.currentlySelectedSection);
                                if ((this).GSNStatesPropertySection.this.currentlySelectedSection.isToBeInstantiated()) {
                                    (this).GSNStatesPropertySection.this.isInstantiatedCheckbox.setSelection(false);
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    private void isChallenged() {
        this.isChallengedCheckbox = this.getWidgetFactory().createButton(this.composite, "Is Challenged", 32);
        this.isChallengedCheckbox.setLayoutData((Object)new GridData(4, 16384, false, false));
        this.isChallengedCheckbox.setToolTipText("Shows whether the GSN entity was challenged.");
        this.isChallengedCheckbox.setEnabled(false);
    }

    private void isUndeveloped() {
        this.isUndevelopedCheckbox.setLayoutData((Object)new GridData(4, 16384, false, false));
        this.isUndevelopedCheckbox.setToolTipText("Shows whether the GSN entity is to be developed.");
        this.isUndevelopedCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GSNStatesPropertySection.this.currentlySelectedSection != null) {
                    ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)GSNStatesPropertySection.this.currentlySelectedSection);
                    topLevel.runAsCommand(new Runnable(){

                        @Override
                        public void run() {
                            Utils.setUndevelopedEntity((this).GSNStatesPropertySection.this.currentlySelectedSection);
                        }
                    });
                }
            }
        });
    }

    private void isPrivate() {
        this.isPrivateCheckbox.setToolTipText("Shows whether the GSN entity is private.");
        this.isPrivateCheckbox.setLayoutData((Object)new GridData(4, 16384, false, false));
        this.isPrivateCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GSNStatesPropertySection.this.currentlySelectedSection != null) {
                    ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)GSNStatesPropertySection.this.currentlySelectedSection);
                    topLevel.runAsCommand(new Runnable(){

                        @Override
                        public void run() {
                            Utils.setToPrivateOrPublic((this).GSNStatesPropertySection.this.currentlySelectedSection);
                        }
                    });
                }
            }
        });
    }

    private void isPotentiallyImpacted() {
        this.isPotentiallyImpactedCheckbox = this.getWidgetFactory().createButton(this.composite, "Is Potentially-Impacted", 32);
        this.isPotentiallyImpactedCheckbox.setToolTipText("Shows whether the GSN entity is Potentially Impacted.");
        this.isPotentiallyImpactedCheckbox.setLayoutData((Object)new GridData(4, 16384, false, false));
    }

    private void isActuallyImpacted() {
        this.isActuallyImpactedCheckbox = this.getWidgetFactory().createButton(this.composite, "Is Actually-Impacted", 32);
        this.isActuallyImpactedCheckbox.setToolTipText("Shows whether the GSN entity is Actually Impacted.");
        this.isActuallyImpactedCheckbox.setLayoutData((Object)new GridData(4, 16384, false, false));
    }

    public void refresh() {
        if (this.currentlySelectedSection instanceof Goal || this.currentlySelectedSection instanceof Solution || this.currentlySelectedSection instanceof Context) {
            this.isPrivateCheckbox.setVisible(true);
            if (this.currentlySelectedSection instanceof Goal) {
                if (((Goal)this.currentlySelectedSection).getVisibility() == VISIBILITY.PRIVATE) {
                    this.isPrivateCheckbox.setSelection(true);
                } else {
                    this.isPrivateCheckbox.setSelection(false);
                }
            }
            if (this.currentlySelectedSection instanceof Solution) {
                if (((Solution)this.currentlySelectedSection).getVisibility() == VISIBILITY.PRIVATE) {
                    this.isPrivateCheckbox.setSelection(true);
                } else {
                    this.isPrivateCheckbox.setSelection(false);
                }
            }
            if (this.currentlySelectedSection instanceof Context) {
                if (((Context)this.currentlySelectedSection).getVisibility() == VISIBILITY.PRIVATE) {
                    this.isPrivateCheckbox.setSelection(true);
                } else {
                    this.isPrivateCheckbox.setSelection(false);
                }
            }
        } else {
            this.isPrivateCheckbox.setVisible(false);
        }
        this.isInstantiatedCheckbox.setSelection(!this.currentlySelectedSection.isToBeInstantiated());
        if (MaintenanceUtils.getActualMaintainanceStatus(this.currentlySelectedSection) == maintenanceStatus.CHALLENGED) {
            this.isChallengedCheckbox.setSelection(true);
        } else {
            this.isChallengedCheckbox.setSelection(false);
        }
        if (MaintenanceUtils.getActualMaintainanceStatus(this.currentlySelectedSection) == maintenanceStatus.POTENTIALLY_IMPACTED) {
            this.isPotentiallyImpactedCheckbox.setSelection(true);
        } else {
            this.isPotentiallyImpactedCheckbox.setSelection(false);
        }
        if (MaintenanceUtils.getActualMaintainanceStatus(this.currentlySelectedSection) == maintenanceStatus.ACTUALLY_IMPACTED) {
            this.isActuallyImpactedCheckbox.setSelection(true);
        } else {
            this.isActuallyImpactedCheckbox.setSelection(false);
        }
        this.setVisibleUndevelopedEntity();
        this.isActuallyImpactedCheckbox.setEnabled(false);
        this.isPotentiallyImpactedCheckbox.setEnabled(false);
        this.isChallengedCheckbox.setEnabled(false);
    }

    private void setVisibleUndevelopedEntity() {
        if (this.currentlySelectedSection instanceof Goal || this.currentlySelectedSection instanceof Strategy) {
            this.isUndevelopedCheckbox.setVisible(true);
            if (this.currentlySelectedSection instanceof Goal) {
                this.isUndevelopedCheckbox.setSelection(!((Goal)this.currentlySelectedSection).isToBeDeveloped());
            }
            if (this.currentlySelectedSection instanceof Strategy) {
                this.isUndevelopedCheckbox.setSelection(!((Strategy)this.currentlySelectedSection).isToBeDeveloped());
            }
        } else {
            this.isUndevelopedCheckbox.setVisible(false);
        }
    }

    protected void setSectionInput(Object input) {
        this.currentlySelectedSection = (ArgumentElement)input;
    }
}

