/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.util.Pair;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fortiss.af3.safetycases.model.ArgumentElement;
import org.fortiss.af3.safetycases.model.ArgumentElementBase;
import org.fortiss.af3.safetycases.model.EntryConnector;
import org.fortiss.af3.safetycases.model.SafetyCasesConnection;
import org.fortiss.af3.safetycases.model.SafetyCasesConnector;
import org.fortiss.af3.safetycases.model.SupportedBy;
import org.fortiss.af3.safetycases.ui.utils.InstantiationOfGSNElementsUtils;
import org.fortiss.af3.safetycases.utils.SafetyCasesModelElementFactory;
import org.fortiss.tooling.base.model.base.HierarchicElementBase;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.base.PropertySectionBase;

public class OptionalAndMultiplicityPropertySection
extends PropertySectionBase {
    private SafetyCasesConnection currentlySelectedConnection;
    private Button optionalDeleteButton;
    private Button multiplicityButton;
    private org.eclipse.swt.widgets.Label multiplicityLabel;
    private org.eclipse.swt.widgets.Label optionalDeleteButtonLabel;

    protected void setSectionInput(Object input) {
        this.currentlySelectedConnection = (SafetyCasesConnection)input;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.multiplicityLabel = this.getWidgetFactory().createLabel(this.composite, "Multiply Relationship: ");
        this.multiplicityLabel.setToolTipText("Multiply the selected relationship and all of the children argument elements which are connected to it.\n");
        this.multiplicityButton = this.getWidgetFactory().createButton(this.composite, " Multiply  ", 0x800000);
        this.multiplicityButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)OptionalAndMultiplicityPropertySection.this.currentlySelectedConnection);
                topLevel.runAsCommand(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).OptionalAndMultiplicityPropertySection.this.currentlySelectedConnection.isMultipliable()) {
                            OptionalAndMultiplicityPropertySection.this.multiply();
                        } else {
                            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"", (String)"In order to multiply a relationship, you have to set the connection as multipliable (use the checkbox).");
                        }
                    }
                });
            }
        });
        this.optionalDeleteButtonLabel = this.getWidgetFactory().createLabel(this.composite, "Delete Optional Relationship: ");
        this.optionalDeleteButtonLabel.setToolTipText("Delete the selected relationship and all of the children argument elements which are connected to it.\n");
        this.optionalDeleteButton = this.getWidgetFactory().createButton(this.composite, " Remove relationship  ", 0x800000);
        this.optionalDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)OptionalAndMultiplicityPropertySection.this.currentlySelectedConnection);
                topLevel.runAsCommand(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).OptionalAndMultiplicityPropertySection.this.currentlySelectedConnection.isOptional()) {
                            boolean go = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"", (String)"Are you sure you want to delete the selected Argument Element and all of his OPTIONAL connection?");
                            if (!go) {
                                return;
                            }
                            OptionalAndMultiplicityPropertySection.this.removeOptionalRelationships();
                        } else {
                            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"", (String)"In order to remove an optional relationship, you have to set the connection as optional (use the checkbox).");
                        }
                    }
                });
            }
        });
    }

    private void removeOptionalRelationships() {
        ArrayList<ArgumentElement> elements = new ArrayList<ArgumentElement>();
        if (!this.currentlySelectedConnection.isOptional()) {
            return;
        }
        elements = this.getToBeDeletedOptionalRelationships(this.currentlySelectedConnection, (ArgumentElement)this.currentlySelectedConnection.getTarget().getOwner(), elements);
        EcoreUtil.delete((EObject)this.currentlySelectedConnection.getSource());
        EcoreUtil.delete((EObject)this.currentlySelectedConnection.getTarget());
        EcoreUtil.delete((EObject)this.currentlySelectedConnection);
        elements.forEach(i -> this.deleteArgumentElementAndConnections((ArgumentElement)i));
    }

    private void deleteArgumentElementAndConnections(ArgumentElement argEl) {
        argEl.getEntryConnectors().forEach(i -> this.deleteConnector((SafetyCasesConnector)i));
        argEl.getExitConnectors().forEach(i -> this.deleteConnector((SafetyCasesConnector)i));
        EcoreUtil.delete((EObject)argEl);
    }

    private void deleteConnector(SafetyCasesConnector connector) {
        if (connector instanceof EntryConnector) {
            EcoreUtil.deleteAll((Collection)connector.getIncoming(), (boolean)true);
            if (connector.getIncoming().size() == 1) {
                EcoreUtil.delete((EObject)connector);
            }
        } else {
            if (connector.getOutgoing().size() != 0) {
                if (((IConnection)connector.getOutgoing().get(0)).getTarget().getIncoming().size() == 1) {
                    EcoreUtil.delete((EObject)((IConnection)connector.getOutgoing().get(0)).getTarget());
                } else {
                    SafetyCasesConnection targetConnection = (SafetyCasesConnection)connector.getOutgoing().get(0);
                    SafetyCasesConnector targetEntryConnector = targetConnection.getTarget();
                    targetEntryConnector.getIncoming().remove((Object)targetConnection);
                }
            }
            EcoreUtil.deleteAll((Collection)connector.getIncoming(), (boolean)true);
            EcoreUtil.delete((EObject)connector);
        }
    }

    private ArrayList<ArgumentElement> getToBeDeletedOptionalRelationships(SafetyCasesConnection sourceConnection, ArgumentElement target, ArrayList<ArgumentElement> elements) {
        List entryConnectors = target.getEntryConnectors().stream().filter(i -> i.getIncoming().size() != 0).flatMap(l -> l.getIncoming().stream()).map(e -> (SafetyCasesConnection)e).filter(f -> !f.equals(sourceConnection)).collect(Collectors.toList());
        if (entryConnectors.isEmpty()) {
            if (!elements.contains(target)) {
                elements.add(target);
            }
            List children = target.getExitConnectors().stream().filter(a -> a.getOutgoing().size() != 0).map(i -> (IConnection)i.getOutgoing().get(0)).map(e -> (SafetyCasesConnection)e).collect(Collectors.toList());
            for (SafetyCasesConnection child : children) {
                this.getToBeDeletedOptionalRelationships(child, (ArgumentElement)child.getTarget().getOwner(), elements);
            }
        }
        return elements;
    }

    private void multiply() {
        Dialog dialog = new Dialog();
        dialog.setTitle("Multiplicity");
        dialog.setHeaderText("Please type in how many instances of the targeted argumentation shall be created.");
        ButtonType multiplyButtonType = new ButtonType("Multiply", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{multiplyButtonType, ButtonType.CANCEL});
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(20.0, 150.0, 10.0, 10.0));
        final TextField multiplicityInt = new TextField();
        multiplicityInt.setPromptText("0");
        multiplicityInt.setMinWidth(350.0);
        TextField multiplicityExplaination = new TextField();
        multiplicityInt.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d*")) {
                    multiplicityInt.setText(newValue.replaceAll("[^\\d]", ""));
                }
            }
        });
        multiplicityExplaination.setPromptText("Multiplicity Explaination");
        grid.add((Node)new Label("Multiplicity"), 0, 0);
        grid.add((Node)multiplicityInt, 1, 0);
        grid.add((Node)new Label("Multiplicity Explaination"), 0, 1);
        grid.add((Node)multiplicityExplaination, 1, 1);
        Node multiplyButton = dialog.getDialogPane().lookupButton(multiplyButtonType);
        multiplyButton.setDisable(true);
        multiplicityInt.textProperty().addListener((observable, oldValue, newValue) -> multiplyButton.setDisable(newValue.trim().isEmpty()));
        dialog.getDialogPane().setContent((Node)grid);
        Platform.runLater(() -> multiplicityInt.requestFocus());
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == multiplyButtonType) {
                return new Pair((Object)multiplicityInt.getText(), (Object)multiplicityExplaination.getText());
            }
            return null;
        });
        Optional result = dialog.showAndWait();
        result.ifPresent(a -> {
            try {
                this.currentlySelectedConnection.setMultiplicity(Integer.parseInt((String)a.getKey()));
                this.currentlySelectedConnection.setMultiplicityExplanation((String)a.getValue());
                if (this.currentlySelectedConnection.isMultipliable()) {
                    int multiplicity = Integer.parseInt((String)a.getKey());
                    while (multiplicity > 0) {
                        ArgumentElement copy = InstantiationOfGSNElementsUtils.createCopyOfArgumentElement((ArgumentElement)this.currentlySelectedConnection.getTarget().getOwner());
                        SafetyCasesModelElementFactory.createConnectionAndAttach((HierarchicElementBase)((HierarchicElementBase)this.currentlySelectedConnection.getOwner()), (ArgumentElementBase)((ArgumentElementBase)this.currentlySelectedConnection.getSource().getOwner()), (ArgumentElementBase)copy, SupportedBy.class);
                        InstantiationOfGSNElementsUtils.duplicateArgElementAndAllTargetedConnections((ArgumentElement)this.currentlySelectedConnection.getTarget().getOwner(), copy);
                        --multiplicity;
                    }
                }
            }
            catch (NumberFormatException e) {
                this.currentlySelectedConnection.setMultiplicity(0);
            }
        });
    }
}

