/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.properties;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fortiss.af3.safetycases.model.ArgumentElement;
import org.fortiss.af3.safetycases.model.ArgumentElementBase;
import org.fortiss.af3.safetycases.ui.utils.QuantitativeEvaluationUtils;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.ui.extension.base.PropertySectionBase;
import org.fortiss.tooling.kernel.ui.util.DataBindingUtils;

public class QuantitativeEvaluationPropertySection
extends PropertySectionBase {
    private ArgumentElement currentlyArgument;
    private Text defeatersTotalText;
    private Text defeatersOutruledText;
    private Label dempsterShaferLabel;
    private Text weightText;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.defeatersOutruledText = this.createFormText("Defeaters Outruled");
        this.defeatersOutruledText.setData(DataBindingUtils.DECORATION_KEY, (Object)new ControlDecoration((Control)this.defeatersOutruledText, 16512));
        this.defeatersOutruledText.setVisible(true);
        this.defeatersOutruledText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent ev) {
                try {
                    String s = QuantitativeEvaluationPropertySection.this.defeatersOutruledText.getText().trim().replace(",", "");
                    float defeatersOutruled = Float.parseFloat(s);
                    if (defeatersOutruled <= QuantitativeEvaluationPropertySection.this.currentlyArgument.getDefeatersTotal()) {
                        ICommandStackService.getInstance().runAsCommand((EObject)QuantitativeEvaluationPropertySection.this.currentlyArgument, () -> QuantitativeEvaluationPropertySection.this.currentlyArgument.setDefeatersOutruled(defeatersOutruled));
                    }
                }
                catch (Exception e1) {
                    return;
                }
            }
        });
        this.defeatersTotalText = this.createFormText("Total Number of Defeaters");
        this.defeatersTotalText.setData(DataBindingUtils.DECORATION_KEY, (Object)new ControlDecoration((Control)this.defeatersTotalText, 16512));
        this.defeatersTotalText.setVisible(true);
        this.defeatersTotalText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent ev) {
                try {
                    String s = QuantitativeEvaluationPropertySection.this.defeatersTotalText.getText().trim().replace(",", "");
                    float defeatersTotal = Float.parseFloat(s);
                    if (defeatersTotal >= QuantitativeEvaluationPropertySection.this.currentlyArgument.getDefeatersOutruled()) {
                        ICommandStackService.getInstance().runAsCommand((EObject)QuantitativeEvaluationPropertySection.this.currentlyArgument, () -> QuantitativeEvaluationPropertySection.this.currentlyArgument.setDefeatersTotal(defeatersTotal));
                    }
                }
                catch (Exception e1) {
                    return;
                }
            }
        });
        this.weightText = this.createFormText("Weight");
        this.weightText.setData(DataBindingUtils.DECORATION_KEY, (Object)new ControlDecoration((Control)this.weightText, 16512));
        this.weightText.setVisible(true);
        this.weightText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent ev) {
                try {
                    String s = QuantitativeEvaluationPropertySection.this.weightText.getText().trim();
                    float weight = Float.parseFloat(s);
                    ICommandStackService.getInstance().runAsCommand((EObject)QuantitativeEvaluationPropertySection.this.currentlyArgument, () -> QuantitativeEvaluationPropertySection.this.currentlyArgument.setWeight(weight));
                }
                catch (Exception e1) {
                    return;
                }
            }
        });
        this.dempsterShaferLabel = this.getWidgetFactory().createLabel(this.composite, "Evaluation                                        ");
        this.dempsterShaferLabel.setToolTipText("The computed quantitative evaluation.");
    }

    protected void setSectionInput(Object input) {
        this.currentlyArgument = (ArgumentElement)input;
        this.weightText.setText(Float.toString(this.currentlyArgument.getWeight()));
        if (QuantitativeEvaluationUtils.isLeaf((ArgumentElementBase)this.currentlyArgument)) {
            this.defeatersOutruledText.setEditable(true);
            this.defeatersTotalText.setEditable(true);
            float tasksCompleted = this.currentlyArgument.getDefeatersOutruled();
            this.defeatersOutruledText.setText(Float.toString(tasksCompleted));
            float tasksTotal = this.currentlyArgument.getDefeatersTotal();
            this.defeatersTotalText.setText(Float.toString(tasksTotal));
            this.dempsterShaferLabel.setText(this.dempsterShaferString(tasksTotal, tasksCompleted));
        } else {
            this.defeatersOutruledText.setEditable(false);
            this.defeatersOutruledText.setBackground(QuantitativeEvaluationUtils.GRAY);
            this.defeatersTotalText.setEditable(false);
            this.defeatersTotalText.setBackground(QuantitativeEvaluationUtils.GRAY);
            this.updateTexts();
        }
    }

    public void refresh() {
        if (!QuantitativeEvaluationUtils.isLeaf((ArgumentElementBase)this.currentlyArgument)) {
            this.updateTexts();
        }
    }

    private void updateTexts() {
        float defeatersOutruled = QuantitativeEvaluationUtils.sumCompletedTasks(this.currentlyArgument);
        this.defeatersOutruledText.setText(Float.toString(defeatersOutruled));
        float defeatersTotal = QuantitativeEvaluationUtils.sumTotalTasks(this.currentlyArgument);
        this.defeatersTotalText.setText(Float.toString(defeatersTotal));
        this.dempsterShaferLabel.setText(this.dempsterShaferString(defeatersTotal, defeatersOutruled));
        ICommandStackService.getInstance().runAsCommand((EObject)this.currentlyArgument, () -> {
            this.currentlyArgument.setDefeatersOutruled(defeatersOutruled);
            this.currentlyArgument.setDefeatersTotal(defeatersTotal);
        });
    }

    private String dempsterShaferString(float tasksTotal, float tasksCompleted) {
        float belief = QuantitativeEvaluationUtils.computeBelief(tasksTotal, tasksCompleted);
        float disbelief = QuantitativeEvaluationUtils.computeDisbelief(tasksTotal, tasksCompleted);
        float uncertainty = QuantitativeEvaluationUtils.computeUncertainty(tasksTotal, tasksCompleted);
        return " belief:  " + String.format("%.2f", Float.valueOf(belief)) + "\n disbelief:  " + String.format("%.2f", Float.valueOf(disbelief)) + "\n uncertainty:  " + String.format("%.2f", Float.valueOf(uncertainty));
    }
}

