/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.prototypes;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.safetyargumentationpackage.utils.SafetyArgumentationPackageModelElementFactory;
import org.fortiss.af3.safetycases.model.ArgumentElement;
import org.fortiss.af3.safetycases.model.Assumption;
import org.fortiss.af3.safetycases.model.AwayContext;
import org.fortiss.af3.safetycases.model.AwayContractModule;
import org.fortiss.af3.safetycases.model.AwayGoal;
import org.fortiss.af3.safetycases.model.AwaySolution;
import org.fortiss.af3.safetycases.model.Change;
import org.fortiss.af3.safetycases.model.Context;
import org.fortiss.af3.safetycases.model.EntryConnector;
import org.fortiss.af3.safetycases.model.ExitConnector;
import org.fortiss.af3.safetycases.model.Goal;
import org.fortiss.af3.safetycases.model.Justification;
import org.fortiss.af3.safetycases.model.OptionEntity;
import org.fortiss.af3.safetycases.model.Solution;
import org.fortiss.af3.safetycases.model.Strategy;
import org.fortiss.af3.safetycases.utils.SafetyCasesModelElementFactory;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.utils.DimensionUtils;
import org.fortiss.tooling.kernel.extension.base.PrototypeProviderBase;

public class PrototypeProvider
extends PrototypeProviderBase {
    protected static final String CATEGORY_NAME_ASSURANCE_CASES = "Assurance Case";
    protected static final String CATEGORY_NAME_PACKAGE = "Assurance Package";

    protected void registerPrototypes() {
        this.setupSafeyCasesPrototypes();
        this.setupSafetyArgumentationPackage();
    }

    private void setupSafetyArgumentationPackage() {
        String name = CATEGORY_NAME_PACKAGE;
        this.registerPrimaryPrototype(name, (EObject)SafetyArgumentationPackageModelElementFactory.createSafetyArgumentationPackage(), CATEGORY_NAME_PACKAGE);
    }

    private void setupSafeyCasesPrototypes() {
        String nameSC = CATEGORY_NAME_ASSURANCE_CASES;
        this.registerPrimaryPrototype(nameSC, (EObject)SafetyCasesModelElementFactory.createSafetyCase(), CATEGORY_NAME_ASSURANCE_CASES);
        String nameAM = "Argument Module";
        this.registerPrimaryPrototype(nameAM, (EObject)SafetyCasesModelElementFactory.createArgumentModule(), CATEGORY_NAME_ASSURANCE_CASES);
        String nameCM = "Contract Module";
        this.registerPrimaryPrototype(nameCM, (EObject)SafetyCasesModelElementFactory.createContractModule(), CATEGORY_NAME_ASSURANCE_CASES);
        OptionEntity optionEntity = SafetyCasesModelElementFactory.createOptionEntity((String)"Option Entity");
        this.registerPrimaryPrototype("Option Entity", (EObject)optionEntity, CATEGORY_NAME_ASSURANCE_CASES);
        Goal goal = SafetyCasesModelElementFactory.createGoal((String)"Goal");
        this.setArgumentElementSize((ArgumentElement)goal);
        this.registerPrimaryPrototype("Goal", (EObject)goal, CATEGORY_NAME_ASSURANCE_CASES);
        AwayGoal awayGoal = SafetyCasesModelElementFactory.createAwayGoal((String)"Away Goal");
        this.setArgumentElementSize((ArgumentElement)awayGoal);
        this.registerPrimaryPrototype("Away Goal", (EObject)awayGoal, CATEGORY_NAME_ASSURANCE_CASES);
        Strategy strategy = SafetyCasesModelElementFactory.createStrategy((String)"Strategy");
        this.setArgumentElementSize((ArgumentElement)strategy);
        this.registerPrimaryPrototype("Strategy", (EObject)strategy, CATEGORY_NAME_ASSURANCE_CASES);
        Solution solution = SafetyCasesModelElementFactory.createSolution((String)"Solution");
        this.registerPrimaryPrototype("Solution", (EObject)solution, CATEGORY_NAME_ASSURANCE_CASES);
        AwaySolution awaySolution = SafetyCasesModelElementFactory.createAwaySolution((String)"Away Solution");
        this.setArgumentElementSize((ArgumentElement)awaySolution);
        this.registerPrimaryPrototype("Away Solution", (EObject)awaySolution, CATEGORY_NAME_ASSURANCE_CASES);
        Justification justification = SafetyCasesModelElementFactory.createJustification((String)"Justification");
        this.setArgumentElementSize((ArgumentElement)justification);
        this.registerPrimaryPrototype("Justification", (EObject)justification, CATEGORY_NAME_ASSURANCE_CASES);
        Assumption assumption = SafetyCasesModelElementFactory.createAssumption((String)"Assumption");
        this.setArgumentElementSize((ArgumentElement)assumption);
        this.registerPrimaryPrototype("Assumption", (EObject)assumption, CATEGORY_NAME_ASSURANCE_CASES);
        Context context = SafetyCasesModelElementFactory.createContext((String)"Context");
        this.setArgumentElementSize((ArgumentElement)context);
        this.registerPrimaryPrototype("Context", (EObject)context, CATEGORY_NAME_ASSURANCE_CASES);
        AwayContext awayContext = SafetyCasesModelElementFactory.createAwayContext((String)"Away Context");
        this.setArgumentElementSize((ArgumentElement)awayContext);
        this.registerPrimaryPrototype("Away Context", (EObject)awayContext, CATEGORY_NAME_ASSURANCE_CASES);
        EntryConnector entryConnector = SafetyCasesModelElementFactory.createSafetyEntryConnector();
        this.registerPrimaryPrototype("Entry Connector", (EObject)entryConnector, CATEGORY_NAME_ASSURANCE_CASES);
        ExitConnector exitConnector = SafetyCasesModelElementFactory.createSafetyExitConnector();
        this.registerPrimaryPrototype("Exit Connector", (EObject)exitConnector, CATEGORY_NAME_ASSURANCE_CASES);
        AwayContractModule awayContractModule = SafetyCasesModelElementFactory.createAwayContractModule();
        this.registerPrimaryPrototype("Away Contract Module", (EObject)awayContractModule, CATEGORY_NAME_ASSURANCE_CASES);
        Change change = SafetyCasesModelElementFactory.createChange();
        this.registerPrimaryPrototype("Change", (EObject)change, CATEGORY_NAME_ASSURANCE_CASES);
    }

    private void setArgumentElementSize(ArgumentElement element) {
        DimensionUtils.setDimension((ILayoutedModelElement)element, (String)"dim", (int)216, (int)72);
    }
}

