/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.mira.model.Analysis;
import org.fortiss.af3.mira.model.Requirement;
import org.fortiss.af3.mira.model.RequirementsContainer;
import org.fortiss.af3.mira.model.RequirementsPackage;
import org.fortiss.af3.mode.model.Mode;
import org.fortiss.af3.mode.model.ModeAutomaton;
import org.fortiss.af3.platform.model.IPlatformArchitectureElement;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.platform.model.allocation.ComponentToExecutionUnitAllocationTable;
import org.fortiss.af3.safetycases.model.ArgumentElement;
import org.fortiss.af3.safetycases.model.Change;
import org.fortiss.af3.state.model.State;
import org.fortiss.af3.state.model.StateAutomaton;
import org.fortiss.tooling.base.model.base.HierarchicElementBase;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.ui.dialog.ElementTreeMultiSelectDialog;
import org.fortiss.tooling.base.ui.dialog.ElementTreeSingleSelectDialog;
import org.fortiss.tooling.base.ui.dialog.ModelElementTreeContentProvider;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.ui.presentation.ModelElementLabelProvider;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class AF3SelectionDialogUtils {
    public static Requirement openSR(Shell shell, List<Analysis> analysisList, Requirement selected) {
        List<Analysis> root = analysisList;
        ElementTreeSingleSelectDialog dialog = new ElementTreeSingleSelectDialog(shell, root, selected, (ITreeContentProvider)new ModelElementTreeContentProvider(root){

            public List<? extends EObject> getChildren(EObject parent) {
                return EcoreUtils.pickInstanceOf(Arrays.asList(RequirementsContainer.class, RequirementsPackage.class, Requirement.class), (List)super.getChildren(parent));
            }
        }, (ILabelProvider)new ModelElementLabelProvider(), null){

            public boolean acceptElement(Object element) {
                return element instanceof Requirement;
            }
        };
        if (dialog.open() == 0) {
            return (Requirement)dialog.getSelectedElement();
        }
        return selected;
    }

    public static EList<Requirement> openSRMulti(Shell shell, List<Analysis> analysisList, Requirement selected) {
        List<Analysis> root = analysisList;
        ElementTreeMultiSelectDialog d = new ElementTreeMultiSelectDialog(shell, root, null, (ITreeContentProvider)new ModelElementTreeContentProvider(root){

            public List<? extends EObject> getChildren(EObject parent) {
                EList list = EcoreUtils.pickInstanceOf(Arrays.asList(RequirementsContainer.class, RequirementsPackage.class, Requirement.class), (List)super.getChildren(parent));
                ArrayList<EObject> filteredList = new ArrayList<EObject>();
                for (EObject ele : list) {
                    if (!(ele instanceof Requirement)) continue;
                    filteredList.add(ele);
                }
                return filteredList;
            }
        }, (ILabelProvider)new ModelElementLabelProvider());
        if (d.open() == 0) {
            return EcoreUtils.pickInstanceOf(Requirement.class, (List)d.getSelectedElements());
        }
        return null;
    }

    public static EList<Component> openComponents(Shell shell, List<ComponentArchitecture> archList) {
        List<ComponentArchitecture> root = archList;
        ElementTreeMultiSelectDialog d = new ElementTreeMultiSelectDialog(shell, root, null, (ITreeContentProvider)new ModelElementTreeContentProvider(root){

            public List<? extends EObject> getChildren(EObject parent) {
                return EcoreUtils.pickInstanceOf(Component.class, (List)super.getChildren(parent));
            }
        }, (ILabelProvider)new ModelElementLabelProvider());
        if (d.open() == 0) {
            return EcoreUtils.pickInstanceOf(Component.class, (List)d.getSelectedElements());
        }
        return null;
    }

    public static INamedCommentedElement openAF3PlatformElement(Shell shell, List<PlatformArchitecture> parchList, List<ComponentToExecutionUnitAllocationTable> ca2hwList, EObject selected) {
        ArrayList<Object> root = new ArrayList<Object>();
        root.addAll(parchList);
        root.addAll(ca2hwList);
        ElementTreeSingleSelectDialog d = new ElementTreeSingleSelectDialog(shell, root, null, (ITreeContentProvider)new ModelElementTreeContentProvider(root){

            public List<? extends EObject> getChildren(EObject parent) {
                return EcoreUtils.pickInstanceOf(HierarchicElementBase.class, (List)super.getChildren(parent));
            }
        }, (ILabelProvider)new ModelElementLabelProvider(), null);
        if (d.open() == 0) {
            return (INamedCommentedElement)d.getSelectedElement();
        }
        return null;
    }

    public static Component openLogicalComponents(Shell shell, List<ComponentArchitecture> archList) {
        List<ComponentArchitecture> root = archList;
        ElementTreeSingleSelectDialog dialog = new ElementTreeSingleSelectDialog(shell, root, null, (ITreeContentProvider)new ModelElementTreeContentProvider(root){

            public List<? extends EObject> getChildren(EObject parent) {
                return EcoreUtils.pickInstanceOf(Component.class, (List)super.getChildren(parent));
            }
        }, (ILabelProvider)new ModelElementLabelProvider(), null){

            public boolean acceptElement(Object element) {
                return element instanceof Component;
            }
        };
        if (dialog.open() == 0) {
            return (Component)dialog.getSelectedElement();
        }
        return null;
    }

    public static INamedCommentedElement openAF3ArchitectureElements(Shell shell, List<ComponentArchitecture> archList, List<PlatformArchitecture> parchList, HierarchicElementBase selected) {
        ArrayList<Object> root = new ArrayList<Object>();
        root.addAll(archList);
        root.addAll(parchList);
        ElementTreeSingleSelectDialog dialog = new ElementTreeSingleSelectDialog(shell, root, selected, (ITreeContentProvider)new ModelElementTreeContentProvider(root){

            public List<? extends EObject> getChildren(EObject parent) {
                return EcoreUtils.pickInstanceOf(Arrays.asList(IPlatformArchitectureElement.class, Component.class), (List)super.getChildren(parent));
            }
        }, (ILabelProvider)new ModelElementLabelProvider(), null){

            public boolean acceptElement(Object element) {
                return element instanceof Component || element instanceof IPlatformArchitectureElement;
            }
        };
        if (dialog.open() == 0) {
            return (HierarchicElementBase)dialog.getSelectedElement();
        }
        return selected;
    }

    public static Mode openAF3Modes(Shell shell, Component component, EObject selected) {
        List<Component> root = Arrays.asList(component);
        ElementTreeSingleSelectDialog dialog = new ElementTreeSingleSelectDialog(shell, root, selected, (ITreeContentProvider)new ModelElementTreeContentProvider(root){

            public List<? extends EObject> getChildren(EObject parent) {
                if (parent instanceof Component) {
                    EList modeAutomata = EcoreUtils.pickInstanceOf(ModeAutomaton.class, (List)((Component)parent).getSpecifications());
                    ArrayList m = new ArrayList();
                    for (ModeAutomaton ma : modeAutomata) {
                        m.addAll(ma.getRootMode().getSubModes());
                    }
                    return m;
                }
                return Collections.emptyList();
            }
        }, (ILabelProvider)new ModelElementLabelProvider(), null){

            public boolean acceptElement(Object element) {
                return element instanceof Mode;
            }
        };
        if (dialog.open() == 0 && dialog.getSelectedElement() instanceof Mode) {
            return (Mode)dialog.getSelectedElement();
        }
        return null;
    }

    public static State openAF3State(Shell shell, Component component, EObject selected) {
        List<Component> root = Arrays.asList(component);
        ElementTreeSingleSelectDialog dialog = new ElementTreeSingleSelectDialog(shell, root, selected, (ITreeContentProvider)new ModelElementTreeContentProvider(root){

            public List<? extends EObject> getChildren(EObject parent) {
                if (parent instanceof Component) {
                    EList stateAutomata = EcoreUtils.pickInstanceOf(StateAutomaton.class, (List)((Component)parent).getSpecifications());
                    ArrayList s = new ArrayList();
                    for (StateAutomaton sa : stateAutomata) {
                        s.addAll(sa.getRootState().getSubStates());
                    }
                    return s;
                }
                return Collections.emptyList();
            }
        }, (ILabelProvider)new ModelElementLabelProvider(), null){

            public boolean acceptElement(Object element) {
                return element instanceof State;
            }
        };
        if (dialog.open() == 0 && dialog.getSelectedElement() instanceof State) {
            return (State)dialog.getSelectedElement();
        }
        return null;
    }

    public static IPlatformArchitectureElement openPlatformArchElements(Shell shell, List<PlatformArchitecture> parchList, IPlatformArchitectureElement selected) {
        ArrayList<PlatformArchitecture> root = new ArrayList<PlatformArchitecture>();
        root.addAll(parchList);
        ElementTreeSingleSelectDialog dialog = new ElementTreeSingleSelectDialog(shell, root, selected, (ITreeContentProvider)new ModelElementTreeContentProvider(root){

            public List<? extends EObject> getChildren(EObject parent) {
                return EcoreUtils.pickInstanceOf(Arrays.asList(IPlatformArchitectureElement.class), (List)super.getChildren(parent));
            }
        }, (ILabelProvider)new ModelElementLabelProvider(), null){

            public boolean acceptElement(Object element) {
                return element instanceof IPlatformArchitectureElement;
            }
        };
        if (dialog.open() == 0) {
            return (IPlatformArchitectureElement)dialog.getSelectedElement();
        }
        return selected;
    }

    public static Component selectComponent(Shell shell, List<? extends EObject> root, Component selected) {
        ElementTreeSingleSelectDialog dialog = new ElementTreeSingleSelectDialog(shell, root, selected, (ITreeContentProvider)new ModelElementTreeContentProvider(root){

            public List<? extends EObject> getChildren(EObject parent) {
                return EcoreUtils.pickInstanceOf(Arrays.asList(ComponentArchitecture.class, Component.class), (List)super.getChildren(parent));
            }
        }, (ILabelProvider)new ModelElementLabelProvider(), null){

            public boolean acceptElement(Object element) {
                return element instanceof Component;
            }
        };
        if (dialog.open() == 0) {
            return (Component)dialog.getSelectedElement();
        }
        return selected;
    }

    public static List<Object> selectMultipleReferences(Shell shell, List<? extends EObject> root, List<EObject> alreadyReferenced, EObject selected) {
        ElementTreeMultiSelectDialog d = new ElementTreeMultiSelectDialog(shell, root, alreadyReferenced, (ITreeContentProvider)new ModelElementTreeContentProvider(root){

            public List<? extends EObject> getChildren(EObject parent) {
                EList modeAutomata = new ArrayList();
                EList stateAutomata = new ArrayList();
                if (parent instanceof Component) {
                    modeAutomata = EcoreUtils.pickInstanceOf(ModeAutomaton.class, (List)((Component)parent).getSpecifications());
                    stateAutomata = EcoreUtils.pickInstanceOf(StateAutomaton.class, (List)((Component)parent).getSpecifications());
                }
                EList elements = EcoreUtils.pickInstanceOf(Arrays.asList(RequirementsContainer.class, RequirementsPackage.class, Requirement.class, ComponentArchitecture.class, Component.class, PlatformArchitecture.class, IPlatformArchitectureElement.class, AllocationTableCollection.class, AllocationTable.class), (List)super.getChildren(parent));
                ArrayList list = new ArrayList();
                list.addAll(elements);
                for (ModeAutomaton ma : modeAutomata) {
                    list.addAll(ma.getRootMode().getSubModes());
                }
                for (StateAutomaton state : stateAutomata) {
                    list.addAll(state.getRootState().getSubStates());
                }
                return list;
            }
        }, (ILabelProvider)new ModelElementLabelProvider());
        if (d.open() == 0) {
            boolean go;
            EList changes = ((ArgumentElement)selected).getAffectedByCurrentChanges();
            ArrayList<IModelElement> impactedElements = new ArrayList<IModelElement>();
            for (Change change : changes) {
                impactedElements.add(change.getModelElement());
            }
            List selectedElements = d.getSelectedElements();
            if (!selectedElements.containsAll(impactedElements) && (go = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"", (String)"You have impacted changes, that references System Model Elements that are not set as connected to this Argument Element. Would you like to add them to the referenced list?"))) {
                selectedElements.addAll(impactedElements.stream().filter(i -> !selectedElements.contains(i)).collect(Collectors.toList()));
                return selectedElements;
            }
            return d.getSelectedElements();
        }
        return null;
    }

    public static EObject selectSystemModelElement(Shell shell, List<? extends EObject> root, EObject selected) {
        ElementTreeSingleSelectDialog dialog = new ElementTreeSingleSelectDialog(shell, root, selected, (ITreeContentProvider)new ModelElementTreeContentProvider(root){

            public List<? extends EObject> getChildren(EObject parent) {
                new ArrayList();
                new ArrayList();
                if (parent instanceof Component) {
                    EcoreUtils.pickInstanceOf(ModeAutomaton.class, (List)((Component)parent).getSpecifications());
                    EcoreUtils.pickInstanceOf(StateAutomaton.class, (List)((Component)parent).getSpecifications());
                }
                return EcoreUtils.pickInstanceOf(Arrays.asList(Requirement.class, ComponentArchitecture.class, Component.class, PlatformArchitecture.class, IPlatformArchitectureElement.class, AllocationTableCollection.class, AllocationTable.class, IPlatformArchitectureElement.class), (List)super.getChildren(parent));
            }
        }, (ILabelProvider)new ModelElementLabelProvider(), null){

            public boolean acceptElement(Object element) {
                return element instanceof Component || element instanceof Requirement || element instanceof Mode || element instanceof AllocationTable || element instanceof State || element instanceof PlatformArchitecture || element instanceof IPlatformArchitectureElement;
            }
        };
        if (dialog.open() == 0) {
            return (EObject)dialog.getSelectedElement();
        }
        return selected;
    }
}

