/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.utils;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DropdownDialog
extends Dialog {
    private String title;
    private String message;
    private List<String> itemNames;
    private DropdownDialogGUI gui;
    private String selection;
    private Combo dropDownList;
    private ModifyListener listener;

    public DropdownDialog(Shell parentShell, String dialogTitle, String dialogMessage, List<String> buttonNames) {
        super(parentShell);
        this.title = dialogTitle;
        this.message = dialogMessage;
        this.itemNames = buttonNames;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.message != null) {
            Label label = new Label(composite, 64);
            label.setText(this.message);
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
        }
        this.gui = new DropdownDialogGUI(composite, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        this.gui.setLayout((Layout)fillLayout);
        String[] stockArr = new String[this.itemNames.size()];
        stockArr = this.itemNames.toArray(stockArr);
        this.dropDownList = new Combo(composite, 0);
        this.dropDownList.setItems(stockArr);
        this.listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!DropdownDialog.this.getShell().isDisposed() && DropdownDialog.this.dropDownList.getItems() != null) {
                    DropdownDialog.this.selection = DropdownDialog.this.dropDownList.getText();
                }
            }
        };
        this.dropDownList.addModifyListener(this.listener);
        DropdownDialog.applyDialogFont((Control)composite);
        this.dropDownList.setLayoutData((Object)new GridData(1808));
        return composite;
    }

    public String getSelection() {
        return this.selection;
    }

    private class DropdownDialogGUI
    extends Composite {
        DropdownDialogGUI(Composite parent, int style) {
            super(parent, style);
            FillLayout container = new FillLayout();
            container.marginHeight = 4;
            container.marginWidth = 4;
            this.setLayout((Layout)container);
            this.setLayoutData(new GridData(1808));
        }
    }
}

