/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.safetyargumentationpackage.model.SafetyArgumentationPackage;
import org.fortiss.af3.safetycases.model.ArgumentElement;
import org.fortiss.af3.safetycases.model.ArgumentElementBase;
import org.fortiss.af3.safetycases.model.ArgumentModule;
import org.fortiss.af3.safetycases.model.AwayContext;
import org.fortiss.af3.safetycases.model.AwayContractModule;
import org.fortiss.af3.safetycases.model.AwayGoal;
import org.fortiss.af3.safetycases.model.AwaySolution;
import org.fortiss.af3.safetycases.model.Context;
import org.fortiss.af3.safetycases.model.ContractModule;
import org.fortiss.af3.safetycases.model.Goal;
import org.fortiss.af3.safetycases.model.SafetyCase;
import org.fortiss.af3.safetycases.model.SafetyModule;
import org.fortiss.af3.safetycases.model.Solution;
import org.fortiss.tooling.base.ui.dialog.ElementTreeMultiSelectDialog;
import org.fortiss.tooling.base.ui.dialog.ElementTreeSingleSelectDialog;
import org.fortiss.tooling.base.ui.dialog.ModelElementTreeContentProvider;
import org.fortiss.tooling.kernel.ui.presentation.ModelElementLabelProvider;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class GSNSelectionDialogUtils {
    public static Goal openGoalsToConnectToAwayGoal(Shell shell, List<SafetyArgumentationPackage> sapList, Goal selected, final AwayGoal awayGoal) {
        ElementTreeSingleSelectDialog dialog = new ElementTreeSingleSelectDialog(shell, sapList, selected, (ITreeContentProvider)new ModelElementTreeContentProvider(sapList){

            public List<? extends EObject> getChildren(EObject parent) {
                EList list = EcoreUtils.pickInstanceOf(Arrays.asList(Goal.class, SafetyModule.class, SafetyCase.class, SafetyArgumentationPackage.class), (List)super.getChildren(parent));
                ArrayList<EObject> filteredList = new ArrayList<EObject>();
                for (EObject ele : list) {
                    if (ele instanceof Goal && ((Goal)ele).getContainer().equals(awayGoal.getContainer()) || ele instanceof SafetyModule && ele.equals(awayGoal.getContainer())) continue;
                    filteredList.add(ele);
                }
                return filteredList;
            }
        }, (ILabelProvider)new ModelElementLabelProvider(), null){

            public boolean acceptElement(Object element) {
                return element instanceof Goal;
            }
        };
        if (dialog.open() == 0) {
            return (Goal)dialog.getSelectedElement();
        }
        return selected;
    }

    public static ContractModule openContractToConnectToAwayContract(Shell shell, SafetyCase safetyCase, ContractModule selected, AwayContractModule awayContractModule) {
        ArrayList<SafetyCase> root = new ArrayList<SafetyCase>();
        root.add(safetyCase);
        ElementTreeSingleSelectDialog dialog = new ElementTreeSingleSelectDialog(shell, root, selected, (ITreeContentProvider)new ModelElementTreeContentProvider(root){

            public List<? extends EObject> getChildren(EObject parent) {
                return EcoreUtils.pickInstanceOf(Arrays.asList(ContractModule.class, SafetyCase.class), (List)super.getChildren(parent));
            }
        }, (ILabelProvider)new ModelElementLabelProvider(), null){

            public boolean acceptElement(Object element) {
                return element instanceof ContractModule;
            }
        };
        if (dialog.open() == 0) {
            return (ContractModule)dialog.getSelectedElement();
        }
        return selected;
    }

    public static Goal openGoals(Shell shell, SafetyCase safetyCase) {
        ArrayList<SafetyCase> root = new ArrayList<SafetyCase>();
        root.add(safetyCase);
        ElementTreeSingleSelectDialog dialog = new ElementTreeSingleSelectDialog(shell, root, null, (ITreeContentProvider)new ModelElementTreeContentProvider(root){

            public List<? extends EObject> getChildren(EObject parent) {
                return EcoreUtils.pickInstanceOf(Arrays.asList(Goal.class, SafetyModule.class), (List)super.getChildren(parent));
            }
        }, (ILabelProvider)new ModelElementLabelProvider(), null){

            public boolean acceptElement(Object element) {
                return element instanceof Goal;
            }
        };
        if (dialog.open() == 0) {
            return (Goal)dialog.getSelectedElement();
        }
        return null;
    }

    public static ArgumentModule openArgumentModules(Shell shell, List<SafetyCase> safetyCasesList, final AwayGoal awayGoal) {
        List<SafetyCase> root = safetyCasesList;
        ElementTreeSingleSelectDialog dialog = new ElementTreeSingleSelectDialog(shell, root, null, (ITreeContentProvider)new ModelElementTreeContentProvider(root){

            public List<? extends EObject> getChildren(EObject parent) {
                EList list = EcoreUtils.pickInstanceOf(Arrays.asList(ArgumentModule.class), (List)super.getChildren(parent));
                ArrayList<EObject> filteredList = new ArrayList<EObject>();
                for (EObject ele : list) {
                    if (ele instanceof SafetyModule && ele.equals(awayGoal.getContainer())) continue;
                    filteredList.add(ele);
                }
                return filteredList;
            }
        }, (ILabelProvider)new ModelElementLabelProvider(), null){

            public boolean acceptElement(Object element) {
                return element instanceof ArgumentModule;
            }
        };
        if (dialog.open() == 0) {
            return (ArgumentModule)dialog.getSelectedElement();
        }
        return null;
    }

    public static Context openContexts(Shell shell, List<SafetyArgumentationPackage> sapList, Context selected, final AwayContext awayContext) {
        ElementTreeSingleSelectDialog dialog = new ElementTreeSingleSelectDialog(shell, sapList, selected, (ITreeContentProvider)new ModelElementTreeContentProvider(sapList){

            public List<? extends EObject> getChildren(EObject parent) {
                EList list = EcoreUtils.pickInstanceOf(Arrays.asList(Context.class, SafetyModule.class, SafetyCase.class, SafetyArgumentationPackage.class), (List)super.getChildren(parent));
                ArrayList<EObject> filteredList = new ArrayList<EObject>();
                for (EObject ele : list) {
                    if (ele instanceof Goal && ((Goal)ele).getContainer().equals(awayContext.getContainer()) || ele instanceof SafetyModule && ele.equals(awayContext.getContainer())) continue;
                    filteredList.add(ele);
                }
                return filteredList;
            }
        }, (ILabelProvider)new ModelElementLabelProvider(), null){

            public boolean acceptElement(Object element) {
                return element instanceof Context;
            }
        };
        if (dialog.open() == 0) {
            return (Context)dialog.getSelectedElement();
        }
        return selected;
    }

    public static Solution openSolutions(Shell shell, List<SafetyArgumentationPackage> sapList, Solution selected, final AwaySolution awaySolution) {
        ElementTreeSingleSelectDialog dialog = new ElementTreeSingleSelectDialog(shell, sapList, selected, (ITreeContentProvider)new ModelElementTreeContentProvider(sapList){

            public List<? extends EObject> getChildren(EObject parent) {
                EList list = EcoreUtils.pickInstanceOf(Arrays.asList(Solution.class, SafetyModule.class, SafetyCase.class, SafetyArgumentationPackage.class), (List)super.getChildren(parent));
                ArrayList<EObject> filteredList = new ArrayList<EObject>();
                for (EObject ele : list) {
                    if (ele instanceof Goal && ((Goal)ele).getContainer().equals(awaySolution.getContainer()) || ele instanceof SafetyModule && ele.equals(awaySolution.getContainer())) continue;
                    filteredList.add(ele);
                }
                return filteredList;
            }
        }, (ILabelProvider)new ModelElementLabelProvider(), null){

            public boolean acceptElement(Object element) {
                return element instanceof Solution;
            }
        };
        if (dialog.open() == 0) {
            return (Solution)dialog.getSelectedElement();
        }
        return selected;
    }

    public static EList<ArgumentElement> openOptions(Shell shell, ArrayList<ArgumentElementBase> argEleList, int requiredNumberOfSelections) {
        ArrayList<ArgumentElementBase> root = argEleList;
        ElementTreeMultiSelectDialog d = new ElementTreeMultiSelectDialog(shell, root, null, (ITreeContentProvider)new ModelElementTreeContentProvider(root){

            public List<? extends EObject> getChildren(EObject parent) {
                return EcoreUtils.pickInstanceOf(ArgumentElementBase.class, (List)super.getChildren(parent));
            }
        }, (ILabelProvider)new ModelElementLabelProvider());
        if (d.open() == 0) {
            if (d.getSelectedElements().size() >= requiredNumberOfSelections) {
                return EcoreUtils.pickInstanceOf(ArgumentElement.class, (List)d.getSelectedElements());
            }
            MessageDialog.openInformation((Shell)shell, (String)"", (String)("You have not selected " + requiredNumberOfSelections + ". Please do so!!"));
            GSNSelectionDialogUtils.openOptions(shell, argEleList, requiredNumberOfSelections);
        }
        return null;
    }
}

