/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.utils;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fortiss.af3.safetycases.model.ArgumentElement;
import org.fortiss.af3.safetycases.model.ArgumentElementBase;
import org.fortiss.af3.safetycases.model.Assumption;
import org.fortiss.af3.safetycases.model.AwayGoal;
import org.fortiss.af3.safetycases.model.AwaySolution;
import org.fortiss.af3.safetycases.model.Context;
import org.fortiss.af3.safetycases.model.EntryConnector;
import org.fortiss.af3.safetycases.model.ExitConnector;
import org.fortiss.af3.safetycases.model.Goal;
import org.fortiss.af3.safetycases.model.InContextOf;
import org.fortiss.af3.safetycases.model.Justification;
import org.fortiss.af3.safetycases.model.OptionEntity;
import org.fortiss.af3.safetycases.model.SafetyCasesConnection;
import org.fortiss.af3.safetycases.model.Solution;
import org.fortiss.af3.safetycases.model.Strategy;
import org.fortiss.af3.safetycases.model.SupportedBy;
import org.fortiss.af3.safetycases.utils.SafetyCasesModelElementFactory;
import org.fortiss.tooling.base.model.base.HierarchicElementBase;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.utils.LayoutDataUtils;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;

public class InstantiationOfGSNElementsUtils {
    public static void computeTargetsList(ArgumentElement argumentElement, HashMap<ArgumentElement, String> targetsList, HashMap<ArgumentElement, Integer> targetsListMultiplicity) {
        for (ExitConnector exitConnector : argumentElement.getExitConnectors()) {
            IConnection outgoingConn = (IConnection)exitConnector.getOutgoing().get(0);
            ArgumentElement target = (ArgumentElement)outgoingConn.getTarget().getOwner();
            String connectionType = outgoingConn.getClass().getCanonicalName();
            targetsList.put(target, connectionType);
            int multiplicity = ((SafetyCasesConnection)outgoingConn).getMultiplicity();
            targetsListMultiplicity.put(target, multiplicity);
        }
    }

    public static void computeSourcesList(HashMap<ArgumentElementBase, String> sourcesList, ArgumentElement argumentElement) {
        for (IConnector entryConnector : argumentElement.getEntryConnectors()) {
            for (IConnection conn : entryConnector.getIncoming()) {
                Class claz = conn instanceof InContextOf ? InContextOf.class : SupportedBy.class;
                IHierarchicElement owner = conn.getSource().getOwner();
                sourcesList.put((ArgumentElementBase)((ArgumentElement)owner), claz.getCanonicalName());
            }
        }
    }

    public static void duplicateArgElementAndAllTargetedConnections(ArgumentElement argEl, ArgumentElement copy) {
        HashMap<ArgumentElement, String> targetsList = new HashMap<ArgumentElement, String>();
        HashMap<ArgumentElement, Integer> targetsListMultiplicity = new HashMap<ArgumentElement, Integer>();
        List childrenConnection = argEl.getExitConnectors().stream().filter(a -> a.getOutgoing().size() != 0).map(i -> (IConnection)i.getOutgoing().get(0)).map(e -> (SafetyCasesConnection)e).collect(Collectors.toList());
        for (SafetyCasesConnection childConnection : childrenConnection) {
            ArgumentElement child = (ArgumentElement)childConnection.getTarget().getOwner();
            targetsList.put(child, child.getClass().getCanonicalName());
            targetsListMultiplicity.put(child, childConnection.getMultiplicity());
        }
        HashMap<ArgumentElement, String> copyTargetsList = new HashMap<ArgumentElement, String>();
        for (ArgumentElement target : targetsList.keySet()) {
            ArgumentElement copyTarget = InstantiationOfGSNElementsUtils.createCopyOfArgumentElement(target);
            copyTargetsList.put(copyTarget, copyTarget.getClass().getCanonicalName());
            InstantiationOfGSNElementsUtils.duplicateArgElementAndAllTargetedConnections(target, copyTarget);
        }
        InstantiationOfGSNElementsUtils.createConnectionsBetweenCopyAndTheOriginalTargets(copyTargetsList, copy);
    }

    public static void deleteIncomingAndOutgoingConnections(IHierarchicElement element) {
        for (IConnector entryConnector : ((ArgumentElement)element).getEntryConnectors()) {
            for (IConnection connection : entryConnector.getIncoming()) {
                EcoreUtil.remove((EObject)connection.getSource());
                EcoreUtil.remove((EObject)connection);
            }
            EcoreUtil.remove((EObject)entryConnector);
        }
        for (IConnector exitConnector : ((ArgumentElement)element).getExitConnectors()) {
            for (IConnection connection : exitConnector.getOutgoing()) {
                EcoreUtil.remove((EObject)connection.getTarget());
                EcoreUtil.remove((EObject)connection);
            }
            EcoreUtil.remove((EObject)exitConnector);
        }
    }

    public static void instantiateClaim(final String instantiatedClaim, final ArgumentElement argEle) {
        ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)argEle);
        topLevel.runAsCommand(new Runnable(){

            @Override
            public void run() {
                argEle.setTextualInformation(instantiatedClaim);
            }
        });
    }

    public static void deleteAllTargets(ArgumentElementBase toBeDeletedArgEle) {
        for (IConnector exitConnector : toBeDeletedArgEle.getExitConnectors()) {
            for (IConnection outgoingConnection : exitConnector.getOutgoing()) {
                ArgumentElement target = (ArgumentElement)outgoingConnection.getTarget().getOwner();
                if (!target.getExitConnectors().isEmpty()) {
                    InstantiationOfGSNElementsUtils.deleteAllTargets((ArgumentElementBase)target);
                }
                EcoreUtil.remove((EObject)outgoingConnection.getTarget().getOwner());
                EcoreUtil.remove((EObject)outgoingConnection.getTarget());
                EcoreUtil.remove((EObject)outgoingConnection);
            }
            EcoreUtil.remove((EObject)exitConnector);
        }
    }

    public static void deleteOptionalEntity(final EntryConnector entryConnector, final ArgumentElement argumentElement) {
        ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)argumentElement);
        topLevel.runAsCommand(new Runnable(){

            @Override
            public void run() {
                if (argumentElement.getEntryConnectors().size() > 1) {
                    EcoreUtil.remove((EObject)((IConnection)entryConnector.getIncoming().get(0)).getSource());
                    EcoreUtil.remove((EObject)entryConnector);
                    EcoreUtil.remove((EObject)((EObject)entryConnector.getIncoming().get(0)));
                } else {
                    InstantiationOfGSNElementsUtils.deleteFromEntryConnector((ArgumentElementBase)argumentElement);
                }
            }
        });
    }

    public static void deleteFromEntryConnector(ArgumentElementBase toBeDeletedArgEle) {
        for (IConnector connector : toBeDeletedArgEle.getEntryConnectors()) {
            for (IConnection connection : connector.getIncoming()) {
                EcoreUtil.remove((EObject)connection.getSource());
                EcoreUtil.remove((EObject)connection);
            }
            EcoreUtil.remove((EObject)connector);
        }
        InstantiationOfGSNElementsUtils.deleteAllTargets(toBeDeletedArgEle);
        EcoreUtil.remove((EObject)toBeDeletedArgEle);
    }

    public static void createConnectionsBetweenCopyAndTheOriginalSources(HashMap<ArgumentElementBase, String> sourcesList, ArgumentElement argEle) {
        for (ArgumentElementBase source : sourcesList.keySet()) {
            if (sourcesList.get(source).contains(SupportedBy.class.getCanonicalName())) {
                SafetyCasesModelElementFactory.createConnectionAndAttach((HierarchicElementBase)argEle.getModule(), (ArgumentElementBase)source, (ArgumentElementBase)argEle, SupportedBy.class);
                continue;
            }
            SafetyCasesModelElementFactory.createConnectionAndAttach((HierarchicElementBase)argEle.getModule(), (ArgumentElementBase)source, (ArgumentElementBase)argEle, InContextOf.class);
        }
    }

    public static void createConnectionsBetweenCopyAndTheOriginalTargets(HashMap<ArgumentElement, String> targetList, ArgumentElement argEle) {
        for (ArgumentElementBase argumentElementBase : targetList.keySet()) {
            SafetyCasesModelElementFactory.createConnectionAndAttach((HierarchicElementBase)argEle.getModule(), (ArgumentElementBase)argEle, (ArgumentElementBase)argumentElementBase, SupportedBy.class);
        }
    }

    public static ArgumentElement createCopyOfArgumentElement(ArgumentElement argumentElement) {
        ArgumentElement ae = InstantiationOfGSNElementsUtils.instantiateCopyOfArgumentElement(argumentElement);
        argumentElement.getModule().getContainedElements().add((Object)ae);
        int x = LayoutDataUtils.getNodePosition((ILayoutedModelElement)argumentElement).getX();
        int y = LayoutDataUtils.getNodePosition((ILayoutedModelElement)argumentElement).getY();
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)ae, (int)x, (int)y);
        return ae;
    }

    public static ArgumentElement instantiateCopyOfArgumentElement(ArgumentElement argumentElement) {
        Object argumentEle;
        if (argumentElement instanceof Goal) {
            argumentEle = SafetyCasesModelElementFactory.createGoal();
        } else if (argumentElement instanceof Strategy) {
            argumentEle = SafetyCasesModelElementFactory.createStrategy();
        } else if (argumentElement instanceof Context) {
            argumentEle = SafetyCasesModelElementFactory.createContext();
        } else if (argumentElement instanceof OptionEntity) {
            argumentEle = SafetyCasesModelElementFactory.createOptionEntity();
            ((OptionEntity)argumentEle).setRequiredNumber(((OptionEntity)argumentEle).getRequiredNumber());
        } else {
            argumentEle = argumentElement instanceof Assumption ? SafetyCasesModelElementFactory.createAssumption() : (argumentElement instanceof AwayGoal ? SafetyCasesModelElementFactory.createAwayGoal() : (argumentElement instanceof AwaySolution ? SafetyCasesModelElementFactory.createAwaySolution() : (argumentElement instanceof Solution ? SafetyCasesModelElementFactory.createSolution() : (argumentElement instanceof Justification ? SafetyCasesModelElementFactory.createJustification() : SafetyCasesModelElementFactory.createAwayContext()))));
        }
        return argumentEle;
    }

    public static boolean multipilicityIsImplied(ArgumentElement argumentElement) {
        EList entryConnectors = argumentElement.getEntryConnectors();
        boolean entryConnNotEmpty = !entryConnectors.isEmpty();
        SafetyCasesConnection entryConnection = (SafetyCasesConnection)((EntryConnector)entryConnectors.get(0)).getIncoming().get(0);
        int multiplicity = entryConnection.getMultiplicity();
        return entryConnNotEmpty && multiplicity != 0;
    }

    public static boolean optionalityIsImplied(EntryConnector entryConnector) {
        boolean incoming = !entryConnector.getIncoming().isEmpty();
        SafetyCasesConnection incomingConn = (SafetyCasesConnection)entryConnector.getIncoming().get(0);
        return incoming && incomingConn != null && incomingConn.isOptional();
    }
}

