/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.utils;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.safetycases.model.ArgumentElement;
import org.fortiss.af3.safetycases.model.AwayArgumentElement;
import org.fortiss.af3.safetycases.model.Change;
import org.fortiss.af3.safetycases.model.Context;
import org.fortiss.af3.safetycases.model.Goal;
import org.fortiss.af3.safetycases.model.Solution;
import org.fortiss.af3.safetycases.model.Strategy;
import org.fortiss.af3.safetycases.model.maintenanceStatus;
import org.fortiss.af3.safetycases.utils.SafetyCasesModelElementFactory;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElementContainer;

public class MaintenanceUtils {
    public static void propagatePotentialImpactForChallengedArgElement(ArgumentElement e, Change referencedChange) {
        if (e instanceof Goal || e instanceof Strategy) {
            MaintenanceUtils.propagateGoalOrStrategy(e, referencedChange);
        } else if (!e.getConnectors().isEmpty()) {
            int i = 0;
            while (i < e.getConnectors().size()) {
                if (!((IConnector)e.getConnectors().get(i)).getIncoming().isEmpty()) {
                    ArgumentElement temp = (ArgumentElement)((IConnection)((IConnector)e.getConnectors().get(i)).getIncoming().get(0)).getSource().getOwner();
                    if (temp instanceof AwayArgumentElement) {
                        if (((AwayArgumentElement)temp).getPointsTo() == null) {
                            return;
                        }
                        AwayArgumentElement temp2 = (AwayArgumentElement)((IConnection)((IConnector)e.getConnectors().get(i)).getIncoming().get(0)).getSource().getOwner();
                        if (!MaintenanceUtils.containsEqualChange(referencedChange, temp2.getPointsTo())) {
                            change = MaintenanceUtils.createImpactedChange(temp2.getPointsTo(), referencedChange);
                            temp2.getPointsTo().getAffectedByCurrentChanges().add((Object)change);
                            temp.getAffectedByCurrentChanges().add((Object)change);
                        }
                        MaintenanceUtils.propagatePotentialImpactForChallengedArgElement(temp2.getPointsTo(), referencedChange);
                    } else if (!MaintenanceUtils.containsEqualChange(referencedChange, temp)) {
                        change = MaintenanceUtils.createImpactedChange(temp, referencedChange);
                        temp.getAffectedByCurrentChanges().add((Object)change);
                        MaintenanceUtils.propagatedImpactOnAllAwayElements(temp, change);
                        MaintenanceUtils.propagatePotentialImpactForChallengedArgElement(temp, referencedChange);
                    }
                }
                ++i;
            }
        }
    }

    public static maintenanceStatus getActualMaintainanceStatus(ArgumentElement argElement) {
        if (!argElement.getAffectedByCurrentChanges().isEmpty()) {
            for (Change change : argElement.getAffectedByCurrentChanges()) {
                if (!change.getMaintainanceCause().equals((Object)maintenanceStatus.CHALLENGED)) continue;
                return maintenanceStatus.CHALLENGED;
            }
            for (Change change : argElement.getAffectedByCurrentChanges()) {
                if (!change.getMaintainanceCause().equals((Object)maintenanceStatus.ACTUALLY_IMPACTED)) continue;
                return maintenanceStatus.ACTUALLY_IMPACTED;
            }
            for (Change change : argElement.getAffectedByCurrentChanges()) {
                if (!change.getMaintainanceCause().equals((Object)maintenanceStatus.POTENTIALLY_IMPACTED)) continue;
                return maintenanceStatus.POTENTIALLY_IMPACTED;
            }
        }
        return null;
    }

    public static Change getChallengedOrPotentiallyChange(ArgumentElement argElement) {
        if (!argElement.getAffectedByCurrentChanges().isEmpty()) {
            for (Change change : argElement.getAffectedByCurrentChanges()) {
                if (!change.getMaintainanceCause().equals((Object)maintenanceStatus.CHALLENGED)) continue;
                return change;
            }
            for (Change change : argElement.getAffectedByCurrentChanges()) {
                if (!change.getMaintainanceCause().equals((Object)maintenanceStatus.POTENTIALLY_IMPACTED)) continue;
                return change;
            }
        }
        return null;
    }

    public static Change createImpactedChange(ArgumentElement e, Change referencedChange) {
        Change change = SafetyCasesModelElementFactory.createChange();
        change.setContainer((IHierarchicElementContainer)e);
        change.setMaintainanceCause(maintenanceStatus.POTENTIALLY_IMPACTED);
        change.setModelElement(referencedChange.getModelElement());
        if (referencedChange.getPersonalizedTypeOfChange() != null) {
            change.setPersonalizedTypeOfChange(referencedChange.getPersonalizedTypeOfChange());
        } else if (!referencedChange.getPredefinedTypeOfChange().equals((Object)"NONE")) {
            change.setPredefinedTypeOfChange(referencedChange.getPredefinedTypeOfChange());
        }
        return change;
    }

    public static boolean equalsChange(Change change1, Change change2) {
        if (change2.getPersonalizedTypeOfChange() != null && change1.getPersonalizedTypeOfChange() != null ? !change1.getPersonalizedTypeOfChange().equals(change2.getPersonalizedTypeOfChange()) : !change1.getPredefinedTypeOfChange().equals((Object)change2.getPredefinedTypeOfChange())) {
            return false;
        }
        return change1.getModelElement().equals(change2.getModelElement());
    }

    public static boolean containsEqualChange(Change change, ArgumentElement argElement) {
        for (Change currentChange : argElement.getAffectedByCurrentChanges()) {
            if (!MaintenanceUtils.equalsChange(currentChange, change)) continue;
            return true;
        }
        return false;
    }

    public static Change returnsEqualChange(Change change, ArgumentElement argElement2) {
        for (Change currentChange : argElement2.getAffectedByCurrentChanges()) {
            if (!MaintenanceUtils.equalsChange(currentChange, change)) continue;
            return currentChange;
        }
        return null;
    }

    public static void propagatedImpactOnAllAwayElements(ArgumentElement selectedArgumentElement, Change change) {
        if (selectedArgumentElement instanceof Goal || selectedArgumentElement instanceof Solution || selectedArgumentElement instanceof Context) {
            EList awayElements = new ArrayList();
            if (selectedArgumentElement instanceof Goal) {
                awayElements = ((Goal)selectedArgumentElement).getReferencedByAwayGoals();
            } else if (selectedArgumentElement instanceof Solution) {
                awayElements = ((Solution)selectedArgumentElement).getReferencedByAwaySolutions();
            } else if (selectedArgumentElement instanceof Context) {
                awayElements = ((Context)selectedArgumentElement).getReferencedByAwayContexts();
            }
            for (AwayArgumentElement el : awayElements) {
                if (MaintenanceUtils.containsEqualChange(change, (ArgumentElement)el)) continue;
                el.getAffectedByCurrentChanges().add((Object)change);
                MaintenanceUtils.propagatePotentialImpactForChallengedArgElement((ArgumentElement)el, change);
            }
        }
    }

    public static void propagatedImpactOnAwayElements(ArgumentElement selectedArgumentElement, Change change) {
        if (selectedArgumentElement instanceof Goal || selectedArgumentElement instanceof Solution || selectedArgumentElement instanceof Context) {
            EList awayElements = new ArrayList();
            if (selectedArgumentElement instanceof Goal) {
                awayElements = ((Goal)selectedArgumentElement).getReferencedByAwayGoals();
            } else if (selectedArgumentElement instanceof Solution) {
                awayElements = ((Solution)selectedArgumentElement).getReferencedByAwaySolutions();
            } else if (selectedArgumentElement instanceof Context) {
                awayElements = ((Context)selectedArgumentElement).getReferencedByAwayContexts();
            }
            for (AwayArgumentElement el : awayElements) {
                if (MaintenanceUtils.containsEqualChange(change, (ArgumentElement)el)) continue;
                el.getAffectedByCurrentChanges().add((Object)change);
            }
        }
    }

    public static void removePropagatedImpactOnAwayElements(ArgumentElement selectedArgumentElement, Change change) {
        if (selectedArgumentElement instanceof Goal || selectedArgumentElement instanceof Solution || selectedArgumentElement instanceof Context) {
            EList awayElements = new ArrayList();
            if (selectedArgumentElement instanceof Goal) {
                awayElements = ((Goal)selectedArgumentElement).getReferencedByAwayGoals();
            } else if (selectedArgumentElement instanceof Solution) {
                awayElements = ((Solution)selectedArgumentElement).getReferencedByAwaySolutions();
            } else if (selectedArgumentElement instanceof Context) {
                awayElements = ((Context)selectedArgumentElement).getReferencedByAwayContexts();
            }
            for (AwayArgumentElement el : awayElements) {
                if (!MaintenanceUtils.containsEqualChange(change, (ArgumentElement)el)) continue;
                el.getAffectedByCurrentChanges().remove((Object)change);
            }
        }
    }

    public static void propagateGoalOrStrategy(ArgumentElement e, Change referencedChange) {
        int i = 0;
        while (i < e.getConnectors().size()) {
            if (!((IConnector)e.getConnectors().get(i)).getOutgoing().isEmpty()) {
                temp = (ArgumentElement)((IConnection)((IConnector)e.getConnectors().get(i)).getOutgoing().get(0)).getTarget().getOwner();
                if (temp instanceof AwayArgumentElement) {
                    if (((AwayArgumentElement)temp).getPointsTo() == null) {
                        return;
                    }
                    temp2 = (AwayArgumentElement)((IConnection)((IConnector)e.getConnectors().get(i)).getOutgoing().get(0)).getTarget().getOwner();
                    if (!MaintenanceUtils.containsEqualChange(referencedChange, temp2.getPointsTo())) {
                        change = MaintenanceUtils.createImpactedChange(temp2.getPointsTo(), referencedChange);
                        temp2.getPointsTo().getAffectedByCurrentChanges().add((Object)change);
                        temp.getAffectedByCurrentChanges().add((Object)change);
                    }
                    MaintenanceUtils.propagatePotentialImpactForChallengedArgElement(temp2.getPointsTo(), referencedChange);
                } else if (!MaintenanceUtils.containsEqualChange(referencedChange, temp)) {
                    change = MaintenanceUtils.createImpactedChange(temp, referencedChange);
                    temp.getAffectedByCurrentChanges().add((Object)change);
                    MaintenanceUtils.propagatedImpactOnAllAwayElements(temp, change);
                    MaintenanceUtils.propagatePotentialImpactForChallengedArgElement(temp, referencedChange);
                }
            } else if (!((IConnector)e.getConnectors().get(i)).getIncoming().isEmpty()) {
                temp = (ArgumentElement)((IConnection)((IConnector)e.getConnectors().get(i)).getIncoming().get(0)).getSource().getOwner();
                if (temp instanceof AwayArgumentElement) {
                    if (((AwayArgumentElement)temp).getPointsTo() == null) {
                        return;
                    }
                    temp2 = (AwayArgumentElement)((IConnection)((IConnector)e.getConnectors().get(i)).getIncoming().get(0)).getSource().getOwner();
                    if (!MaintenanceUtils.containsEqualChange(referencedChange, temp2.getPointsTo())) {
                        change = MaintenanceUtils.createImpactedChange(temp2.getPointsTo(), referencedChange);
                        temp2.getPointsTo().getAffectedByCurrentChanges().add((Object)change);
                        temp.getAffectedByCurrentChanges().add((Object)change);
                    }
                    MaintenanceUtils.propagatePotentialImpactForChallengedArgElement(temp2.getPointsTo(), referencedChange);
                } else if (!MaintenanceUtils.containsEqualChange(referencedChange, temp)) {
                    change = MaintenanceUtils.createImpactedChange(temp, referencedChange);
                    temp.getAffectedByCurrentChanges().add((Object)change);
                    MaintenanceUtils.propagatedImpactOnAllAwayElements(temp, change);
                    MaintenanceUtils.propagatePotentialImpactForChallengedArgElement(temp, referencedChange);
                }
            }
            ++i;
        }
    }
}

