/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.utils;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.fortiss.af3.safetycases.ui.utils.Utils;
import org.fortiss.tooling.base.ui.dialog.ElementTreeSingleSelectDialogGUI;
import org.fortiss.tooling.base.ui.dialog.IDialogEditSupport;
import org.fortiss.tooling.base.ui.dialog.MultiRootTreeContentProvider;

public class MultiPageWizard {
    private String preDefinedTypeOfChange = "NONE";
    private String personalizedTypeOfChange = "";
    private String typeOfMaintenanceCause = "";

    public String getPreDefinedTypeOfChange() {
        return this.preDefinedTypeOfChange;
    }

    public String getPersonalizedTypeOfChange() {
        return this.personalizedTypeOfChange;
    }

    public String getTypeOfMaintenanceCause() {
        return this.typeOfMaintenanceCause;
    }

    public class CreateMultiPageWizard
    extends Wizard {
        private SelectImpactWizard page;
        private SelectReferenceWizard page1;
        private TypeOfChangeWizard page2;

        public CreateMultiPageWizard(List<?> roots, Object selected, ITreeContentProvider contentProvider, ILabelProvider labelProvider, IDialogEditSupport edit) {
            this.page = new SelectImpactWizard();
            this.page1 = new SelectReferenceWizard(roots, selected, contentProvider, labelProvider, edit);
            this.page2 = new TypeOfChangeWizard();
            this.setNeedsProgressMonitor(true);
        }

        public String getWindowTitle() {
            return "Set as Impacted";
        }

        public void addPages() {
            this.addPage((IWizardPage)this.page);
            this.addPage((IWizardPage)this.page1);
            this.addPage((IWizardPage)this.page2);
        }

        public boolean performFinish() {
            this.dispose();
            return true;
        }

        public SelectImpactWizard getSelectImpactPage() {
            return this.page;
        }

        public SelectReferenceWizard getSelectReferencePage() {
            return this.page1;
        }

        public TypeOfChangeWizard getTypeOfChangePage() {
            return this.page2;
        }

        public boolean acceptElement(Object element) {
            return false;
        }
    }

    public class SelectImpactWizard
    extends WizardPage {
        private Text text;
        private Composite container;
        private Combo dropDownList;
        private ModifyListener listener;

        public SelectImpactWizard() {
            super("SelectImpact");
            this.setTitle("Change the maintenance cause of the argument element");
            this.setDescription("You can set the maintenance cause of an argument element as Challenged, Actually Impacted or Potentially Impacted.");
            this.setControl((Control)this.text);
        }

        public void createControl(Composite parent) {
            if (!this.getShell().isDisposed() && !this.getShell().getDisplay().isDisposed()) {
                this.getShell().setSize(530, 270);
                Utils.centerWizard(this.getShell());
                this.container = new Composite(parent, 0);
                FillLayout fillLayout = new FillLayout();
                fillLayout.type = 512;
                this.container.setLayout((Layout)fillLayout);
                this.setPageComplete(false);
                Label label1 = new Label(this.container, 0);
                label1.setText("Choose maintenance cause");
                this.dropDownList = new Combo(this.container, 0);
                this.dropDownList.setItems(new String[]{"Challenged", "Potentially Impacted", "Actually Impacted"});
                this.dropDownList.setText("NONE");
                this.listener = new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (!SelectImpactWizard.this.getShell().isDisposed()) {
                            if (!SelectImpactWizard.this.dropDownList.getText().equals("NONE")) {
                                SelectImpactWizard.this.setPageComplete(true);
                                ((SelectImpactWizard)SelectImpactWizard.this).MultiPageWizard.this.typeOfMaintenanceCause = SelectImpactWizard.this.dropDownList.getText();
                            } else if (SelectImpactWizard.this.text.getText().isEmpty()) {
                                SelectImpactWizard.this.setPageComplete(false);
                            }
                        }
                    }
                };
                this.dropDownList.addModifyListener(this.listener);
                this.setControl((Control)this.container);
            }
        }

        public void dispose() {
            super.dispose();
            this.dropDownList.removeModifyListener(this.listener);
        }

        public String getText() {
            return this.text.getText();
        }

        public Combo getDropDownList() {
            return this.dropDownList;
        }

        public String getComboText() {
            return this.dropDownList.getText();
        }
    }

    public class SelectReferenceWizard
    extends WizardPage {
        private Composite container;
        private ElementTreeSingleSelectDialogGUI gui;
        private ArrayList<Object> rootElements;
        private TreePath selectedPath;
        private ITreeContentProvider contentSupport;
        private ILabelProvider labelSupport;
        private IDialogEditSupport dialogEditSupport;

        protected SelectReferenceWizard(List<?> roots, Object selected, ITreeContentProvider contentProvider, ILabelProvider labelProvider, IDialogEditSupport edit) {
            super("Page1");
            this.setTitle("Reference an artifac");
            this.setDescription("You can choose which artifact is referenced by this ArgumentElement");
            this.rootElements = roots == null ? new ArrayList() : new ArrayList(roots);
            this.dialogEditSupport = edit;
            this.contentSupport = contentProvider;
            this.labelSupport = labelProvider;
            this.selectedPath = selected == null ? null : this.computeTreePath(this.rootElements, selected);
        }

        public void createControl(Composite parent) {
            this.container = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            this.container.setLayout((Layout)layout);
            this.gui = new ElementTreeSingleSelectDialogGUI(this.container, 0);
            this.gui.setLayoutData((Object)new GridData(1808));
            if (this.dialogEditSupport == null) {
                this.gui.getLeftToolBar().setVisible(false);
                ((GridData)this.gui.getLeftToolBar().getLayoutData()).exclude = true;
            }
            this.gui.getElementTreeViewer().setLabelProvider((IBaseLabelProvider)this.labelSupport);
            this.gui.getElementTreeViewer().setContentProvider((IContentProvider)new MultiRootTreeContentProvider(this.rootElements, this.contentSupport));
            this.gui.getElementTreeViewer().setInput(this.rootElements);
            if (this.selectedPath != null) {
                this.gui.getElementTreeViewer().setSelection((ISelection)new TreeSelection(this.selectedPath), true);
            }
            this.setPageComplete(false);
            this.gui.getElementTreeViewer().addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    SelectReferenceWizard.this.selectElement();
                }
            });
            this.setControl((Control)this.container);
        }

        public List<Object> getRootElements() {
            return this.rootElements;
        }

        public Object getSelectedElement() {
            if (this.selectedPath == null) {
                return null;
            }
            return this.selectedPath.getLastSegment();
        }

        public ElementTreeSingleSelectDialogGUI getGui() {
            return this.gui;
        }

        public IStructuredContentProvider getContentProvider() {
            return this.contentSupport;
        }

        public ILabelProvider getLabelProvider() {
            return this.labelSupport;
        }

        private void selectElement() {
            ITreeSelection selection = (ITreeSelection)this.gui.getElementTreeViewer().getSelection();
            if (selection.getPaths() == null || selection.getPaths().length != 1 || !((CreateMultiPageWizard)this.getWizard()).acceptElement(selection.getPaths()[0].getLastSegment())) {
                this.selectedPath = null;
                this.setPageComplete(false);
            } else {
                this.selectedPath = selection.getPaths()[0];
                this.setPageComplete(true);
            }
        }

        private TreePath computeTreePath(List<?> roots, Object leaf) {
            LinkedList<Object> path = new LinkedList<Object>();
            Object parent = leaf;
            while (!roots.contains(parent)) {
                path.addFirst(parent);
                parent = this.contentSupport.getParent(parent);
                if (parent != null) continue;
                return null;
            }
            path.addFirst(parent);
            return new TreePath(path.toArray());
        }
    }

    public class TypeOfChangeWizard
    extends WizardPage {
        private Text text;
        private Composite container;
        private Combo dropDownList;
        private ModifyListener listener;

        public TypeOfChangeWizard() {
            super("Page2");
            this.setTitle("Select or define Type of Change");
            this.setDescription("You can choose to select a predefined Type of Change from the drop-down list OR to define it by yourself in the empty text field below.");
            this.setControl((Control)this.text);
        }

        public void createControl(Composite parent) {
            if (!this.getShell().isDisposed() && !this.getShell().getDisplay().isDisposed()) {
                this.container = new Composite(parent, 0);
                GridLayout layout = new GridLayout();
                this.container.setLayout((Layout)layout);
                layout.numColumns = 1;
                this.setPageComplete(false);
                Label label1 = new Label(this.container, 0);
                label1.setText("Choose Predefined Type of Change");
                this.dropDownList = new Combo(this.container, 0);
                this.dropDownList.setItems(new String[]{"NONE", "Add", "Remove", "Modify"});
                this.dropDownList.setText("NONE");
                Label label2 = new Label(this.container, 0);
                label2.setText("Define Type of change");
                this.text = new Text(this.container, 2052);
                GridData gd = new GridData(768);
                this.text.setLayoutData((Object)gd);
                this.text.setText("");
                this.listener = new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (!TypeOfChangeWizard.this.getShell().isDisposed()) {
                            if (!TypeOfChangeWizard.this.dropDownList.getText().equals("NONE")) {
                                TypeOfChangeWizard.this.setPageComplete(true);
                                TypeOfChangeWizard.this.text.setEnabled(false);
                                ((TypeOfChangeWizard)TypeOfChangeWizard.this).MultiPageWizard.this.preDefinedTypeOfChange = TypeOfChangeWizard.this.dropDownList.getText();
                            } else if (TypeOfChangeWizard.this.text.getText().isEmpty()) {
                                TypeOfChangeWizard.this.setPageComplete(false);
                                TypeOfChangeWizard.this.text.setEnabled(true);
                            }
                        }
                    }
                };
                this.dropDownList.addModifyListener(this.listener);
                this.text.addKeyListener(new KeyListener(){

                    public void keyPressed(KeyEvent e) {
                    }

                    public void keyReleased(KeyEvent e) {
                        if (!TypeOfChangeWizard.this.text.getText().isEmpty()) {
                            TypeOfChangeWizard.this.setPageComplete(true);
                            TypeOfChangeWizard.this.dropDownList.setEnabled(false);
                            ((TypeOfChangeWizard)TypeOfChangeWizard.this).MultiPageWizard.this.personalizedTypeOfChange = TypeOfChangeWizard.this.text.getText();
                        } else if (TypeOfChangeWizard.this.dropDownList.getText().equals("NONE")) {
                            TypeOfChangeWizard.this.setPageComplete(false);
                            TypeOfChangeWizard.this.dropDownList.setEnabled(true);
                        }
                    }
                });
                this.setControl((Control)this.container);
            }
        }

        public void dispose() {
            super.dispose();
            this.dropDownList.removeModifyListener(this.listener);
        }

        public String getText() {
            return this.text.getText();
        }

        public Combo getDropDownList() {
            return this.dropDownList;
        }

        public String getComboText() {
            return this.dropDownList.getText();
        }
    }
}

