/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.safetycases.model.ArgumentElement;
import org.fortiss.af3.safetycases.model.ArgumentElementBase;
import org.fortiss.af3.safetycases.model.ExitConnector;
import org.fortiss.af3.safetycases.model.OptionEntity;
import org.fortiss.af3.safetycases.ui.utils.GSNSelectionDialogUtils;
import org.fortiss.af3.safetycases.ui.utils.InstantiationOfGSNElementsUtils;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;

public class OptionEntityInstantiation {
    public static void instantiateOptionEntity(OptionEntity optionEntity) {
        Shell activeShell = Display.getCurrent().getActiveShell();
        if (optionEntity.getNumberOfOptions() == 0) {
            MessageDialog.openWarning((Shell)activeShell, (String)"", (String)"You have no options!");
            return;
        }
        ArrayList<ArgumentElementBase> options = new ArrayList<ArgumentElementBase>();
        for (ExitConnector exitConnector : optionEntity.getExitConnectors()) {
            options.add((ArgumentElementBase)((IConnection)exitConnector.getOutgoing().get(0)).getTarget().getOwner());
        }
        int requiredNumber = optionEntity.getRequiredNumber();
        EList<ArgumentElement> selected = GSNSelectionDialogUtils.openOptions(activeShell, options, requiredNumber);
        if (selected == null) {
            return;
        }
        OptionEntityInstantiation.removeOptionalArgElementsThatAreNotSelected(options, selected);
        HashMap<ArgumentElement, String> targetsList = new HashMap<ArgumentElement, String>();
        HashMap<ArgumentElement, Integer> targetsListMultiplicity = new HashMap<ArgumentElement, Integer>();
        InstantiationOfGSNElementsUtils.computeTargetsList((ArgumentElement)optionEntity, targetsList, targetsListMultiplicity);
        HashMap<ArgumentElementBase, String> sourcesList = new HashMap<ArgumentElementBase, String>();
        InstantiationOfGSNElementsUtils.computeSourcesList(sourcesList, (ArgumentElement)optionEntity);
        OptionEntityInstantiation.removeOptionEntityFromArgStructure(optionEntity, selected, sourcesList);
    }

    private static void removeOptionalArgElementsThatAreNotSelected(ArrayList<ArgumentElementBase> options, EList<ArgumentElement> selected) {
        options.removeAll((Collection<?>)selected);
        for (final ArgumentElementBase toBeDeletedArgEle : options) {
            ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)toBeDeletedArgEle.getContainer());
            topLevel.runAsCommand(new Runnable(){

                @Override
                public void run() {
                    InstantiationOfGSNElementsUtils.deleteFromEntryConnector(toBeDeletedArgEle);
                }
            });
        }
    }

    private static void removeOptionEntityFromArgStructure(final OptionEntity optionEntity, final EList<ArgumentElement> selected, final HashMap<ArgumentElementBase, String> sourcesList) {
        ITopLevelElement topLevel1 = IPersistencyService.getInstance().getTopLevelElementFor((EObject)optionEntity.getContainer());
        topLevel1.runAsCommand(new Runnable(){

            @Override
            public void run() {
                OptionEntityInstantiation.deleteOptionEntity(optionEntity);
                for (ArgumentElement argEle : selected) {
                    InstantiationOfGSNElementsUtils.createConnectionsBetweenCopyAndTheOriginalSources(sourcesList, argEle);
                }
            }
        });
    }

    private static void deleteOptionEntity(OptionEntity optionEntity) {
        InstantiationOfGSNElementsUtils.deleteIncomingAndOutgoingConnections((IHierarchicElement)optionEntity);
        EcoreUtil.remove((EObject)optionEntity);
    }
}

