/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.utils;

import org.eclipse.swt.graphics.Color;
import org.fortiss.af3.safetycases.model.ArgumentElement;
import org.fortiss.af3.safetycases.model.ArgumentElementBase;
import org.fortiss.af3.safetycases.model.SafetyCasesConnection;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;

public class QuantitativeEvaluationUtils {
    public static Color GRAY = new Color(null, 128, 128, 128);
    private static final int DEMPSTER_SCHAFFER_CONST = 2;

    public static boolean isLeaf(ArgumentElementBase element) {
        for (IConnector conn : element.getConnectors()) {
            if (conn.getOutgoing().size() <= 0) continue;
            return false;
        }
        return true;
    }

    public static float sumConnectionWeights(ArgumentElement element) {
        float aux = 0.0f;
        for (IConnector ct : element.getConnectors()) {
            for (IConnection conn : ct.getOutgoing()) {
                if (!(conn instanceof SafetyCasesConnection)) continue;
                aux += ((ArgumentElement)conn.getTarget().getOwner()).getWeight();
            }
        }
        return aux;
    }

    public static float sumCompletedTasks(ArgumentElement element) {
        if (QuantitativeEvaluationUtils.isLeaf((ArgumentElementBase)element)) {
            return element.getDefeatersOutruled();
        }
        float aux = 0.0f;
        for (IConnector ct : element.getConnectors()) {
            for (IConnection conn : ct.getOutgoing()) {
                if (!(conn instanceof SafetyCasesConnection)) continue;
                ArgumentElement argumentElement = (ArgumentElement)conn.getTarget().getOwner();
                aux += argumentElement.getWeight() * QuantitativeEvaluationUtils.sumCompletedTasks(argumentElement);
            }
        }
        return aux;
    }

    public static float sumTotalTasks(ArgumentElement element) {
        if (QuantitativeEvaluationUtils.isLeaf((ArgumentElementBase)element)) {
            return element.getDefeatersTotal();
        }
        float aux = 0.0f;
        for (IConnector ct : element.getConnectors()) {
            for (IConnection conn : ct.getOutgoing()) {
                if (!(conn instanceof SafetyCasesConnection)) continue;
                ArgumentElement argumentElement = (ArgumentElement)conn.getTarget().getOwner();
                aux += argumentElement.getWeight() * QuantitativeEvaluationUtils.sumTotalTasks((ArgumentElement)conn.getTarget().getOwner());
            }
        }
        return aux;
    }

    public static float computeBelief(float totalTasks, float completedTasks) {
        float alpha = completedTasks;
        float beta = totalTasks - completedTasks;
        return alpha / (alpha + beta + 2.0f);
    }

    public static float computeDisbelief(float totalTasks, float completedTasks) {
        float alpha = completedTasks;
        float beta = totalTasks - completedTasks;
        return beta / (alpha + beta + 2.0f);
    }

    public static float computeUncertainty(float totalTasks, float completedTasks) {
        float alpha = completedTasks;
        float beta = totalTasks - completedTasks;
        return 2.0f / (alpha + beta + 2.0f);
    }

    public static String dempsterShaferString(float defeatersTotal, float defeatersOutruled, float weight) {
        float belief = QuantitativeEvaluationUtils.computeBelief(defeatersTotal, defeatersOutruled);
        float disbelief = QuantitativeEvaluationUtils.computeDisbelief(defeatersTotal, defeatersOutruled);
        float uncertainty = QuantitativeEvaluationUtils.computeUncertainty(defeatersTotal, defeatersOutruled);
        return "[b:" + String.format("%.2f", Float.valueOf(belief)) + "; d:" + String.format("%.2f", Float.valueOf(disbelief)) + ";u:" + String.format("%.2f", Float.valueOf(uncertainty)) + "; w:" + String.format("%.1f", Float.valueOf(weight)) + "]";
    }

    public static String defeaterString(float defeatersTotal, float defeatersOutruled) {
        return String.format("%.1f", Float.valueOf(defeatersOutruled)) + "/" + String.format("%.1f", Float.valueOf(defeatersTotal));
    }

    public static Color dempsterShaferColor(float defeatersTotal, float defeatersOutruled) {
        float belief = QuantitativeEvaluationUtils.computeBelief(defeatersTotal, defeatersOutruled);
        float disbelief = QuantitativeEvaluationUtils.computeDisbelief(defeatersTotal, defeatersOutruled);
        float RGB_MAX = 255.0f;
        int red = Math.round(RGB_MAX * (1.0f - belief));
        int green = Math.round(RGB_MAX * (1.0f - disbelief));
        return new Color(null, red, green, 0);
    }
}

