/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.utils;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.fortiss.af3.safetycases.model.ArgumentElement;
import org.fortiss.af3.safetycases.model.ArgumentElementBase;
import org.fortiss.af3.safetycases.model.ArgumentModule;
import org.fortiss.af3.safetycases.model.SafetyCase;

public class StringToGsnIdValidator
implements IValidator<Object> {
    private ArgumentElementBase editedObject;

    public StringToGsnIdValidator(ArgumentElementBase editedObject) {
        this.editedObject = editedObject;
    }

    public IStatus validate(Object value) {
        try {
            String s = value.toString().trim();
            if (s.isEmpty() || s.equals("")) {
                throw new IllegalArgumentException("Please provide an id for this safety argument element!");
            }
            boolean valid = true;
            SafetyCase safetyCase = null;
            if (this.editedObject instanceof ArgumentElement) {
                safetyCase = (SafetyCase)this.editedObject.getContainer().eContainer();
            } else if (this.editedObject instanceof ArgumentModule) {
                safetyCase = (SafetyCase)this.editedObject.getContainer();
            }
            if (safetyCase != null) {
                block2: for (ArgumentModule argModule : safetyCase.getContainedArgumentModules()) {
                    boolean duplicatedId;
                    if (this.editedObject instanceof ArgumentElement) {
                        for (ArgumentElement ae : argModule.getContainedArgumentElements()) {
                            boolean duplicatedId2;
                            boolean notEditedObj = !ae.equals(this.editedObject);
                            boolean idNotEmpty = ae.getGsnID() != "";
                            boolean bl = duplicatedId2 = ae.getGsnID() != null && ae.getGsnID().equals(s);
                            if (!notEditedObj || !idNotEmpty || !duplicatedId2) continue;
                            valid = false;
                            continue block2;
                        }
                        continue;
                    }
                    if (!(this.editedObject instanceof ArgumentModule)) continue;
                    if (s == "") {
                        valid = false;
                        break;
                    }
                    boolean notEditedObj = !argModule.equals(this.editedObject);
                    boolean idNotEmpty = argModule.getGsnID() != "";
                    boolean bl = duplicatedId = argModule.getGsnID() != null && argModule.getGsnID().equals(s);
                    if (!notEditedObj || !idNotEmpty || !duplicatedId) continue;
                    valid = false;
                    break;
                }
            }
            if (!valid) {
                if (this.editedObject instanceof ArgumentElement) {
                    throw new IllegalArgumentException("There is another safety argument element with this id!");
                }
                if (this.editedObject instanceof ArgumentModule && !s.isEmpty()) {
                    throw new IllegalArgumentException("There is another safety argument module with this id!");
                }
            }
        }
        catch (Exception e) {
            return ValidationStatus.error((String)e.getMessage());
        }
        return ValidationStatus.ok();
    }
}

