/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.utils;

import java.awt.MouseInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.allocation.utils.AllocationUtils;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.mira.model.Requirement;
import org.fortiss.af3.mode.model.Mode;
import org.fortiss.af3.mode.model.ModeAutomaton;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.platform.model.allocation.ComponentToExecutionUnitAllocationTable;
import org.fortiss.af3.safetycases.model.ArgumentElement;
import org.fortiss.af3.safetycases.utils.SafetyCasesUtils;
import org.fortiss.af3.state.model.State;
import org.fortiss.af3.state.model.StateAutomaton;
import org.fortiss.tooling.base.model.base.HierarchicElementBase;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.ui.service.IModelEditorBindingService;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class TextHyperlinkingUtils {
    public static void addML(IFigure fig, final ArgumentElement argEle) {
        fig.addMouseMotionListener(new MouseMotionListener(){
            Shell shell = new Shell(0);

            public void mouseMoved(MouseEvent me) {
                if (!this.shell.isDisposed()) {
                    this.shell.close();
                }
            }

            public void mouseHover(MouseEvent me) {
                this.shell = new Shell(0);
                this.shell.setLocation(MouseInfo.getPointerInfo().getLocation().x, MouseInfo.getPointerInfo().getLocation().y);
                Link link = new Link((Composite)this.shell, 0);
                StringTokenizer stringTokenizer = new StringTokenizer(argEle.getTextualInformation());
                Object string = "";
                int index = 0;
                while (stringTokenizer.hasMoreElements()) {
                    string = ++index % 5 == 0 ? (String)string + stringTokenizer.nextToken() + " \n" : (String)string + stringTokenizer.nextToken() + " ";
                }
                argEle.getTextualInformation();
                String textualInfo = argEle.getTextualInformation();
                EList listOfStateAutomata = null;
                EList listOfModeAutomata = null;
                ArrayList listOfComponents = KernelModelElementUtils.getRootElement((EObject)argEle, ComponentArchitecture.class) != null ? SafetyCasesUtils.getAllLogicalComponents((HierarchicElementBase)argEle) : null;
                if (listOfComponents != null) {
                    int i = 0;
                    while (i < listOfComponents.size()) {
                        Component c = (Component)listOfComponents.get(i);
                        if (textualInfo.contains(c.getName()) && !((String)string).contains("<a>" + c.getName() + "</a>")) {
                            string = ((String)string).replace(c.getName(), "<a>" + c.getName() + "</a>");
                        }
                        listOfModeAutomata = EcoreUtils.pickInstanceOf(ModeAutomaton.class, (List)c.getSpecifications());
                        string = TextHyperlinkingUtils.identifyModeNames((String)string, textualInfo, (EList<ModeAutomaton>)listOfModeAutomata);
                        listOfStateAutomata = EcoreUtils.pickInstanceOf(StateAutomaton.class, (List)c.getSpecifications());
                        string = TextHyperlinkingUtils.identifyStateNames((String)string, textualInfo, (EList<StateAutomaton>)listOfStateAutomata);
                        ++i;
                    }
                }
                EList listOfCa2Hw = AllocationUtils.getAllocationTables((EObject)argEle, ComponentToExecutionUnitAllocationTable.class);
                string = TextHyperlinkingUtils.identifyCa2HwNames((String)string, textualInfo, (List<ComponentToExecutionUnitAllocationTable>)listOfCa2Hw);
                List listOfParch = KernelModelElementUtils.getRootElements((EObject)argEle, PlatformArchitecture.class);
                string = TextHyperlinkingUtils.identifyPlatformElementNames((String)string, textualInfo, listOfParch);
                ArrayList<Requirement> listOfRequirements = null;
                string = TextHyperlinkingUtils.identifyRequirementNames((String)string, textualInfo, listOfRequirements);
                ArrayList listOfGoals = argEle.getContainerSafetyCase() != null ? SafetyCasesUtils.getAllOfSameType((ArgumentElement)argEle) : null;
                string = TextHyperlinkingUtils.identifyGoalNames((String)string, textualInfo, listOfGoals);
                TextHyperlinkingUtils.createLink(link, (String)string, listOfComponents, (EList<ModeAutomaton>)listOfModeAutomata, (EList<StateAutomaton>)listOfStateAutomata, (List<ComponentToExecutionUnitAllocationTable>)listOfCa2Hw, listOfParch, listOfRequirements, listOfGoals);
                this.shell.pack();
                this.shell.open();
            }

            public void mouseExited(MouseEvent me) {
            }

            public void mouseEntered(MouseEvent me) {
            }

            public void mouseDragged(MouseEvent me) {
            }
        });
    }

    private static String identifyGoalNames(String string, String textualInfo, ArrayList<ArgumentElement> listOfGoals) {
        if (listOfGoals != null) {
            int i = 0;
            while (i < listOfGoals.size()) {
                ArgumentElement goal = listOfGoals.get(i);
                if (goal.getName() != null && textualInfo.contains(goal.getName()) && !string.contains("<a>" + goal.getName() + "</a>")) {
                    string = string.replace(goal.getName(), "<a>" + goal.getName() + "</a>");
                }
                ++i;
            }
        }
        return string;
    }

    private static String identifyRequirementNames(String string, String textualInfo, ArrayList<Requirement> listOfRequirements) {
        if (listOfRequirements != null) {
            int i = 0;
            while (i < listOfRequirements.size()) {
                Requirement sr = listOfRequirements.get(i);
                if (textualInfo.contains(sr.getReqId()) && !string.contains("<a>" + sr.getReqId() + "</a>")) {
                    string = string.replace(sr.getReqId(), "<a>" + sr.getReqId() + "</a>");
                }
                ++i;
            }
        }
        return string;
    }

    private static String identifyPlatformElementNames(String string, String textualInfo, List<PlatformArchitecture> parchList) {
        for (PlatformArchitecture pa : parchList) {
            if (textualInfo.contains(pa.getName()) && !string.contains("<a>" + pa.getName() + "</a>")) {
                string = string.replace(pa.getName(), "<a>" + pa.getName() + "</a>");
            }
            for (IHierarchicElement ihe : pa.getContainedElements()) {
                INamedElement platformElement;
                if (!(ihe instanceof INamedElement) || !textualInfo.contains((platformElement = (INamedElement)ihe).getName()) || string.contains("<a>" + platformElement.getName() + "</a>")) continue;
                string = string.replace(platformElement.getName(), "<a>" + platformElement.getName() + "</a>");
            }
        }
        return string;
    }

    private static String identifyCa2HwNames(String string, String textualInfo, List<ComponentToExecutionUnitAllocationTable> ca2hwList) {
        for (ComponentToExecutionUnitAllocationTable ca2hw : ca2hwList) {
            if (!textualInfo.contains(ca2hw.getName()) || string.contains("<a>" + ca2hw.getName() + "</a>")) continue;
            string = string.replace(ca2hw.getName(), "<a>" + ca2hw.getName() + "</a>");
        }
        return string;
    }

    private static String identifyStateNames(String string, String textualInfo, EList<StateAutomaton> stateAutomata) {
        for (StateAutomaton sa : stateAutomata) {
            for (State s : sa.getRootState().getSubStates()) {
                if (!textualInfo.contains(s.getName()) || string.contains("<a>" + s.getName() + "</a>")) continue;
                string = string.replace(s.getName(), "<a>" + s.getName() + "</a>");
            }
        }
        return string;
    }

    private static String identifyModeNames(String string, String textualInfo, EList<ModeAutomaton> modeAutomata) {
        for (ModeAutomaton ma : modeAutomata) {
            for (Mode m : ma.getRootMode().getSubModes()) {
                if (!textualInfo.contains(m.getName()) || string.contains("<a>" + m.getName() + "</a>")) continue;
                string = string.replace(m.getName(), "<a>" + m.getName() + "</a>");
            }
        }
        return string;
    }

    public static void createLink(Link link, String string, final ArrayList<Component> listOfComponents, final EList<ModeAutomaton> listOfModeAutomata, final EList<StateAutomaton> listOfStateAutomata, final List<ComponentToExecutionUnitAllocationTable> listOfCa2Hw, final List<PlatformArchitecture> listOfParch, final ArrayList<Requirement> listOfRequirements, final ArrayList<ArgumentElement> listOfGoals) {
        link.setText(string);
        link.pack();
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                this.openMatchingElementsInEditor(event, listOfComponents, this::getName);
                this.openMatchingElementsInEditor(event, listOfCa2Hw, this::getName);
                this.openMatchingElementsInEditor(event, listOfGoals, this::getName);
                this.openMatchingElementsInEditor(event, listOfRequirements, this::getReqId);
                List listOfModes = listOfModeAutomata != null ? listOfModeAutomata.stream().flatMap(m -> m.getRootMode().getSubModes().stream()).collect(Collectors.toList()) : null;
                this.openMatchingElementsInEditor(event, listOfModes, this::getName);
                List listOfStates = listOfStateAutomata != null ? listOfStateAutomata.stream().flatMap(sa -> sa.getRootState().getSubStates().stream()).collect(Collectors.toList()) : null;
                this.openMatchingElementsInEditor(event, listOfStates, this::getName);
                List listPlatformElements = listOfParch != null ? listOfParch.stream().flatMap(pa -> pa.getContainedElements().stream().filter(e -> e instanceof INamedElement)).collect(Collectors.toList()) : null;
                this.openMatchingElementsInEditor(event, listPlatformElements, this::getName);
            }

            private String getName(EObject obj) {
                return obj instanceof INamedElement ? ((INamedElement)obj).getName() : null;
            }

            private String getReqId(EObject obj) {
                return obj instanceof Requirement ? ((Requirement)obj).getReqId() : null;
            }

            private void openMatchingElementsInEditor(Event event, List<? extends IModelElement> modelElements, Function<EObject, String> getName) {
                if (modelElements != null) {
                    for (IModelElement iModelElement : modelElements) {
                        if (!event.text.contains(getName.apply((EObject)iModelElement))) continue;
                        IModelEditorBindingService.getInstance().openInEditor((EObject)iModelElement);
                    }
                }
            }
        });
    }
}

