/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.safetyargumentationpackage.model.SafetyArgumentationPackage;
import org.fortiss.af3.safetycases.model.ArgumentElement;
import org.fortiss.af3.safetycases.model.ArgumentModule;
import org.fortiss.af3.safetycases.model.Change;
import org.fortiss.af3.safetycases.model.Context;
import org.fortiss.af3.safetycases.model.DecomposableSpinalElement;
import org.fortiss.af3.safetycases.model.Goal;
import org.fortiss.af3.safetycases.model.Solution;
import org.fortiss.af3.safetycases.model.Strategy;
import org.fortiss.af3.safetycases.model.TypeOfChange;
import org.fortiss.af3.safetycases.model.VISIBILITY;
import org.fortiss.af3.safetycases.model.maintenanceStatus;
import org.fortiss.af3.safetycases.ui.utils.MultiPageWizard;
import org.fortiss.tooling.kernel.ui.extension.IModelElementHandler;
import org.fortiss.tooling.kernel.ui.service.IModelElementHandlerService;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class Utils {
    public static boolean hasToBeDevelopedElements(ArgumentModule argumentModule) {
        for (ArgumentElement ae : argumentModule.getContainedArgumentElements()) {
            if (!(ae instanceof DecomposableSpinalElement) || !((DecomposableSpinalElement)ae).isToBeDeveloped()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasToBeInstantiatedElements(ArgumentModule argumentModule) {
        for (ArgumentElement ae : argumentModule.getContainedArgumentElements()) {
            if (!ae.isToBeInstantiated()) continue;
            return true;
        }
        return false;
    }

    public static boolean messageComponentHasNoInputPorts() {
        return MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"", (String)"The selected component has no input ports!");
    }

    public static boolean messageChangeReferencedInputPorts() {
        return MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"", (String)"You are about to change the referenced input ports!");
    }

    public static void cannotBeInstantiated(ArgumentElement selectedArgumentElement) {
        if (selectedArgumentElement.isToBeInstantiated() && !selectedArgumentElement.getTextualInformation().contains("{") && !selectedArgumentElement.getTextualInformation().contains("}")) {
            selectedArgumentElement.setToBeInstantiated(false);
        } else if (selectedArgumentElement.getTextualInformation().contains("{") || selectedArgumentElement.getTextualInformation().contains("}")) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"", (String)"This element cannot be set as instantiated since its claim still contains uninstantiated words!");
        }
    }

    public static void setUndevelopedEntity(ArgumentElement currentlySelectedSection) {
        if (currentlySelectedSection instanceof Goal) {
            if (!((Goal)currentlySelectedSection).isToBeDeveloped()) {
                ((Goal)currentlySelectedSection).setToBeDeveloped(true);
            } else {
                ((Goal)currentlySelectedSection).setToBeDeveloped(false);
            }
        } else if (!((Strategy)currentlySelectedSection).isToBeDeveloped()) {
            ((Strategy)currentlySelectedSection).setToBeDeveloped(true);
        } else {
            ((Strategy)currentlySelectedSection).setToBeDeveloped(false);
        }
    }

    public static void setToPrivateOrPublic(ArgumentElement currentlySelectedSection) {
        if (currentlySelectedSection != null) {
            if (currentlySelectedSection instanceof Goal) {
                if (((Goal)currentlySelectedSection).getVisibility() == VISIBILITY.PRIVATE) {
                    ((Goal)currentlySelectedSection).setVisibility(VISIBILITY.PUBLIC);
                } else {
                    ((Goal)currentlySelectedSection).setVisibility(VISIBILITY.PRIVATE);
                }
            }
            if (currentlySelectedSection instanceof Solution) {
                if (((Solution)currentlySelectedSection).getVisibility() == VISIBILITY.PRIVATE) {
                    ((Solution)currentlySelectedSection).setVisibility(VISIBILITY.PUBLIC);
                } else {
                    ((Solution)currentlySelectedSection).setVisibility(VISIBILITY.PRIVATE);
                }
            }
            if (currentlySelectedSection instanceof Context) {
                if (((Context)currentlySelectedSection).getVisibility() == VISIBILITY.PRIVATE) {
                    ((Context)currentlySelectedSection).setVisibility(VISIBILITY.PUBLIC);
                } else {
                    ((Context)currentlySelectedSection).setVisibility(VISIBILITY.PRIVATE);
                }
            }
        }
    }

    public static void centerWizard(Shell shell) {
        Display display = shell.getDisplay();
        Monitor primary = display.getPrimaryMonitor();
        Rectangle displayBounds = primary.getBounds();
        Point size = shell.getSize();
        Point defaultLocation = new Point((displayBounds.width - size.x) / 2, (displayBounds.height - size.y) / 2);
        shell.setLocation(defaultLocation);
    }

    public static String returnStringTypeOfMaintenance(maintenanceStatus maintenanceStatus2) {
        if (maintenanceStatus2 != null) {
            switch (maintenanceStatus2) {
                case CHALLENGED: {
                    return "Challenged";
                }
                case POTENTIALLY_IMPACTED: {
                    return "Potentially Impacted";
                }
                case ACTUALLY_IMPACTED: {
                    return "Actually Impacted";
                }
            }
            return "";
        }
        return "";
    }

    public static List<String> getNameAndClass(Change change) {
        if (change.getModelElement() != null) {
            int beginIndex = change.getModelElement().toString().indexOf("name: ") + 6;
            int endIndex = change.getModelElement().toString().indexOf(", comment", beginIndex);
            String name = change.getModelElement().toString().substring(beginIndex, endIndex);
            beginIndex = change.getModelElement().getClass().getCanonicalName().lastIndexOf(46) + 1;
            endIndex = change.getModelElement().getClass().getCanonicalName().lastIndexOf("Impl");
            String className = change.getModelElement().toString().substring(beginIndex, endIndex);
            return new ArrayList<String>(Arrays.asList(name, className));
        }
        return null;
    }

    public static void setTypeOfMaintenance(MultiPageWizard wiz, Change change) {
        block13: {
            if (wiz.getTypeOfMaintenanceCause().equals("NONE")) break block13;
            switch (wiz.getTypeOfMaintenanceCause()) {
                case "Challenged": {
                    change.setMaintainanceCause(maintenanceStatus.CHALLENGED);
                    break;
                }
                case "Potentially Impacted": {
                    change.setMaintainanceCause(maintenanceStatus.POTENTIALLY_IMPACTED);
                    break;
                }
                case "Actually Impacted": {
                    change.setMaintainanceCause(maintenanceStatus.ACTUALLY_IMPACTED);
                    break;
                }
                default: {
                    change.setMaintainanceCause(null);
                }
            }
        }
    }

    public static String returnStringTypeOfChanges(TypeOfChange typeOfChange) {
        if (typeOfChange != null) {
            switch (typeOfChange) {
                case ADD: {
                    return "Add";
                }
                case MODIFIED: {
                    return "Modified";
                }
                case DELETE: {
                    return "Delete";
                }
            }
            return "";
        }
        return "";
    }

    public static List<EObject> alreadyReferencedElements(ArgumentElement argElem) {
        ArrayList<EObject> existingReferences = new ArrayList<EObject>();
        existingReferences.addAll((Collection<EObject>)argElem.getReferencedComponents());
        existingReferences.addAll((Collection<EObject>)argElem.getReferencedDeployments());
        existingReferences.addAll((Collection<EObject>)argElem.getReferencedModes());
        existingReferences.addAll((Collection<EObject>)argElem.getReferencedPTA());
        existingReferences.addAll((Collection<EObject>)argElem.getReferencedRequirements());
        existingReferences.addAll((Collection<EObject>)argElem.getReferencedStates());
        return existingReferences;
    }

    public static List<? extends EObject> getChildren(EObject parentElement) {
        IModelElementHandler base = IModelElementHandlerService.getInstance().getModelElementHandler(parentElement);
        if (base != null) {
            return base.getSubnodes(parentElement);
        }
        return Collections.emptyList();
    }

    public static List<EObject> getAllChildren(List<? extends EObject> parents) {
        List<Object> containedElements = new ArrayList();
        ArrayList<EObject> list = new ArrayList<EObject>();
        list.addAll(parents);
        for (EObject eObject : parents) {
            containedElements = Utils.getChildren(eObject).stream().filter(i -> !list.contains(i)).collect(Collectors.toList());
            list.addAll(containedElements);
        }
        if (containedElements.isEmpty() || parents.containsAll(containedElements)) {
            return list;
        }
        return Utils.getAllChildren(list);
    }

    public static List<EObject> getAllSpecificChildrens(List<? extends EObject> parents, Class<?>[] classes) {
        Object containedElements = new ArrayList();
        ArrayList<EObject> list = new ArrayList<EObject>();
        list.addAll(parents);
        for (EObject eObject : parents) {
            containedElements = EcoreUtils.pickInstanceOf(Arrays.asList(classes), Utils.getChildren(eObject));
            containedElements = containedElements.stream().filter(Predicate.not(list::contains)).collect(Collectors.toList());
            list.addAll((Collection<EObject>)containedElements);
        }
        if (containedElements.isEmpty() || parents.containsAll((Collection<?>)containedElements)) {
            return list;
        }
        return Utils.getAllSpecificChildrens(list, classes);
    }

    public static List<EObject> noReferenceableAwayArgumentElements(ArgumentElement element, Class<?>[] classes, Class<?> myClass) {
        List sapList = KernelModelElementUtils.getRootElements((EObject)element, SafetyArgumentationPackage.class);
        ArrayList<EObject> referenced = new ArrayList();
        referenced = Utils.getAllSpecificChildrens(sapList, classes);
        referenced = referenced.stream().filter(myClass::isInstance).filter(e -> !((ArgumentElement)e).getContainer().equals(element.getContainer())).collect(Collectors.toList());
        return referenced;
    }
}

