/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.partition;

import org.eclipse.core.runtime.Plugin;
import org.fortiss.af3.allocation.IAllocationService;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.partition.model.MemoryArea;
import org.fortiss.af3.partition.model.Partition;
import org.fortiss.af3.partition.model.PartitionArchitecture;
import org.fortiss.af3.partition.model.PartitionInputPort;
import org.fortiss.af3.partition.model.PartitionOutputPort;
import org.fortiss.af3.partition.model.PartitionPort;
import org.fortiss.af3.partition.model.PartitionQueuingInputPort;
import org.fortiss.af3.partition.model.PartitionQueuingOutputPort;
import org.fortiss.af3.partition.model.PartitionSamplingInputPort;
import org.fortiss.af3.partition.model.PartitionSamplingOutputPort;
import org.fortiss.af3.partition.model.allocation.ComponentToPartitionAllocationEntry;
import org.fortiss.af3.partition.model.allocation.ComponentToPartitionAllocationTable;
import org.fortiss.af3.partition.model.allocation.InputPortToPartitionInputPortAllocationEntry;
import org.fortiss.af3.partition.model.allocation.MemoryAreaAllocationEntry;
import org.fortiss.af3.partition.model.allocation.MemoryAreaAllocationTable;
import org.fortiss.af3.partition.model.allocation.OutputPortToPartitionOutputPortAllocationEntry;
import org.fortiss.af3.partition.model.allocation.PartitionInputPortToReceiverAllocationEntry;
import org.fortiss.af3.partition.model.allocation.PartitionOutputPortToTransmitterAllocationEntry;
import org.fortiss.af3.partition.model.allocation.PartitionPortToTransceiverAllocationEntry;
import org.fortiss.af3.partition.model.allocation.PartitionToExecutionUnitAllocationEntry;
import org.fortiss.af3.partition.model.allocation.PartitionToExecutionUnitAllocationTable;
import org.fortiss.af3.partition.model.allocation.TaskInputPortToPartitionInputPortAllocationEntry;
import org.fortiss.af3.partition.model.allocation.TaskOutputPortToPartitionOutputPortAllocationEntry;
import org.fortiss.af3.partition.model.allocation.TaskToPartitionAllocationEntry;
import org.fortiss.af3.partition.model.allocation.TaskToPartitionAllocationTable;
import org.fortiss.af3.partition.model.timing.InterPartitionSignalReceiveEvent;
import org.fortiss.af3.partition.model.timing.InterPartitionSignalSendEvent;
import org.fortiss.af3.partition.model.timing.PartitionStartEvent;
import org.fortiss.af3.partition.model.timing.PartitionTerminateEvent;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.platform.model.Receiver;
import org.fortiss.af3.platform.model.Transceiver;
import org.fortiss.af3.platform.model.Transmitter;
import org.fortiss.af3.platform.model.allocation.ComponentToExecutionUnitAllocationTable;
import org.fortiss.af3.platform.model.generic.GenericExecutionUnit;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskArchitecture;
import org.fortiss.af3.task.model.TaskInputPort;
import org.fortiss.af3.task.model.TaskOutputPort;
import org.fortiss.af3.task.model.allocation.TaskMemoryAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskMemoryAllocationTable;
import org.fortiss.af3.task.model.allocation.TaskOutputPortMemoryAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationTable;
import org.fortiss.af3.task.model.allocation.TaskWcetTable;
import org.fortiss.af3.timing.ITimingSpecificationService;
import org.osgi.framework.BundleContext;

public class AF3PartitionActivator
extends Plugin {
    public static final String PLUGIN_ID = AF3PartitionActivator.class.getPackage().getName();
    private static AF3PartitionActivator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.setupComponentToPartitionAllocations();
        this.setupTaskToPartitionAllocations();
        this.setupPartitionToExecutionUnitAllocations();
        this.setupMemoryTables();
        this.setupCoveredAllocations();
    }

    private void setupComponentToPartitionAllocations() {
        IAllocationService as = IAllocationService.getInstance();
        as.addAllocationTableType(ComponentToPartitionAllocationTable.class, ComponentArchitecture.class, PartitionArchitecture.class);
        as.addAllocationEntryType(ComponentToPartitionAllocationTable.class, ComponentToPartitionAllocationEntry.class, Component.class, Partition.class);
        as.addAllocationEntryType(ComponentToPartitionAllocationTable.class, InputPortToPartitionInputPortAllocationEntry.class, InputPort.class, PartitionInputPort.class, ComponentToPartitionAllocationEntry.class);
        as.addAllocationEntryType(ComponentToPartitionAllocationTable.class, OutputPortToPartitionOutputPortAllocationEntry.class, OutputPort.class, PartitionOutputPort.class, ComponentToPartitionAllocationEntry.class);
        as.addCoveredModelType(ComponentToPartitionAllocationTable.class, TaskArchitecture.class);
    }

    private void setupTaskToPartitionAllocations() {
        IAllocationService as = IAllocationService.getInstance();
        as.addAllocationTableType(TaskToPartitionAllocationTable.class, TaskArchitecture.class, PartitionArchitecture.class);
        as.addAllocationEntryType(TaskToPartitionAllocationTable.class, TaskToPartitionAllocationEntry.class, Task.class, Partition.class);
        as.addAllocationEntryType(TaskToPartitionAllocationTable.class, TaskInputPortToPartitionInputPortAllocationEntry.class, TaskInputPort.class, PartitionInputPort.class, TaskToPartitionAllocationEntry.class);
        as.addAllocationEntryType(TaskToPartitionAllocationTable.class, TaskOutputPortToPartitionOutputPortAllocationEntry.class, TaskOutputPort.class, PartitionOutputPort.class, TaskToPartitionAllocationEntry.class);
        as.addAdmissibleAllocationTablePair(TaskWcetTable.class, TaskToPartitionAllocationTable.class);
        as.addAdmissibleAllocationTablePair(TaskMemoryAllocationTable.class, TaskToPartitionAllocationTable.class);
    }

    private void setupPartitionToExecutionUnitAllocations() {
        IAllocationService as = IAllocationService.getInstance();
        as.addAllocationTableType(PartitionToExecutionUnitAllocationTable.class, PartitionArchitecture.class, PlatformArchitecture.class);
        as.addAllocationEntryType(PartitionToExecutionUnitAllocationTable.class, PartitionToExecutionUnitAllocationEntry.class, Partition.class, GenericExecutionUnit.class);
        as.addAllocationEntryType(PartitionToExecutionUnitAllocationTable.class, PartitionInputPortToReceiverAllocationEntry.class, PartitionInputPort.class, Receiver.class, PartitionToExecutionUnitAllocationEntry.class);
        as.addAllocationEntryType(PartitionToExecutionUnitAllocationTable.class, PartitionOutputPortToTransmitterAllocationEntry.class, PartitionOutputPort.class, Transmitter.class, PartitionToExecutionUnitAllocationEntry.class);
        as.addAllocationEntryType(PartitionToExecutionUnitAllocationTable.class, PartitionPortToTransceiverAllocationEntry.class, PartitionPort.class, Transceiver.class, PartitionToExecutionUnitAllocationEntry.class);
        as.addAdmissibleAllocationTablePair(TaskWcetTable.class, PartitionToExecutionUnitAllocationTable.class);
        as.addAdmissibleAllocationTablePair(TaskMemoryAllocationTable.class, PartitionToExecutionUnitAllocationTable.class);
        as.addSourceEntityMutualEntryTypeExclusion(PartitionPortToTransceiverAllocationEntry.class, PartitionInputPortToReceiverAllocationEntry.class);
        as.addSourceEntityMutualEntryTypeExclusion(PartitionPortToTransceiverAllocationEntry.class, PartitionOutputPortToTransmitterAllocationEntry.class);
    }

    private void setupMemoryTables() {
        IAllocationService as = IAllocationService.getInstance();
        as.addAllocationTableType(MemoryAreaAllocationTable.class, PartitionArchitecture.class, PlatformArchitecture.class, true);
        as.addAdmissibleAllocationTablePair(MemoryAreaAllocationTable.class, PartitionToExecutionUnitAllocationTable.class);
        as.addTargetEntityType(MemoryAreaAllocationEntry.class, MemoryArea.class);
        as.addSourceEntityMutualEntryTypeExclusion(MemoryAreaAllocationEntry.class, MemoryAreaAllocationEntry.class);
        as.addAllocationTableType(TaskMemoryAllocationTable.class, TaskArchitecture.class, PartitionArchitecture.class);
        as.addAllocationEntryType(TaskMemoryAllocationTable.class, TaskMemoryAllocationEntry.class, Task.class, MemoryArea.class);
        as.addAllocationEntryType(TaskMemoryAllocationTable.class, TaskOutputPortMemoryAllocationEntry.class, TaskOutputPort.class, MemoryArea.class);
        as.addAdmissibleAllocationTablePair(TaskMemoryAllocationTable.class, MemoryAreaAllocationTable.class);
    }

    private void setupCoveredAllocations() {
        IAllocationService as = IAllocationService.getInstance();
        as.addCoveredModelType(ComponentToExecutionUnitAllocationTable.class, PartitionArchitecture.class);
        as.addCoveredModelType(TaskToExecutionUnitAllocationTable.class, PartitionArchitecture.class);
    }

    public static void setupTimingEvents() {
        ITimingSpecificationService tss = ITimingSpecificationService.getInstance();
        tss.addEntityEventElementType(PartitionStartEvent.class, Partition.class);
        tss.addEventTypeName(PartitionStartEvent.class, "Partition started");
        tss.addEntityEventElementType(PartitionTerminateEvent.class, Partition.class);
        tss.addEventTypeName(PartitionTerminateEvent.class, "Partition terminated");
        tss.addEntityEventElementType(InterPartitionSignalSendEvent.class, PartitionQueuingOutputPort.class);
        tss.addEntityEventElementType(InterPartitionSignalSendEvent.class, PartitionSamplingOutputPort.class);
        tss.addEventTypeName(InterPartitionSignalSendEvent.class, "Inter Partition Signal sent");
        tss.addEntityEventElementType(InterPartitionSignalReceiveEvent.class, PartitionQueuingInputPort.class);
        tss.addEntityEventElementType(InterPartitionSignalReceiveEvent.class, PartitionSamplingInputPort.class);
        tss.addEventTypeName(InterPartitionSignalReceiveEvent.class, "Inter Partition Signal received");
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static AF3PartitionActivator getDefault() {
        return plugin;
    }
}

