/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.partition.compositor;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.partition.model.MemoryArea;
import org.fortiss.af3.partition.model.MemoryAreaChannel;
import org.fortiss.af3.partition.model.MemoryAreaInputPort;
import org.fortiss.af3.partition.model.MemoryAreaOutputPort;
import org.fortiss.af3.partition.model.Partition;
import org.fortiss.af3.partition.model.PartitionArchitecture;
import org.fortiss.af3.partition.util.PartitionModelElementFactory;
import org.fortiss.tooling.base.compose.ConnectionCompositorBase;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.kernel.extension.data.IConnectionCompositionContext;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class MemoryAreaConnectionCompositor
extends ConnectionCompositorBase<IHierarchicElement, EObject, EObject> {
    public boolean canConnect(EObject source, EObject target, IHierarchicElement parent, IConnectionCompositionContext context) {
        boolean isTargetEntityMemoryArea;
        boolean isSourceEntityPartition = source instanceof MemoryAreaOutputPort && source.eContainer() instanceof Partition;
        boolean bl = isTargetEntityMemoryArea = target instanceof MemoryAreaInputPort && target.eContainer() instanceof MemoryArea;
        return isSourceEntityPartition && isTargetEntityMemoryArea;
    }

    public boolean connect(EObject source, EObject target, IHierarchicElement parent, IConnectionCompositionContext context) {
        PartitionArchitecture pArch = (PartitionArchitecture)parent;
        boolean isConnectionExisting = pArch.getConnections().stream().anyMatch(s -> s.getSource().equals(source) && s.getTarget().equals(target));
        if (isConnectionExisting) {
            return false;
        }
        MemoryAreaChannel connection = this.createConnection();
        UniqueIDUtils.prepareUniqueID((EObject)connection, (EObject)parent);
        pArch.getConnections().add((Object)connection);
        connection.setSource((IConnector)source);
        connection.setTarget((IConnector)target);
        return true;
    }

    protected MemoryAreaChannel createConnection() {
        return PartitionModelElementFactory.createMemoryAreaChannel("");
    }

    public boolean canDisconnect(EObject connection) {
        return connection instanceof MemoryAreaChannel;
    }
}

