/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.partition.compositor;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.partition.model.PartitionArchitecture;
import org.fortiss.af3.partition.model.PartitionChannel;
import org.fortiss.af3.partition.model.PartitionQueuingInputPort;
import org.fortiss.af3.partition.model.PartitionQueuingOutputPort;
import org.fortiss.af3.partition.model.PartitionSamplingInputPort;
import org.fortiss.af3.partition.model.PartitionSamplingOutputPort;
import org.fortiss.af3.partition.util.PartitionModelElementFactory;
import org.fortiss.tooling.base.compose.ConnectionCompositorBase;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.kernel.extension.data.IConnectionCompositionContext;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class PartitionConnectionCompositor
extends ConnectionCompositorBase<IHierarchicElement, EObject, EObject> {
    public boolean canConnect(EObject source, EObject target, IHierarchicElement parent, IConnectionCompositionContext context) {
        return target instanceof PartitionQueuingInputPort && source instanceof PartitionQueuingOutputPort || target instanceof PartitionSamplingOutputPort && source instanceof PartitionSamplingInputPort || target instanceof PartitionSamplingInputPort && source instanceof PartitionSamplingOutputPort || target instanceof PartitionSamplingOutputPort && source instanceof PartitionSamplingInputPort;
    }

    public boolean connect(EObject source, EObject target, IHierarchicElement parent, IConnectionCompositionContext context) {
        PartitionArchitecture pArch = (PartitionArchitecture)parent;
        EList<PartitionChannel> pChannels = pArch.getPartitionChannels();
        boolean isPChannelExisting = pChannels.stream().anyMatch(s -> s.getSource().equals(source) && s.getTarget().equals(target));
        if (isPChannelExisting) {
            return false;
        }
        PartitionChannel pChan = this.createConnection();
        UniqueIDUtils.prepareUniqueID((EObject)pChan, (EObject)parent);
        pArch.getConnections().add((Object)pChan);
        pChan.setSource((IConnector)source);
        pChan.setTarget((IConnector)target);
        return true;
    }

    protected PartitionChannel createConnection() {
        return PartitionModelElementFactory.createPartitionChannel("");
    }

    public boolean canDisconnect(EObject connection) {
        return connection instanceof PartitionChannel;
    }
}

