/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.partition.util;

import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.utils.ComponentArchitectureTransformationBase;
import org.fortiss.af3.partition.model.Partition;
import org.fortiss.af3.partition.model.PartitionArchitecture;
import org.fortiss.af3.partition.model.PartitionChannel;
import org.fortiss.af3.partition.model.PartitionInputPort;
import org.fortiss.af3.partition.model.PartitionOutputPort;
import org.fortiss.af3.partition.model.allocation.ComponentToPartitionAllocationEntry;
import org.fortiss.af3.partition.model.allocation.ComponentToPartitionAllocationTable;
import org.fortiss.af3.partition.model.allocation.InputPortToPartitionInputPortAllocationEntry;
import org.fortiss.af3.partition.model.allocation.OutputPortToPartitionOutputPortAllocationEntry;
import org.fortiss.af3.partition.util.PartitionModelElementFactory;

public class ComponentToPartitionArchitectureTransformation
extends ComponentArchitectureTransformationBase<PartitionArchitecture, ComponentToPartitionAllocationTable, Partition, PartitionInputPort, PartitionOutputPort, PartitionChannel, ComponentToPartitionAllocationEntry, InputPortToPartitionInputPortAllocationEntry, OutputPortToPartitionOutputPortAllocationEntry> {
    public ComponentToPartitionArchitectureTransformation() {
        super(ComponentToPartitionAllocationEntry.class, InputPortToPartitionInputPortAllocationEntry.class, OutputPortToPartitionOutputPortAllocationEntry.class);
    }

    protected PartitionArchitecture createEntityArchitecture(Component component) {
        return PartitionModelElementFactory.createPartitionArchitecture("Partition Architecture (generated for: " + component.getName() + ")");
    }

    protected ComponentToPartitionAllocationTable createAllocationTable(PartitionArchitecture partitionArchitecture, ComponentArchitecture componentArchitecture, AllocationTableCollection atc) {
        return PartitionModelElementFactory.createComponentToPartitionAllocationTable(componentArchitecture.getTopComponent().getName() + "\u2192" + partitionArchitecture.getName());
    }

    protected Partition createEntity(Component comp) {
        return PartitionModelElementFactory.createPartition("Partition_" + comp.getName());
    }

    protected PartitionOutputPort createEntityOutputPort(OutputPort outputPort) {
        return PartitionModelElementFactory.createPartitionSamplingOutputPort(outputPort.getName());
    }

    protected PartitionInputPort createEntityInputPort(InputPort inputPort) {
        return PartitionModelElementFactory.createPartitionSamplingInputPort(inputPort.getName());
    }

    protected PartitionChannel createEntityConnection(PartitionOutputPort partitionOutputPort, PartitionInputPort partitionInputPort) {
        String pChanName = "pChan " + partitionOutputPort.getName() + "\u2192" + partitionInputPort.getName();
        return PartitionModelElementFactory.createPartitionChannel(partitionOutputPort, partitionInputPort, pChanName);
    }

    protected Partition getEntity(Component comp, ComponentToPartitionAllocationTable ca2pa) {
        Partition partition = ca2pa.getPartition(comp);
        if (partition == null) {
            throw new RuntimeException("The component-to-partition architecture transformation should map each logical component to one partition.");
        }
        return partition;
    }

    protected PartitionInputPort getEntityInputPort(InputPort inputPort, ComponentToPartitionAllocationTable ca2pa) {
        PartitionInputPort partitionInputPort = ca2pa.getPartitionInputPort(inputPort);
        if (partitionInputPort == null) {
            throw new RuntimeException("The component-to-partition architecture transformation should map each logical input port to one partition input port.");
        }
        return partitionInputPort;
    }

    protected PartitionOutputPort getEntityOutputPort(OutputPort outputPort, ComponentToPartitionAllocationTable ca2pa) {
        PartitionOutputPort partitionOutputPort = ca2pa.getPartitionOutputPort(outputPort);
        if (partitionOutputPort == null) {
            throw new RuntimeException("The component-to-partition architecture transformation should map each logical output port to one partition output port.");
        }
        return partitionOutputPort;
    }
}

