/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.partition.util;

import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.partition.model.Partition;
import org.fortiss.af3.partition.model.allocation.PartitionToExecutionUnitAllocationEntry;
import org.fortiss.af3.partition.model.allocation.PartitionToExecutionUnitAllocationTable;
import org.fortiss.af3.partition.model.allocation.TaskToPartitionAllocationEntry;
import org.fortiss.af3.partition.model.allocation.TaskToPartitionAllocationTable;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.task.model.Task;

public class PartitionArchitectureUtils {
    public static Collection<ExecutionUnit> getPhysicalResource(Task task, TaskToPartitionAllocationTable taskAllocation, PartitionToExecutionUnitAllocationTable partitionAllocation) {
        EList taskEntries = taskAllocation.getAllocationEntries(TaskToPartitionAllocationEntry.class);
        EList partitionEntries = partitionAllocation.getAllocationEntries(PartitionToExecutionUnitAllocationEntry.class);
        Partition partition = PartitionArchitectureUtils.getPartitionAllocation(task, (Collection<TaskToPartitionAllocationEntry>)taskEntries);
        Collection<ExecutionUnit> executionUnits = PartitionArchitectureUtils.getExecutionUnitsAllocation(partition, (Collection<PartitionToExecutionUnitAllocationEntry>)partitionEntries);
        return executionUnits;
    }

    public static Partition getPartitionAllocation(Task task, Collection<TaskToPartitionAllocationEntry> allocations) {
        Optional<TaskToPartitionAllocationEntry> optionalAllocationEntry = allocations.stream().filter(allocation -> allocation.getSourceElements().contains((Object)task)).findAny();
        if (optionalAllocationEntry.isPresent()) {
            return (Partition)optionalAllocationEntry.get().getTargetElement();
        }
        throw new NoSuchElementException();
    }

    public static Collection<ExecutionUnit> getExecutionUnitsAllocation(Partition partition, Collection<PartitionToExecutionUnitAllocationEntry> allocations) {
        Collection executionUnits = allocations.stream().filter(allocation -> allocation.getSourceElement() == partition).flatMap(allocation -> allocation.getTargetElements().stream()).map(target -> (ExecutionUnit)target).collect(Collectors.toSet());
        if (executionUnits.isEmpty()) {
            throw new NoSuchElementException();
        }
        return executionUnits;
    }
}

