/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.partition.util;

import org.fortiss.af3.partition.model.MemoryArea;
import org.fortiss.af3.partition.model.MemoryAreaChannel;
import org.fortiss.af3.partition.model.MemoryAreaInputPort;
import org.fortiss.af3.partition.model.MemoryAreaOutputPort;
import org.fortiss.af3.partition.model.Partition;
import org.fortiss.af3.partition.model.PartitionArchitecture;
import org.fortiss.af3.partition.model.PartitionChannel;
import org.fortiss.af3.partition.model.PartitionFactory;
import org.fortiss.af3.partition.model.PartitionInputPort;
import org.fortiss.af3.partition.model.PartitionOutputPort;
import org.fortiss.af3.partition.model.PartitionQueuingInputPort;
import org.fortiss.af3.partition.model.PartitionQueuingOutputPort;
import org.fortiss.af3.partition.model.PartitionSamplingInputPort;
import org.fortiss.af3.partition.model.PartitionSamplingOutputPort;
import org.fortiss.af3.partition.model.allocation.ComponentToPartitionAllocationTable;
import org.fortiss.af3.partition.model.allocation.PartitionAllocationFactory;
import org.fortiss.af3.partition.model.allocation.PartitionToExecutionUnitAllocationTable;
import org.fortiss.af3.partition.model.allocation.TaskToPartitionAllocationTable;
import org.fortiss.af3.platform.model.IPortSemantics;
import org.fortiss.af3.platform.model.IQueuingPort;
import org.fortiss.af3.platform.model.ISamplingPort;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.utils.LayoutModelElementFactory;
import org.fortiss.tooling.kernel.model.IProjectRootElement;

public class PartitionModelElementFactory {
    public static PartitionArchitecture createPartitionArchitecture(String name) {
        PartitionArchitecture partitionArchitecture = PartitionFactory.eINSTANCE.createPartitionArchitecture();
        partitionArchitecture.setName(name);
        return partitionArchitecture;
    }

    public static Partition createPartition(String name) {
        Partition partition = PartitionFactory.eINSTANCE.createPartition();
        partition.setName(name);
        LayoutModelElementFactory.createNodeElementLayout((ILayoutedModelElement)partition);
        return partition;
    }

    public static PartitionChannel createPartitionChannel(String name) {
        PartitionChannel pChan = PartitionFactory.eINSTANCE.createPartitionChannel();
        pChan.setName(name);
        LayoutModelElementFactory.createConnectionLayout((ILayoutedModelElement)pChan);
        return pChan;
    }

    public static PartitionChannel createPartitionChannel(PartitionOutputPort partitionOutputPort, PartitionInputPort partitionInputPort, String name) {
        PartitionChannel pChan = PartitionModelElementFactory.createPartitionChannel(name);
        pChan.setSource((IConnector)partitionOutputPort);
        pChan.setTarget((IConnector)partitionInputPort);
        return pChan;
    }

    public static PartitionInputPort createPartitionInputPort(String name, Class<? extends IPortSemantics> semantic) {
        if (ISamplingPort.class.isAssignableFrom(semantic)) {
            return PartitionModelElementFactory.createPartitionSamplingInputPort(name);
        }
        if (IQueuingPort.class.isAssignableFrom(semantic)) {
            return PartitionModelElementFactory.createPartitionQueuingInputPort(name);
        }
        return null;
    }

    public static PartitionOutputPort createPartitionOutputPort(String name, Class<? extends IPortSemantics> semantic) {
        if (ISamplingPort.class.isAssignableFrom(semantic)) {
            return PartitionModelElementFactory.createPartitionSamplingOutputPort(name);
        }
        if (IQueuingPort.class.isAssignableFrom(semantic)) {
            return PartitionModelElementFactory.createPartitionQueuingOutputPort(name);
        }
        return null;
    }

    public static PartitionQueuingInputPort createPartitionQueuingInputPort(String name) {
        PartitionQueuingInputPort pInPort = PartitionFactory.eINSTANCE.createPartitionQueuingInputPort();
        pInPort.setName(name);
        LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)pInPort);
        return pInPort;
    }

    public static PartitionQueuingOutputPort createPartitionQueuingOutputPort(String name) {
        PartitionQueuingOutputPort pOutPort = PartitionFactory.eINSTANCE.createPartitionQueuingOutputPort();
        pOutPort.setName(name);
        LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)pOutPort);
        return pOutPort;
    }

    public static PartitionSamplingInputPort createPartitionSamplingInputPort(String name) {
        PartitionSamplingInputPort pInPort = PartitionFactory.eINSTANCE.createPartitionSamplingInputPort();
        pInPort.setName(name);
        LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)pInPort);
        return pInPort;
    }

    public static PartitionSamplingOutputPort createPartitionSamplingOutputPort(String name) {
        PartitionSamplingOutputPort pOutPort = PartitionFactory.eINSTANCE.createPartitionSamplingOutputPort();
        pOutPort.setName(name);
        LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)pOutPort);
        return pOutPort;
    }

    public static MemoryArea createMemoryArea(String name) {
        MemoryArea memoryArea = PartitionFactory.eINSTANCE.createMemoryArea();
        memoryArea.setName(name);
        return memoryArea;
    }

    public static MemoryAreaInputPort createMemoryAreaInputPort(String name) {
        MemoryAreaInputPort memoryAreaInputPort = PartitionFactory.eINSTANCE.createMemoryAreaInputPort();
        memoryAreaInputPort.setName(name);
        LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)memoryAreaInputPort);
        return memoryAreaInputPort;
    }

    public static MemoryAreaOutputPort createMemoryAreaOutputPort(String name) {
        MemoryAreaOutputPort memoryAreaOutputPort = PartitionFactory.eINSTANCE.createMemoryAreaOutputPort();
        memoryAreaOutputPort.setName(name);
        LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)memoryAreaOutputPort);
        return memoryAreaOutputPort;
    }

    public static MemoryAreaChannel createMemoryAreaChannel(String name) {
        MemoryAreaChannel memoryAreaChannel = PartitionFactory.eINSTANCE.createMemoryAreaChannel();
        memoryAreaChannel.setName(name);
        LayoutModelElementFactory.createConnectionLayout((ILayoutedModelElement)memoryAreaChannel);
        return memoryAreaChannel;
    }

    public static ComponentToPartitionAllocationTable createComponentToPartitionAllocationTable(String name, IProjectRootElement sourceView, IProjectRootElement targetView) {
        ComponentToPartitionAllocationTable la2vaAllocationTable = PartitionModelElementFactory.createComponentToPartitionAllocationTable(name);
        la2vaAllocationTable.setSourceView(sourceView);
        la2vaAllocationTable.setTargetView(targetView);
        return la2vaAllocationTable;
    }

    public static ComponentToPartitionAllocationTable createComponentToPartitionAllocationTable(String name) {
        ComponentToPartitionAllocationTable ca2pa = PartitionAllocationFactory.eINSTANCE.createComponentToPartitionAllocationTable();
        ca2pa.setName(name);
        return ca2pa;
    }

    public static TaskToPartitionAllocationTable createTaskToPartitionAllocationTable(String name) {
        TaskToPartitionAllocationTable ta2pa = PartitionAllocationFactory.eINSTANCE.createTaskToPartitionAllocationTable();
        ta2pa.setName(name);
        return ta2pa;
    }

    public static TaskToPartitionAllocationTable createTaskToPartitionAllocationTable(String name, IProjectRootElement sourceView, IProjectRootElement targetView) {
        TaskToPartitionAllocationTable ta2pa = PartitionModelElementFactory.createTaskToPartitionAllocationTable(name);
        ta2pa.setSourceView(sourceView);
        ta2pa.setTargetView(targetView);
        return ta2pa;
    }

    public static PartitionToExecutionUnitAllocationTable createPartitionToExecutionUnitAllocationTable(String name) {
        PartitionToExecutionUnitAllocationTable pa2hw = PartitionAllocationFactory.eINSTANCE.createPartitionToExecutionUnitAllocationTable();
        pa2hw.setName(name);
        return pa2hw;
    }

    public static PartitionToExecutionUnitAllocationTable createPartitionToExecutionUnitAllocationTable(String name, IProjectRootElement sourceView, IProjectRootElement targetView) {
        PartitionToExecutionUnitAllocationTable pa2hw = PartitionModelElementFactory.createPartitionToExecutionUnitAllocationTable(name);
        pa2hw.setSourceView(sourceView);
        pa2hw.setTargetView(targetView);
        return pa2hw;
    }
}

