/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.sysml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.sysml16.allocations.Allocate;
import org.eclipse.papyrus.sysml16.blocks.Block;
import org.eclipse.papyrus.sysml16.blocks.NestedConnectorEnd;
import org.eclipse.papyrus.sysml16.blocks.ValueType;
import org.eclipse.papyrus.sysml16.deprecatedelements.FlowPort;
import org.eclipse.papyrus.sysml16.portsandflows.ProxyPort;
import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Realization;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.function.model.FunctionArchitecture;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.sysml.AF3SysMLToEMFMapping;
import org.fortiss.af3.sysml.SysMLLibrarySerializer;
import org.fortiss.af3.sysml.utils.AllocationsUMLPackageFactory;
import org.fortiss.af3.sysml.utils.DataDictionaryUMLPackageFactory;
import org.fortiss.af3.sysml.utils.FunctionArchitectureUMLPackageFactory;
import org.fortiss.af3.sysml.utils.LogicalArchitectureUMLPackageFactory;
import org.fortiss.af3.sysml.utils.PlatformArchitectureUMLPackageFactory;
import org.fortiss.af3.sysml.utils.SysMLExportFactory;
import org.fortiss.af3.sysml.utils.TaskArchitectureUMLPackageFactory;
import org.fortiss.af3.sysml.utils.tools.EnterpriseArchitectTransformer;
import org.fortiss.af3.sysml.utils.tools.ISysMLSyntaxTransformer;
import org.fortiss.af3.sysml.utils.tools.PapyrusTransformer;
import org.fortiss.af3.task.model.TaskArchitecture;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;

public class AF3SysMLExtractor
extends SysMLLibrarySerializer {
    private ComponentArchitecture ca;
    private DataDictionary dd;
    private PlatformArchitecture pa;
    private TaskArchitecture ta;
    private FunctionArchitecture fa;
    private AllocationTableCollection al;
    private EList<EObject> resourceContents;
    private Model umlModel;
    private Package umlRootEle;
    private AF3SysMLToEMFMapping mapping;
    private DataDictionaryUMLPackageFactory dataDictionaryUMLFactory;
    private LogicalArchitectureUMLPackageFactory logicalArchitectureUMLFactory;
    private TaskArchitectureUMLPackageFactory taskArchitectureUMLFactory;
    private PlatformArchitectureUMLPackageFactory platformArchitectureUMLFactory;
    private FunctionArchitectureUMLPackageFactory functionArchitectureUMLFactory;
    private AllocationsUMLPackageFactory allocationsUMLFactory;

    public AF3SysMLExtractor(FileProject fp, EList<IProjectRootElement> viewpoints) throws IOException, DiagnosticException {
        for (IProjectRootElement rootElement : viewpoints) {
            if (rootElement instanceof ComponentArchitecture) {
                this.ca = (ComponentArchitecture)rootElement;
                continue;
            }
            if (rootElement instanceof DataDictionary) {
                this.dd = (DataDictionary)rootElement;
                continue;
            }
            if (rootElement instanceof PlatformArchitecture) {
                this.pa = (PlatformArchitecture)rootElement;
                continue;
            }
            if (rootElement instanceof TaskArchitecture) {
                this.ta = (TaskArchitecture)rootElement;
                continue;
            }
            if (rootElement instanceof FunctionArchitecture) {
                this.fa = (FunctionArchitecture)rootElement;
                continue;
            }
            if (!(rootElement instanceof AllocationTableCollection)) continue;
            this.al = (AllocationTableCollection)rootElement;
        }
        this.resourceContents = new BasicEList();
        this.umlRootEle = SysMLExportFactory.createUMLPackage(fp.getName());
        this.umlModel = SysMLExportFactory.createUMLModel(fp.getName() + "_UML");
        this.umlModel.getPackagedElements().add((Object)this.umlRootEle);
        this.resourceContents.add((Object)this.umlModel);
        this.mapping = new AF3SysMLToEMFMapping(viewpoints);
        this.dataDictionaryUMLFactory = new DataDictionaryUMLPackageFactory(this.mapping);
        this.logicalArchitectureUMLFactory = new LogicalArchitectureUMLPackageFactory(this.mapping);
        this.taskArchitectureUMLFactory = new TaskArchitectureUMLPackageFactory(this.mapping);
        this.platformArchitectureUMLFactory = new PlatformArchitectureUMLPackageFactory(this.mapping);
        this.functionArchitectureUMLFactory = new FunctionArchitectureUMLPackageFactory(this.mapping);
        this.allocationsUMLFactory = new AllocationsUMLPackageFactory(this.mapping);
    }

    private void addSysMLValueTypesForDataTypes() {
        this.mapping.itMap.forEach((k, type) -> type.getOwnedAttributes().forEach(att -> {
            if (att.getType() instanceof DataType) {
                ValueType valueType = SysMLExportFactory.createSysMLValueType(att.getType());
                this.resourceContents.add((Object)valueType);
            }
        }));
    }

    private void addSysMLBlocksForClasses(Map<IHierarchicElement, Class> classMap) {
        classMap.forEach((k, umlEle) -> {
            Block newBlock = SysMLExportFactory.createSysMLBlock(umlEle);
            this.resourceContents.add((Object)newBlock);
            for (Connector con : umlEle.getOwnedConnectors()) {
                for (ConnectorEnd end : con.getEnds()) {
                    NestedConnectorEnd nestedConnectorEnd = SysMLExportFactory.createSysMLNestedConnectorEnd(end);
                    this.resourceContents.add((Object)nestedConnectorEnd);
                }
            }
        });
    }

    private void addSysMLPortsForPorts(Map<? extends IConnector, Port> portMap, String toolMode) {
        if (toolMode.equals("EA")) {
            portMap.forEach((k, port) -> {
                FlowPort flowPort = SysMLExportFactory.createSysMLFlowPort(port);
                this.resourceContents.add((Object)flowPort);
            });
        } else if (toolMode.equals("Papyrus")) {
            portMap.forEach((k, port) -> {
                ProxyPort proxyPort = SysMLExportFactory.createSysMLProxyPort(port);
                this.resourceContents.add((Object)proxyPort);
            });
        }
    }

    private void addSysMLAlloc(List<Abstraction> abstList) {
        abstList.forEach(abs -> {
            if (!(abs instanceof Realization)) {
                Allocate sysMLAlloc = SysMLExportFactory.createSysMLAllocate(abs);
                this.resourceContents.add((Object)sysMLAlloc);
            }
        });
    }

    public String transformFileProjectToSysML(String toolMode) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String utf8 = StandardCharsets.UTF_8.name();
        Throwable throwable = null;
        Object var5_6 = null;
        try (PrintStream ps = new PrintStream((OutputStream)baos, true, utf8);){
            this.addPack(this.dataDictionaryUMLFactory.createDataDictionaryUMLPackage(this.dd));
            this.addPack(this.logicalArchitectureUMLFactory.createLogicalArchitectureUMLPackage(this.ca));
            Package taRoot = this.taskArchitectureUMLFactory.createTaskArchitecturePackage(this.ta);
            this.addPack(taRoot);
            this.addPack(this.platformArchitectureUMLFactory.createPlatformArchitectureUMLPackage(this.pa));
            this.addPack(this.functionArchitectureUMLFactory.createFunctionArchitectureUMLPackage(this.fa));
            this.allocationsUMLFactory.buildAllocations(this.al, taRoot);
            this.addSysMLValueTypesForDataTypes();
            this.addSysMLBlocksForClasses(this.mapping.lvClassMap);
            this.addSysMLBlocksForClasses(this.mapping.paClassMap);
            this.addSysMLBlocksForClasses(this.mapping.taClassMap);
            this.addSysMLBlocksForClasses(this.mapping.faClassMap);
            this.addSysMLPortsForPorts(this.mapping.lvPortMap, toolMode);
            this.addSysMLPortsForPorts(this.mapping.paPortMap, toolMode);
            this.addSysMLPortsForPorts(this.mapping.taPortMap, toolMode);
            this.addSysMLAlloc(this.mapping.abstList);
            ResourceSet rSet = this.createResourceSet();
            Resource resource = rSet.createResource(this.createSaveURI(""));
            resource.getContents().addAll(this.resourceContents);
            this.saveResource(resource, ps);
            String fileString = baos.toString(utf8);
            fileString = ISysMLSyntaxTransformer.addSysMLSyntaxAdaptions(fileString, "<ownedAttribute (xmi:id=\".*\" name=\".*\" vis)", "<ownedAttribute xmi:type=\"uml:Property\" $1");
            fileString = ISysMLSyntaxTransformer.addSysMLSyntaxAdaptions(fileString, "<qualifier (xmi:id=\".*\" name=\".*\" type=\".*\" aggregation=\"composite\"/>)", "<qualifier xmi:type=\"uml:Port\" $1");
            fileString = ISysMLSyntaxTransformer.addSysMLSyntaxAdaptions(fileString, "<ownedConnector (xmi:id=\".*\" name=\".*\" visibility=\"public\">)", "<ownedConnector xmi:type=\"uml:Connector\" $1");
            fileString = ISysMLSyntaxTransformer.addSysMLSyntaxAdaptions(fileString, "<end (xmi:id=\".*\" partWithPort=\".*\" role=\".*\"/>)", "<end xmi:type=\"uml:ConnectorEnd\" $1");
            if (toolMode.equals("EA")) {
                EnterpriseArchitectTransformer eaTransform = new EnterpriseArchitectTransformer(this.umlModel, this.mapping, fileString);
                fileString = eaTransform.transform();
            } else if (toolMode.equals("Papyrus")) {
                PapyrusTransformer papTransform = new PapyrusTransformer(fileString);
                fileString = papTransform.transform();
            } else if (toolMode.equals("MagicDraw")) {
                EnterpriseArchitectTransformer magicTransform = new EnterpriseArchitectTransformer(this.umlModel, this.mapping, fileString);
                fileString = magicTransform.transform();
            }
            return fileString;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void addPack(Package pack) {
        if (!pack.getPackagedElements().isEmpty()) {
            this.umlRootEle.getPackagedElements().add((Object)pack);
        }
    }
}

