/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.sysml;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralReal;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.function.model.Function;
import org.fortiss.af3.function.model.FunctionArchitecture;
import org.fortiss.af3.platform.hierarchic.model.annotation.TransmissionUnitPower;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.platform.model.PlatformConnectorUnit;
import org.fortiss.af3.platform.model.annotation.FlashSize;
import org.fortiss.af3.platform.model.annotation.HardwareCost;
import org.fortiss.af3.platform.model.annotation.MessageSize;
import org.fortiss.af3.platform.model.annotation.PhysicalAccess;
import org.fortiss.af3.platform.model.annotation.PhysicalAccessType;
import org.fortiss.af3.platform.model.annotation.RamSize;
import org.fortiss.af3.platform.model.annotation.Weight;
import org.fortiss.af3.safety.model.annotation.SafetyIntegrityLevel;
import org.fortiss.af3.sysml.utils.DataDictionaryUMLPackageFactory;
import org.fortiss.af3.sysml.utils.SysMLExportFactory;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskArchitecture;
import org.fortiss.af3.task.model.TaskPort;
import org.fortiss.af3.task.model.annotation.FlashRequirement;
import org.fortiss.af3.task.model.annotation.RamRequirement;
import org.fortiss.af3.timing.model.annotation.TransmissionUnitBandwidth;
import org.fortiss.af3.timing.model.annotation.Wcet;
import org.fortiss.tooling.base.model.element.IAnnotatedSpecification;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.utils.AnnotationUtils;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class AF3SysMLToEMFMapping {
    public Map<IHierarchicElement, Package> lvPackageMap;
    public Map<IHierarchicElement, Class> lvClassMap = new HashMap<IHierarchicElement, Class>();
    public Map<IConnector, Port> lvPortMap;
    public Map<IHierarchicElement, Class> taClassMap;
    public Map<IHierarchicElement, Property> taPropertyMap;
    public Map<IConnector, Port> taPortMap;
    public Map<String, Class> itMap;
    public Map<IHierarchicElement, Package> paPackageMap;
    public Map<IHierarchicElement, Class> paClassMap;
    public Map<IConnector, Port> paPortMap;
    public Map<IConnector, Property> portPropertyMap;
    public Map<IHierarchicElement, Package> faPackageMap;
    public Map<IHierarchicElement, Class> faClassMap;
    public List<Abstraction> abstList;

    public AF3SysMLToEMFMapping(EList<IProjectRootElement> viewpoints) throws IOException, DiagnosticException {
        this.lvPackageMap = new HashMap<IHierarchicElement, Package>();
        this.lvPortMap = new HashMap<IConnector, Port>();
        this.itMap = new HashMap<String, Class>();
        this.taClassMap = new HashMap<IHierarchicElement, Class>();
        this.taPropertyMap = new HashMap<IHierarchicElement, Property>();
        this.taPortMap = new HashMap<IConnector, Port>();
        this.paPackageMap = new HashMap<IHierarchicElement, Package>();
        this.paClassMap = new HashMap<IHierarchicElement, Class>();
        this.paPortMap = new HashMap<IConnector, Port>();
        this.faPackageMap = new HashMap<IHierarchicElement, Package>();
        this.faClassMap = new HashMap<IHierarchicElement, Class>();
        this.abstList = new ArrayList<Abstraction>();
        this.portPropertyMap = new HashMap<IConnector, Property>();
        for (IProjectRootElement rootElement : viewpoints) {
            if (rootElement instanceof ComponentArchitecture) {
                Component topComponent = ((ComponentArchitecture)rootElement).getTopComponent();
                this.myCreateLogicalMaps(topComponent);
                continue;
            }
            if (rootElement instanceof DataDictionary) {
                this.myCreateDataTypeMapping((DataDictionary)rootElement);
                continue;
            }
            if (rootElement instanceof TaskArchitecture) {
                this.myCreateUMLTaskMaps((TaskArchitecture)rootElement);
                continue;
            }
            if (rootElement instanceof PlatformArchitecture) {
                this.myCreateUMLPlatformArchitectureMaps((IHierarchicElement)((PlatformArchitecture)rootElement));
                continue;
            }
            if (!(rootElement instanceof FunctionArchitecture)) continue;
            this.myCreateUMLFunctionArchitectureMaps((FunctionArchitecture)rootElement);
        }
    }

    private void myCreateDataTypeMapping(DataDictionary dd) {
        dd.getStructures().forEach(struc -> {
            Class newStruc = SysMLExportFactory.createUMLClass("dtStruc_" + struc.getName());
            this.itMap.put(struc.getName(), newStruc);
        });
        dd.getEnumerations().forEach(enu -> {
            Class newEnu = SysMLExportFactory.createUMLClass("dtEnum_" + enu.getName());
            this.itMap.put(enu.getName(), newEnu);
        });
        dd.getArrays().forEach(arr -> {
            Class newArr = SysMLExportFactory.createUMLClass("dtArra_" + arr.getName());
            this.itMap.put(arr.getName(), newArr);
        });
    }

    private void myCreateLogicalMaps(Component com) {
        for (Component subcomponent : com.getSubComponents()) {
            this.myCreateLogicalMaps(subcomponent);
        }
        if (com.getSubComponents().isEmpty()) {
            Class newClass = SysMLExportFactory.createUMLClass("lvClass_" + com.getName());
            this.addAnnotationsComponents(com, newClass);
            this.lvClassMap.put((IHierarchicElement)com, newClass);
        } else {
            Package newPackage = SysMLExportFactory.createUMLPackage("lvPack_" + com.getName());
            this.lvPackageMap.put((IHierarchicElement)com, newPackage);
            Class ibdClass = SysMLExportFactory.createUMLClass("lvClass_" + com.getName());
            this.addAnnotationsComponents(com, ibdClass);
            this.lvClassMap.put((IHierarchicElement)com, ibdClass);
        }
        EcoreUtils.pickInstanceOf(org.fortiss.af3.component.model.Port.class, (List)com.getConnectors()).forEach(con -> {
            Port newPort = SysMLExportFactory.createUMLPort("lvPort_" + con.getName());
            if (!con.getOutgoing().isEmpty()) {
                newPort.setIsConjugated(true);
            }
            this.lvPortMap.put((IConnector)con, newPort);
        });
    }

    private void addAnnotationsComponents(Component com, Class newClass) {
        this.addComment((INamedCommentedElement)com, newClass);
        this.addAnnotation((IModelElement)com, newClass, SafetyIntegrityLevel.class, "SafetyIntegrityLevel", Enumerator.class);
    }

    private void myCreateUMLTaskMaps(TaskArchitecture taskArchitecture) {
        taskArchitecture.getTasks().forEach(task -> {
            Class taskClass = SysMLExportFactory.createUMLClass("taClass_" + task.getName());
            this.taClassMap.put((IHierarchicElement)task, taskClass);
            this.addAnnotationsTasks((Task)task, taskClass);
            Property ownedAttributeElement = SysMLExportFactory.createUMLProperty("taAttr_" + task.getName(), true, true);
            this.taPropertyMap.put((IHierarchicElement)task, ownedAttributeElement);
            EcoreUtils.pickInstanceOf(TaskPort.class, (List)task.getConnectors()).forEach(con -> {
                Port newPort = SysMLExportFactory.createUMLPort("taPort_" + con.getName());
                MessageSize mSize = (MessageSize)AnnotationUtils.getAnnotation((IModelElement)con, MessageSize.class);
                if (mSize != null && (Integer)mSize.getValue() != 0) {
                    Property qu = newPort.createQualifier("MessageSizeBits", (Type)taskClass);
                    qu.setIntegerDefaultValue(((Integer)mSize.getValue()).intValue());
                    DataDictionaryUMLPackageFactory.setMemberType(qu, "string", this);
                }
                this.taPortMap.put((IConnector)con, newPort);
            });
        });
    }

    private void addAnnotationsTasks(Task task, Class taskClass) {
        this.addComment((INamedCommentedElement)task, taskClass);
        this.addAnnotation((IModelElement)task, taskClass, FlashRequirement.class, "FlashRequirement", Long.class);
        this.addAnnotation((IModelElement)task, taskClass, RamRequirement.class, "RamRequirement", Long.class);
        this.addAnnotation((IModelElement)task, taskClass, Wcet.class, "WCET", BigDecimal.class);
    }

    private void addAnnotation(IModelElement modelElement, Class taskClass, java.lang.Class<? extends IAnnotatedSpecification> anType, String anName, java.lang.Class<?> javaType) {
        if (!AnnotationUtils.hasAnnotation((IModelElement)modelElement, anType)) {
            return;
        }
        Object value = AnnotationUtils.getAnnotationValue((IModelElement)modelElement, anType, javaType);
        if (value == null) {
            return;
        }
        Property property = SysMLExportFactory.createUMLProperty(anName, false, false);
        ValueSpecification defaultValue = property.getDefaultValue();
        String valueStr = value.toString();
        if (Enumerator.class.isAssignableFrom(javaType) || PhysicalAccessType.class.isAssignableFrom(javaType)) {
            defaultValue = property.createDefaultValue(null, null, UMLPackage.Literals.LITERAL_STRING);
            ((LiteralString)defaultValue).setValue(String.valueOf(valueStr));
            DataDictionaryUMLPackageFactory.setMemberType(property, "string", this);
        } else if (Long.class.isAssignableFrom(javaType) || Integer.class.isAssignableFrom(javaType)) {
            defaultValue = property.createDefaultValue(null, null, UMLPackage.Literals.LITERAL_INTEGER);
            ((LiteralInteger)defaultValue).setValue(Integer.valueOf(valueStr).intValue());
            DataDictionaryUMLPackageFactory.setMemberType(property, "int", this);
        } else if (BigDecimal.class.isAssignableFrom(javaType) || Double.class.isAssignableFrom(javaType)) {
            defaultValue = property.createDefaultValue(null, null, UMLPackage.Literals.LITERAL_REAL);
            ((LiteralReal)defaultValue).setValue(Double.valueOf(valueStr).doubleValue());
            DataDictionaryUMLPackageFactory.setMemberType(property, "double", this);
        }
        taskClass.getOwnedAttributes().add((Object)property);
    }

    private void myCreateUMLPlatformArchitectureMaps(IHierarchicElement he) {
        for (IHierarchicElement heChild : he.getContainedElements()) {
            this.myCreateUMLPlatformArchitectureMaps(heChild);
        }
        Class newClass = SysMLExportFactory.createUMLClass("paClass_" + ((INamedCommentedElement)he).getName());
        this.addAnnotationsHardware((IModelElement)he, newClass);
        this.paClassMap.put(he, newClass);
        if (!he.getContainedElements().isEmpty()) {
            Package hePackage = SysMLExportFactory.createUMLPackage("paPack_" + ((INamedCommentedElement)he).getName());
            this.paPackageMap.put(he, hePackage);
        }
        EcoreUtils.pickInstanceOf(PlatformConnectorUnit.class, (List)he.getConnectors()).forEach(con -> {
            Port newPort = SysMLExportFactory.createUMLPort("paPort_" + con.getName());
            this.paPortMap.put((IConnector)con, newPort);
        });
    }

    private void addAnnotationsHardware(IModelElement he, Class heClass) {
        this.addComment((INamedCommentedElement)he, heClass);
        this.addAnnotation(he, heClass, FlashSize.class, "FlashSize", Long.class);
        this.addAnnotation(he, heClass, RamSize.class, "RamSize", Long.class);
        this.addAnnotation(he, heClass, Wcet.class, "Wcet", Long.class);
        this.addAnnotation(he, heClass, HardwareCost.class, "HWCost", Integer.class);
        this.addAnnotation(he, heClass, Weight.class, "Weight", Integer.class);
        this.addAnnotation(he, heClass, PhysicalAccess.class, "PhysicalAccess", PhysicalAccessType.class);
        this.addAnnotation(he, heClass, SafetyIntegrityLevel.class, "SafetyIntegrityLevel", Enumerator.class);
        this.addAnnotation(he, heClass, TransmissionUnitBandwidth.class, "TransmissionUnitBandwidth", Double.class);
        this.addAnnotation(he, heClass, TransmissionUnitPower.class, "TransmissionUnitPower", Double.class);
    }

    private void addComment(INamedCommentedElement ele, Class newClass) {
        if (ele.getComment() != null && ele.getComment() != "") {
            Comment functionComment = SysMLExportFactory.createUMLComment(ele.getComment());
            newClass.getOwnedComments().add((Object)functionComment);
        }
    }

    private void myCreateUMLFunctionArchitectureMaps(FunctionArchitecture funArch) {
        Class newClass = SysMLExportFactory.createUMLClass("funClass_" + funArch.getName());
        this.addComment((INamedCommentedElement)funArch, newClass);
        this.faClassMap.put((IHierarchicElement)funArch, newClass);
        if (!funArch.getContainedElements().isEmpty()) {
            Package funPackage = SysMLExportFactory.createUMLPackage("funPack_" + funArch.getName());
            this.faPackageMap.put((IHierarchicElement)funArch, funPackage);
        }
        for (Function funChild : funArch.getFunctions()) {
            this.myCreateUMLFunctionArchitectureHelper0(funChild);
        }
    }

    private void myCreateUMLFunctionArchitectureHelper0(Function fun) {
        for (Function funChild : fun.getSubFunctions()) {
            this.myCreateUMLFunctionArchitectureHelper0(funChild);
        }
        Class newClass = SysMLExportFactory.createUMLClass("funClass_" + fun.getName());
        this.addComment((INamedCommentedElement)fun, newClass);
        this.faClassMap.put((IHierarchicElement)fun, newClass);
        if (!fun.getSubFunctions().isEmpty()) {
            Package funPackage = SysMLExportFactory.createUMLPackage("funPack_" + fun.getName());
            this.faPackageMap.put((IHierarchicElement)fun, funPackage);
        }
    }
}

