/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.sysml.utils;

import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Realization;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.function.model.allocation.FunctionToComponentAllocationTable;
import org.fortiss.af3.platform.model.allocation.ComponentToExecutionUnitAllocationTable;
import org.fortiss.af3.sysml.AF3SysMLToEMFMapping;
import org.fortiss.af3.sysml.utils.SysMLExportFactory;
import org.fortiss.af3.task.model.allocation.ComponentToTaskAllocationTable;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationTable;
import org.fortiss.tooling.base.model.element.IHierarchicElement;

public class AllocationsUMLPackageFactory {
    private AF3SysMLToEMFMapping map;

    public AllocationsUMLPackageFactory(AF3SysMLToEMFMapping elementMap) {
        this.map = elementMap;
    }

    public void buildAllocations(AllocationTableCollection allocationCollection, Package taRoot) {
        if (allocationCollection != null) {
            this.buildRelations((IHierarchicElement)allocationCollection, taRoot);
        }
    }

    private void buildRelations(IHierarchicElement al, Package taRoot) {
        al.getContainedElements().forEach(table -> {
            if (table instanceof FunctionToComponentAllocationTable) {
                this.buildFunToComRelations((FunctionToComponentAllocationTable)table);
            } else if (table instanceof ComponentToTaskAllocationTable) {
                this.buildComToTaskRelations((ComponentToTaskAllocationTable)table);
            } else if (table instanceof TaskToExecutionUnitAllocationTable) {
                this.buildTaskToExeRelations((TaskToExecutionUnitAllocationTable)table, taRoot);
            } else if (table instanceof ComponentToExecutionUnitAllocationTable) {
                this.buildComToExeRelations((ComponentToExecutionUnitAllocationTable)table);
            }
        });
    }

    private void buildFunToComRelations(FunctionToComponentAllocationTable funTable) {
        funTable.getFunctions().forEach(fun -> funTable.getComponents(fun).forEach(com -> {
            Realization realization = SysMLExportFactory.createUMLRealization(this.map.faClassMap.get(fun).getName() + "_to_" + this.map.lvClassMap.get(com).getName(), this.map.faClassMap.get(fun), this.map.lvClassMap.get(com));
            this.map.faPackageMap.get(fun.getContainer()).getPackagedElements().add((Object)realization);
            this.map.abstList.add((Abstraction)realization);
        }));
    }

    private void buildComToTaskRelations(ComponentToTaskAllocationTable comTable) {
        comTable.getComponents().forEach(com -> comTable.getTasks(com).forEach(task -> {
            com.getInputPorts().forEach(inputLV -> comTable.getTaskInputPorts(inputLV).forEach(portTa -> {
                Abstraction abstraction = SysMLExportFactory.createUMLAbstraction(inputLV.getName() + "_to_" + portTa.getName(), (NamedElement)this.map.portPropertyMap.get(inputLV), (NamedElement)this.map.portPropertyMap.get(portTa));
                this.map.lvPackageMap.get(com.getParentComponent()).getPackagedElements().add((Object)abstraction);
                this.map.abstList.add(abstraction);
            }));
            com.getOutputPorts().forEach(outputLV -> comTable.getTaskOutputPorts(outputLV).forEach(portTa -> {
                Abstraction abstraction = SysMLExportFactory.createUMLAbstraction(outputLV.getName() + "_to_" + portTa.getName(), (NamedElement)this.map.portPropertyMap.get(outputLV), (NamedElement)this.map.portPropertyMap.get(portTa));
                this.map.lvPackageMap.get(com.getParentComponent()).getPackagedElements().add((Object)abstraction);
                this.map.abstList.add(abstraction);
            }));
            Abstraction abstraction = SysMLExportFactory.createUMLAbstraction(this.map.lvClassMap.get(com).getName() + "_to_" + this.map.taClassMap.get(task).getName(), (NamedElement)this.map.lvClassMap.get(com), (NamedElement)this.map.taClassMap.get(task));
            this.map.lvPackageMap.get(com.getParentComponent()).getPackagedElements().add((Object)abstraction);
            this.map.abstList.add(abstraction);
        }));
    }

    private void buildTaskToExeRelations(TaskToExecutionUnitAllocationTable taskTable, Package taRoot) {
        taskTable.getTasks().forEach(task -> {
            Abstraction abstraction = SysMLExportFactory.createUMLAbstraction(this.map.taClassMap.get(task).getName() + "_to_" + this.map.paClassMap.get(taskTable.getExecutionUnit(task)).getName(), (NamedElement)this.map.taClassMap.get(task), (NamedElement)this.map.paClassMap.get(taskTable.getExecutionUnit(task)));
            taRoot.getPackagedElements().add((Object)abstraction);
            this.map.abstList.add(abstraction);
        });
    }

    private void buildComToExeRelations(ComponentToExecutionUnitAllocationTable comTable) {
        comTable.getComponents().forEach(com -> {
            Abstraction abstraction = SysMLExportFactory.createUMLAbstraction(this.map.lvClassMap.get(com).getName() + "_to_" + this.map.paClassMap.get(comTable.getExecutionUnit(com)).getName(), (NamedElement)this.map.lvClassMap.get(com), (NamedElement)this.map.paClassMap.get(comTable.getExecutionUnit(com)));
            this.map.lvPackageMap.get(com.getParentComponent()).getPackagedElements().add((Object)abstraction);
            this.map.abstList.add(abstraction);
        });
    }
}

