/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.sysml.utils;

import java.io.IOException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.definitions.EnumerationMember;
import org.fortiss.af3.expression.model.definitions.StructureMember;
import org.fortiss.af3.sysml.AF3SysMLActivator;
import org.fortiss.af3.sysml.AF3SysMLToEMFMapping;
import org.fortiss.af3.sysml.SysMLLibrarySerializer;
import org.fortiss.af3.sysml.utils.SysMLExportFactory;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.osgi.framework.Bundle;

public class DataDictionaryUMLPackageFactory {
    private AF3SysMLToEMFMapping map;
    private static Package sysmlStdLib;

    static {
        SysMLLibrarySerializer serializer = new SysMLLibrarySerializer(){

            protected URI createLoadURI(String pathName) {
                Bundle bundle = Platform.getBundle((String)"org.eclipse.papyrus.sysml16");
                return this.createBundleURI(pathName, bundle);
            }
        };
        try {
            sysmlStdLib = (Package)serializer.load("resources/library/SysML-Standard-Library.uml");
        }
        catch (IOException | DiagnosticException e) {
            LoggingUtils.error((Plugin)AF3SysMLActivator.getDefault(), (String)"Failed to load SysML standard library.", (Throwable)e);
        }
    }

    public DataDictionaryUMLPackageFactory(AF3SysMLToEMFMapping mapping) {
        this.map = mapping;
    }

    public Package createDataDictionaryUMLPackage(DataDictionary dataDict) {
        if (dataDict == null) {
            return SysMLExportFactory.createUMLPackage("No Data Dictionary selected");
        }
        Package itRoot = dataDict.getName() == null ? SysMLExportFactory.createUMLPackage("Data Dictionary") : SysMLExportFactory.createUMLPackage(dataDict.getName());
        dataDict.getStructures().forEach(struc -> {
            for (StructureMember mem : struc.getMembers()) {
                Property newStrucProp = SysMLExportFactory.createUMLProperty(mem.getName(), false, true);
                DataDictionaryUMLPackageFactory.setMemberType(newStrucProp, mem.getType().toString(), this.map);
                this.map.itMap.get(struc.getName()).getOwnedAttributes().add((Object)newStrucProp);
            }
        });
        dataDict.getEnumerations().forEach(enu -> {
            for (EnumerationMember mem : enu.getMembers()) {
                Property newStrucProp = SysMLExportFactory.createUMLProperty(mem.getName(), false, true);
                this.map.itMap.get(enu.getName()).getOwnedAttributes().add((Object)newStrucProp);
            }
        });
        dataDict.getArrays().forEach(arr -> {
            this.map.itMap.get(arr.getType().toString());
            Property newStrucProp = SysMLExportFactory.createUMLProperty(arr.getName(), false, true);
            DataDictionaryUMLPackageFactory.setMemberType(newStrucProp, arr.getType().toString(), this.map);
            this.map.itMap.get(arr.getName()).getOwnedAttributes().add((Object)newStrucProp);
        });
        this.map.itMap.forEach((k, v) -> itRoot.getPackagedElements().add(v));
        return itRoot;
    }

    public static void setMemberType(Property newStrucProp, String typeString, AF3SysMLToEMFMapping map) {
        EList sysMLDataTypes = ((PackageableElement)sysmlStdLib.getPackagedElements().get(1)).getOwnedElements();
        switch (typeString) {
            case "boolean": {
                newStrucProp.setType((Type)((DataType)sysMLDataTypes.get(0)));
                break;
            }
            case "complex": {
                newStrucProp.setType((Type)((DataType)sysMLDataTypes.get(1)));
                break;
            }
            case "int": {
                newStrucProp.setType((Type)((DataType)sysMLDataTypes.get(2)));
                break;
            }
            case "number": {
                newStrucProp.setType((Type)((DataType)sysMLDataTypes.get(3)));
                break;
            }
            case "double": {
                newStrucProp.setType((Type)((DataType)sysMLDataTypes.get(4)));
                break;
            }
            case "string": {
                newStrucProp.setType((Type)((DataType)sysMLDataTypes.get(5)));
                break;
            }
            default: {
                if (map.itMap.get(typeString) != null) {
                    newStrucProp.setType((Type)map.itMap.get(typeString));
                    break;
                }
                throw new TypeNotPresentException("We do not recognize the type from AF3: " + typeString, null);
            }
        }
    }
}

