/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.sysml.utils;

import java.util.List;
import java.util.Map;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.VisibilityKind;
import org.fortiss.af3.component.model.PortSpecification;
import org.fortiss.af3.sysml.AF3SysMLToEMFMapping;
import org.fortiss.af3.sysml.utils.DataDictionaryUMLPackageFactory;
import org.fortiss.af3.sysml.utils.SysMLExportFactory;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class HierarchicViewPointTranslationUtil {
    private AF3SysMLToEMFMapping map;

    public HierarchicViewPointTranslationUtil(AF3SysMLToEMFMapping elementMap) {
        this.map = elementMap;
    }

    public void createElements(IHierarchicElement hierElem, Package owner, Map<IHierarchicElement, Package> packMap, Map<IHierarchicElement, Class> classMap, Map<IConnector, Port> portMap) {
        if (!hierElem.getContainedElements().isEmpty()) {
            Package elePackage = packMap.get(hierElem);
            Class ibdClass = classMap.get(hierElem);
            hierElem.getContainedElements().forEach(subEle -> {
                this.createElements((IHierarchicElement)subEle, elePackage, packMap, classMap, portMap);
                this.createPropertiesForIBDChildren(classMap, portMap, ibdClass, (IHierarchicElement)subEle);
            });
            owner.getPackagedElements().add((Object)elePackage);
            owner.getPackagedElements().add((Object)ibdClass);
        } else {
            Class leafClass = classMap.get(hierElem);
            owner.getPackagedElements().add((Object)leafClass);
        }
    }

    private void createPropertiesForIBDChildren(Map<IHierarchicElement, Class> classMap, Map<IConnector, Port> portMap, Class ibdClass, IHierarchicElement subEle) {
        if (classMap.get(subEle) != null) {
            Class classXMIId = classMap.get(subEle);
            Property ownedAttribute = SysMLExportFactory.createUMLProperty(classXMIId.getName().toLowerCase(), true, true);
            for (IConnector af3Port : subEle.getConnectors()) {
                Property portQuali = ownedAttribute.createQualifier(portMap.get(af3Port).getName(), (Type)ibdClass);
                portQuali.setAggregation(AggregationKind.COMPOSITE_LITERAL);
                PortSpecification ps = (PortSpecification)EcoreUtils.pickFirstInstanceOf(PortSpecification.class, (List)af3Port.getSpecifications());
                if (ps != null) {
                    DataDictionaryUMLPackageFactory.setMemberType(portQuali, ps.getType().toString(), this.map);
                }
                this.map.portPropertyMap.put(af3Port, portQuali);
            }
            ownedAttribute.setType((Type)classXMIId);
            ibdClass.getOwnedAttributes().add((Object)ownedAttribute);
        }
    }

    public void buildPorts(Map<IHierarchicElement, Class> classMap, Map<IConnector, Port> portMap) {
        portMap.forEach((af3Port, port) -> ((Class)classMap.get(af3Port.getOwner())).getOwnedPorts().add(port));
    }

    public void buildConnectors(Map<IHierarchicElement, Class> classMap, Map<IConnector, Port> portMap) {
        classMap.forEach((he, v) -> he.getConnections().forEach(con -> {
            Connector newCon = SysMLExportFactory.createUMLConnector();
            newCon.setVisibility(VisibilityKind.PUBLIC_LITERAL);
            String source = "";
            if (con.getSource() != null) {
                INamedCommentedElement sourceOwner = (INamedCommentedElement)con.getSource().getOwner();
                source = this.buildConnectorEnd((IHierarchicElement)he, (IConnection)con, newCon, sourceOwner, classMap, portMap, true);
            }
            String target = "";
            if (con.getTarget() != null) {
                INamedCommentedElement targetOwner = (INamedCommentedElement)con.getTarget().getOwner();
                target = this.buildConnectorEnd((IHierarchicElement)he, (IConnection)con, newCon, targetOwner, classMap, portMap, false);
            }
            newCon.setName(source + "_to_" + target);
        }));
    }

    private String buildConnectorEnd(IHierarchicElement he, IConnection con, Connector newCon, INamedCommentedElement owner, Map<IHierarchicElement, Class> classMap, Map<IConnector, Port> portMap, boolean isSource) {
        String source = owner.getName();
        classMap.get(he).getOwnedAttributes().forEach(x -> {
            if (x.getType() == classMap.get((IHierarchicElement)owner)) {
                HierarchicViewPointTranslationUtil.buildConnectorEndHelper((Class)classMap.get(he), con, newCon, x, portMap, isSource);
            }
        });
        return source;
    }

    public static void buildConnectorEndHelper(Class ibdClass, IConnection con, Connector newCon, Property prop, Map<IConnector, Port> portMap, Boolean source) {
        ConnectorEnd newConEnd = SysMLExportFactory.createUMLConnectorEnd(prop);
        Port port = source != false ? portMap.get(con.getSource()) : portMap.get(con.getTarget());
        prop.getQualifiers().forEach(quali -> {
            if (quali.getName() == port.getName()) {
                newConEnd.setRole((ConnectableElement)quali);
            }
        });
        newConEnd.setRole((ConnectableElement)port);
        newCon.getEnds().add((Object)newConEnd);
        ibdClass.getOwnedConnectors().add((Object)newCon);
    }
}

