/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.sysml.utils;

import java.io.IOException;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.fortiss.af3.sysml.AF3SysMLToEMFMapping;
import org.fortiss.af3.sysml.utils.HierarchicViewPointTranslationUtil;
import org.fortiss.af3.sysml.utils.SysMLExportFactory;
import org.fortiss.af3.task.model.Signal;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskArchitecture;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;

public class TaskArchitectureUMLPackageFactory {
    private AF3SysMLToEMFMapping map;

    public TaskArchitectureUMLPackageFactory(AF3SysMLToEMFMapping mapping) throws IOException, DiagnosticException {
        this.map = mapping;
    }

    public Package createTaskArchitecturePackage(TaskArchitecture taskArch) {
        if (taskArch == null) {
            return SysMLExportFactory.createUMLPackage("No Task Architecture selected");
        }
        Package taRoot = SysMLExportFactory.createUMLPackage(taskArch.getName());
        taRoot.setName(taskArch.getName());
        Class taRootClass = SysMLExportFactory.createUMLClass(taskArch.getName() + "_ibdClass");
        taRoot.getPackagedElements().add((Object)taRootClass);
        this.buildElements(taRootClass, taRoot, taskArch);
        this.buildConnectors((EList<Signal>)taskArch.getSignals(), taRootClass);
        return taRoot;
    }

    private void buildElements(Class taRootClass, Package taRoot, TaskArchitecture taskArch) {
        this.map.taClassMap.forEach((key, value) -> {
            taRoot.getPackagedElements().add(value);
            ((Task)key).getTaskPorts().forEach(tP -> {
                value.getOwnedPorts().add((Object)this.map.taPortMap.get(tP));
                Property portQuali = this.map.taPropertyMap.get(key).createQualifier(this.map.taPortMap.get(tP).getName(), (Type)taRootClass);
                portQuali.setAggregation(AggregationKind.COMPOSITE_LITERAL);
                this.map.portPropertyMap.put((IConnector)tP, portQuali);
                taRootClass.getOwnedAttributes().add((Object)this.map.taPropertyMap.get(key));
            });
        });
        this.map.taClassMap.put((IHierarchicElement)taskArch, taRootClass);
    }

    private void buildConnectors(EList<Signal> signals, Class taRoot) {
        for (Signal signal : signals) {
            Connector newCon = SysMLExportFactory.createUMLConnector();
            INamedCommentedElement sourceOwner = (INamedCommentedElement)signal.getSource().getOwner();
            String source = sourceOwner.getName();
            INamedCommentedElement targetOwner = (INamedCommentedElement)signal.getTarget().getOwner();
            String target = targetOwner.getName();
            newCon.setName(source + "_to_" + target);
            Property sourceEleProp = this.map.taPropertyMap.get(signal.getSource().getOwner());
            Property targetEleProp = this.map.taPropertyMap.get(signal.getTarget().getOwner());
            HierarchicViewPointTranslationUtil.buildConnectorEndHelper(taRoot, (IConnection)signal, newCon, sourceEleProp, this.map.taPortMap, true);
            HierarchicViewPointTranslationUtil.buildConnectorEndHelper(taRoot, (IConnection)signal, newCon, targetEleProp, this.map.taPortMap, false);
        }
    }
}

