/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.sysml.utils.tools;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Realization;
import org.fortiss.af3.sysml.AF3SysMLToEMFMapping;
import org.fortiss.af3.sysml.utils.tools.ISysMLSyntaxTransformer;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;

public class EnterpriseArchitectTransformer
implements ISysMLSyntaxTransformer {
    private Model umlModel;
    private AF3SysMLToEMFMapping mapping;
    private String fileString;

    public EnterpriseArchitectTransformer(Model umlModel, AF3SysMLToEMFMapping mapping, String fileString) {
        this.umlModel = umlModel;
        this.mapping = mapping;
        this.fileString = fileString;
    }

    @Override
    public String transform() {
        this.fileString = this.changeToEADataTypes(this.fileString);
        this.fileString = this.syntaxChangesForEA(this.fileString);
        this.fileString = this.changeFlowPortBasePortIDEA(this.mapping.lvPortMap);
        this.fileString = this.changeFlowPortBasePortIDEA(this.mapping.paPortMap);
        this.fileString = this.changeFlowPortBasePortIDEA(this.mapping.taPortMap);
        this.fileString = this.addEAExtension(this.fileString);
        this.fileString = this.addBlockStereotypeEAExtensions(this.fileString, this.mapping.lvClassMap);
        this.fileString = this.addBlockStereotypeEAExtensions(this.fileString, this.mapping.paClassMap);
        this.fileString = this.addBlockStereotypeEAExtensions(this.fileString, this.mapping.taClassMap);
        this.fileString = this.addBlockStereotypeEAExtensions(this.fileString, this.mapping.faClassMap);
        this.fileString = this.addFlowPortStereotypeEAExtension(this.fileString);
        this.fileString = this.addAllocationConnectorEAExtension(this.fileString, this.mapping.abstList);
        return this.fileString;
    }

    private String changeToEADataTypes(String fileString) {
        fileString = ISysMLSyntaxTransformer.addSysMLSyntaxAdaptions(fileString, "<type xmi:type=\"uml:DataType\" href=(.*)_Boolean\"/>", "<type xmi:idref=\"EAJava_boolean\" />");
        fileString = ISysMLSyntaxTransformer.addSysMLSyntaxAdaptions(fileString, "<type xmi:type=\"uml:DataType\" href=(.*)_Integer\"/>", "<type xmi:idref=\"EAJava_Integer\" />");
        fileString = ISysMLSyntaxTransformer.addSysMLSyntaxAdaptions(fileString, "<type xmi:type=\"uml:DataType\" href=(.*)_Real\"/>", "<type xmi:idref=\"EAJava_double\" />");
        fileString = ISysMLSyntaxTransformer.addSysMLSyntaxAdaptions(fileString, "<type xmi:type=\"uml:DataType\" href=(.*)_String\"/>", "<type xmi:idref=\"EAJava_Char\" />");
        fileString = ISysMLSyntaxTransformer.addSysMLSyntaxAdaptions(fileString, "<type xmi:type=\"uml:DataType\" href=(.*)_Complex\"/>", "<type xmi:idref=\"EAJava_byte\" />");
        return fileString;
    }

    private String syntaxChangesForEA(String fileString) {
        String newHeader = "<xmi:XMI xmi:version=\"2.1\" xmlns:xmi=\"http://schema.omg.org/spec/XMI/2.1\" xmlns:uml=\"http://schema.omg.org/spec/UML/5.0.0\" xmlns:SysML=\"http://www.omg.org/spec/SysML/20161101/SysML\" xmlns:sysml=\"http://www.omg.org/spec/SysML/20080501/SysML-profile\">\n <xmi:Documentation exporter=\"Enterprise Architect\" exporterVersion=\"6.5\" exporterID=\"1560\"/>";
        fileString = fileString.replaceAll("<xmi:XMI xmi:version=\"20131001\".*>", newHeader);
        fileString = fileString.replace("Blocks:Block", "sysml:block");
        fileString = fileString.replace("DeprecatedElements", "SysML");
        fileString = fileString.replace("Allocations:", "SysML:");
        fileString = fileString.replace("Blocks:ValueType", "SysML:ValueType");
        fileString = fileString.replace("Blocks:NestedConnectorEnd", "SysML:NestedConnectorEnd");
        return fileString;
    }

    private String changeFlowPortBasePortIDEA(Map<IConnector, Port> portMap) {
        ArrayList<IConnector> connectors = new ArrayList<IConnector>(this.mapping.portPropertyMap.keySet());
        for (IConnector con : connectors) {
            String xmiIDPort = ((XMLResource)this.umlModel.eResource()).getID((EObject)portMap.get(con));
            String xmiIDProperty = ((XMLResource)this.umlModel.eResource()).getID((EObject)this.mapping.portPropertyMap.get(con));
            this.fileString = this.fileString.replace("base_Port=\"" + xmiIDPort, "base_Port=\"" + xmiIDProperty);
        }
        return this.fileString;
    }

    private String addEAExtension(String fileString) {
        fileString = fileString.replaceAll("</xmi:XMI>", "<xmi:Extension extender=\"Enterprise Architect\" extenderID=\"6.5\">\n\t<elements>\n\t</elements>\n\t<connectors>  </connectors>\n</xmi:Extension>\n</xmi:XMI>");
        return fileString;
    }

    private String addBlockStereotypeEAExtensions(String fileString, Map<IHierarchicElement, Class> classMap) {
        ArrayList<CallSite> elementsCollected = new ArrayList<CallSite>();
        ArrayList<Class> classes = new ArrayList<Class>(classMap.values());
        for (Class clas : classes) {
            String xmiId = ((XMLResource)this.umlModel.eResource()).getID((EObject)clas);
            elementsCollected.add((CallSite)((Object)("\n\t\t<element xmi:idref=\"" + xmiId + "\" xmi:type=\"uml:Class\" name=\"" + clas.getName() + "\" scope=\"public\">\n\t\t\t<properties isSpecification=\"false\" sType=\"Class\" nType=\"0\" scope=\"public\" stereotype=\"block\" isRoot=\"false\" isLeaf=\"false\" isAbstract=\"false\" isActive=\"false\"/>\n\t\t</element>")));
        }
        fileString = fileString.replaceAll("<elements>", "<elements>" + String.join((CharSequence)"", elementsCollected));
        return fileString;
    }

    private String addFlowPortStereotypeEAExtension(String fileString) {
        ArrayList<CallSite> elementsCollected = new ArrayList<CallSite>();
        ArrayList<Property> properties = new ArrayList<Property>(this.mapping.portPropertyMap.values());
        for (Property prop : properties) {
            String xmiId = ((XMLResource)this.umlModel.eResource()).getID((EObject)prop);
            elementsCollected.add((CallSite)((Object)("\n\t\t<element xmi:idref=\"" + xmiId + "\" xmi:type=\"uml:Port\" name=\"" + prop.getName() + "\" scope=\"public\">\n\t\t\t<properties isSpecification=\"false\" sType=\"Port\" nType=\"0\" scope=\"public\" stereotype=\"FlowPort\" isRoot=\"false\" isLeaf=\"false\" isAbstract=\"false\"/>\n\t\t</element>")));
        }
        fileString = fileString.replace("<elements>", "<elements>" + String.join((CharSequence)"", elementsCollected));
        fileString = fileString.replaceAll("<ownedAttribute xmi:type=\"uml:Port\" .* aggregation=\"composite\"/>", "");
        fileString = fileString.replaceAll("<SysML:FlowPort xmi:id=\".*\" base_Port=\"null\"/>", "");
        fileString = fileString.replaceAll("<ownedAttribute xmi:type=\"uml:Port\" .* aggregation=\"composite\".*/>", "");
        return fileString;
    }

    private String addAllocationConnectorEAExtension(String fileString, List<Abstraction> abstList) {
        ArrayList<CallSite> connectorsCollected = new ArrayList<CallSite>();
        for (Abstraction abstraction : abstList) {
            String stereoType;
            String abstEaType;
            String xmiIdAbst = ((XMLResource)this.umlModel.eResource()).getID((EObject)abstraction);
            String xmiIDSource = ((XMLResource)this.umlModel.eResource()).getID((EObject)abstraction.getSources().get(0));
            String xmiIDTarget = ((XMLResource)this.umlModel.eResource()).getID((EObject)abstraction.getTargets().get(0));
            if (abstraction instanceof Realization) {
                abstEaType = "Realisation";
                stereoType = "realize";
            } else {
                abstEaType = "abstraction";
                stereoType = "allocate";
            }
            connectorsCollected.add((CallSite)((Object)("\n\t\t<connector xmi:idref=\"" + xmiIdAbst + "\">\n\t\t\t<source xmi:idref =\"" + xmiIDSource + "\"/>\n \t\t\t<target xmi:idref =\"" + xmiIDTarget + "\"/>\n\t\t\t<properties ea_type=\"" + abstEaType + "\" stereotype=\"" + stereoType + "\" direction=\"Source -&gt; Destination\"/>\n \t\t</connector>\n")));
        }
        fileString = fileString.replace("<connectors>", "<connectors>" + String.join((CharSequence)"", connectorsCollected));
        return fileString;
    }
}

