/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.smt.backend;

import com.google.common.collect.Sets;
import com.microsoft.z3.Expr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.dseml.model.expression.Set;
import org.fortiss.af3.exploration.dseml.model.function.Maximize;
import org.fortiss.af3.exploration.dseml.model.function.Minimize;
import org.fortiss.af3.exploration.model.ExplorationSpecification;
import org.fortiss.af3.exploration.model.IExplorationConstraint;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.SolverSettings;
import org.fortiss.af3.exploration.model.solutions.ExplorationSolution;
import org.fortiss.af3.exploration.model.synthesiscategory.IDeploymentSynthesis;
import org.fortiss.af3.exploration.model.synthesiscategory.IScheduleSynthesis;
import org.fortiss.af3.exploration.model.synthesiscategory.ISynthesisCategory;
import org.fortiss.af3.exploration.service.IDSEBackend;
import org.fortiss.af3.exploration.smt.modeltransformation.ConstraintTransformationAdapter;
import org.fortiss.af3.exploration.smt.modeltransformation.DSMLTransformationService;
import org.fortiss.af3.exploration.smt.modeltransformation.DefaultExpressionTransformator;
import org.fortiss.af3.exploration.smt.modeltransformation.ExpressionTransformator;
import org.fortiss.af3.exploration.smt.modeltransformation.NonQuantifiedExpressionTransformator;
import org.fortiss.af3.exploration.smt.modeltransformation.QuantifiedExpressionTransformator;
import org.fortiss.af3.exploration.smt.solver.ContextWrapper;
import org.fortiss.af3.exploration.smt.solver.DeploScheduleRun;
import org.fortiss.af3.exploration.smt.solver.DeploymentRun;
import org.fortiss.af3.exploration.smt.solver.ScheduleRun;
import org.fortiss.af3.exploration.smt.solver.SolverRun;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.exploration.util.ExplorationUtils;
import org.fortiss.tooling.base.model.element.IModelElement;

public class Z3Backend
implements IDSEBackend {
    private static int DEFAULT_TIMEOUT_S = 1800;

    public void validateExplorationSpecification(ExplorationSpecification spec) throws Exception {
        this.checkForDuplicateObjectives(spec);
    }

    private void checkForDuplicateObjectives(ExplorationSpecification specification) throws Exception {
        ContextWrapper contextWrapper = new ContextWrapper(DEFAULT_TIMEOUT_S, false);
        DSMLTransformationService transformationService = new DSMLTransformationService(specification.getSearchSpace(), contextWrapper);
        ArrayList<Class<? extends ExpressionTransformator>> transformationClasses = new ArrayList<Class<? extends ExpressionTransformator>>();
        transformationClasses.add(DefaultExpressionTransformator.class);
        transformationClasses.add(QuantifiedExpressionTransformator.class);
        transformationClasses.add(NonQuantifiedExpressionTransformator.class);
        ConstraintTransformationAdapter transformationAdapter = new ConstraintTransformationAdapter(contextWrapper, transformationService, transformationClasses);
        HashSet<String> uniqueExpressions = new HashSet<String>();
        for (IExplorationTarget target : specification.getTargets()) {
            Expr targetExpression;
            if (target instanceof IExplorationConstraint) continue;
            if (target.getExpression() instanceof Minimize) {
                targetExpression = transformationAdapter.transform((IExpression)((Minimize)target.getExpression()).getArgs(), new HashMap<Set<IModelElement>, IModelElement>());
            } else if (target.getExpression() instanceof Maximize) {
                targetExpression = transformationAdapter.transform((IExpression)((Maximize)target.getExpression()).getArgs(), new HashMap<Set<IModelElement>, IModelElement>());
            } else {
                throw new UnsupportedOperationException("The function " + target.getExpression().getClass().getSimpleName() + " is not yet supported");
            }
            String targetString = targetExpression.toString();
            if (uniqueExpressions.contains(targetString)) {
                throw new IllegalArgumentException("The DSE specification contains duplicate objectives.");
            }
            uniqueExpressions.add(targetString);
        }
    }

    public Map<Class<? extends ISynthesisCategory>, String> getSynthesisTypes() {
        HashMap<Class<? extends ISynthesisCategory>, String> catMap = new HashMap<Class<? extends ISynthesisCategory>, String>();
        catMap.put(IDeploymentSynthesis.class, "Deployment");
        catMap.put(IScheduleSynthesis.class, "Schedule");
        return catMap;
    }

    public java.util.Set<IDSEBackend.EXPLORATION_TYPE> getExplorationTypes() {
        return Sets.newHashSet((Object[])new IDSEBackend.EXPLORATION_TYPE[]{IDSEBackend.EXPLORATION_TYPE.FEASIBILITY_CHECK, IDSEBackend.EXPLORATION_TYPE.OPTIMIZATION});
    }

    public SolverSettings getSolverSettings() {
        return ExplorationModelElementFactory.createSolverSettings((int)DEFAULT_TIMEOUT_S, (int)0);
    }

    public Optional<ExplorationSolution> executeDSE(ExplorationSpecification spec, SolverSettings settings, IProgressMonitor monitor) throws Exception {
        int timeout_s = (Integer)settings.getTermination().getTimeoutS().getValue();
        SolverRun solverRun = this.createSolverRun(spec, timeout_s);
        if (ExplorationUtils.isDebugVerboseEnabled()) {
            int i = 1;
            System.out.println("*** List of constraints ***");
            for (IExplorationTarget et : spec.getTargets()) {
                System.out.println(" ExplorationTarget " + i + " : " + String.valueOf(et));
                System.out.println(et.getExpression());
                ++i;
            }
        }
        return solverRun.solve(monitor);
    }

    public SolverRun createSolverRun(ExplorationSpecification spec, int timeout_s) throws Exception {
        EList synthTypes = spec.getSynthTypes();
        if (synthTypes.contains(IDeploymentSynthesis.class) && synthTypes.contains(IScheduleSynthesis.class)) {
            return new DeploScheduleRun(spec, timeout_s);
        }
        if (synthTypes.contains(IDeploymentSynthesis.class)) {
            return new DeploymentRun(spec, timeout_s);
        }
        if (synthTypes.contains(IScheduleSynthesis.class)) {
            return new ScheduleRun(spec, timeout_s);
        }
        throw new Exception("No applicable " + SolverRun.class.getSimpleName() + " was found for the given set of syntheses to perform.");
    }

    public String getName() {
        return "Z3 (SMT)";
    }
}

