/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.smt.cli;

import com.microsoft.z3.Solver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.exploration.AF3ExplorationActivator;
import org.fortiss.af3.exploration.model.ExplorationSpecification;
import org.fortiss.af3.exploration.model.IExplorationObjective;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.SolverSettings;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.project.ProcessStep;
import org.fortiss.af3.exploration.model.project.RuleSet;
import org.fortiss.af3.exploration.service.IDSEBackend;
import org.fortiss.af3.exploration.service.IDSEBackendService;
import org.fortiss.af3.exploration.smt.AF3ExplorationSMTActivator;
import org.fortiss.af3.exploration.smt.backend.Z3Backend;
import org.fortiss.af3.exploration.smt.modeltransformation.DSMLtoSMTTransformator;
import org.fortiss.af3.exploration.smt.solver.ContextWrapper;
import org.fortiss.af3.exploration.smt.solver.SolverRun;
import org.fortiss.af3.exploration.util.ExplorationCLIUtils;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.extension.ICommandLineSwitchHandler;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public final class DumpSMTLibFileCommandLineHandler
implements ICommandLineSwitchHandler {
    private final IDSEBackendService dseService = IDSEBackendService.getInstance();

    public boolean hasAdditionalArgument() {
        return true;
    }

    public void handleCLISwitch(String argument) {
        SolverRun solverRun;
        DSE matchingDSE = ExplorationCLIUtils.findMatchingDSEProject((String)argument);
        if (matchingDSE == null) {
            return;
        }
        Set solutionType = ExplorationCLIUtils.getExplorationTypeByArgument((String)argument);
        if (solutionType.isEmpty()) {
            return;
        }
        Optional optBackend = LambdaUtils.getFirst((Collection)this.dseService.findBySynthTypeAndName((Collection)solutionType, IDSEBackend.EXPLORATION_TYPE.FEASIBILITY_CHECK, "Z3 (SMT)"));
        if (!optBackend.isPresent()) {
            LoggingUtils.error((Plugin)AF3ExplorationActivator.getDefault(), (String)"Could not find the Z3 backend to perform the exploration.");
            return;
        }
        Z3Backend z3Backend = (Z3Backend)optBackend.get();
        HashMap<Z3Backend, SolverSettings> settings = new HashMap<Z3Backend, SolverSettings>();
        settings.put(z3Backend, z3Backend.getSolverSettings());
        ExplorationSpecification expSpec = this.constructExplorationSpecification(matchingDSE);
        expSpec.getSynthTypes().addAll((Collection)solutionType);
        int timeoutMS = 1000;
        try {
            solverRun = z3Backend.createSolverRun(expSpec, 1000);
        }
        catch (Exception e) {
            LoggingUtils.error((Plugin)AF3ExplorationActivator.getDefault(), (String)"Could not create a solver run instance for the given synthesis type.", (Throwable)e);
            return;
        }
        int numExplorationObjectives = EcoreUtils.pickInstanceOf(IExplorationObjective.class, (List)expSpec.getTargets()).size();
        if (numExplorationObjectives > 0) {
            LoggingUtils.info((Plugin)AF3ExplorationSMTActivator.getDefault(), (String)"Optimization statements will not be dumped. This switch is only inteded to check feasibility of an optimization problem. For debugging optimization problems, set the environment varaible DSE_DEBUG_VERBOSE to \"true\".");
        }
        Throwable throwable = null;
        Object var12_14 = null;
        try (ContextWrapper context = new ContextWrapper(1000, false);){
            DSMLtoSMTTransformator transformator = new DSMLtoSMTTransformator(context, expSpec);
            Solver solver = solverRun.createConstraintSolver(transformator);
            String smtLibStr = "(set-logic ALL)\n" + solver.toString() + "(check-sat)\n";
            String af3PrjName = ((FileProject)EcoreUtils.getFirstParentWithType((EObject)matchingDSE, FileProject.class)).getName();
            solverRun.dumpSMTLibFile(smtLibStr, af3PrjName);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private ExplorationSpecification constructExplorationSpecification(DSE matchingDSE) {
        ExplorationSpecification expSpec = ExplorationModelElementFactory.createExplorationSpecification();
        ProcessStep dseStep = matchingDSE.getCurrentStep();
        expSpec.getTargets().addAll(DumpSMTLibFileCommandLineHandler.getTargetsFromRuleSets(matchingDSE));
        expSpec.setSearchSpace(dseStep.getSuperSetMap());
        return expSpec;
    }

    private static Collection<IExplorationTarget<?>> getTargetsFromRuleSets(DSE dse) {
        ArrayList allExplorationTargets = new ArrayList();
        ProcessStep dseStep = dse.getCurrentStep();
        for (RuleSet ruleSet : dseStep.getRuleSets()) {
            allExplorationTargets.addAll((Collection<IExplorationTarget<?>>)ruleSet.getExplorationTargets());
        }
        return allExplorationTargets;
    }
}

