/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.smt.modeltransformation;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.exploration.dseml.model.arithmetic.ArithmeticLiteral;
import org.fortiss.af3.exploration.dseml.model.arithmetic.ArithmeticPropertyLiteral;
import org.fortiss.af3.exploration.dseml.model.arithmetic.IArithmeticExpression;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Plus;
import org.fortiss.af3.exploration.dseml.model.booleanp.And;
import org.fortiss.af3.exploration.dseml.model.booleanp.ForAll;
import org.fortiss.af3.exploration.dseml.model.booleanp.IBooleanExpression;
import org.fortiss.af3.exploration.dseml.model.booleanp.Implies;
import org.fortiss.af3.exploration.dseml.model.booleanp.Or;
import org.fortiss.af3.exploration.dseml.model.booleanp.allocation.Allocation;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.Equal;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.GreaterEqual;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.LessEqual;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.NotEqual;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.dseml.model.expression.ModelElementLiteral;
import org.fortiss.af3.exploration.dseml.model.expression.Set;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.dseml.model.function.ScheduledSignal;
import org.fortiss.af3.exploration.dseml.model.function.ScheduledTask;
import org.fortiss.af3.exploration.model.ExplorationConstraint;
import org.fortiss.af3.exploration.model.IExplorationConstraint;
import org.fortiss.af3.exploration.model.IProblemDimension;
import org.fortiss.af3.exploration.model.SuperSetMap;
import org.fortiss.af3.exploration.model.synthesiscategory.IDeploymentSynthesis;
import org.fortiss.af3.exploration.model.synthesiscategory.IScheduleSynthesis;
import org.fortiss.af3.exploration.smt.model.dseml.FrequencyAssigned;
import org.fortiss.af3.exploration.smt.modeltransformation.EnergyConstraintDefinition;
import org.fortiss.af3.exploration.smt.util.ConstraintDefinitionUtils;
import org.fortiss.af3.exploration.util.DSMLModelElementFactory;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.exploration.util.ExplorationTimingConstraintUtils;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.Route;
import org.fortiss.af3.platform.model.annotation.MessageSize;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.schedule.model.SchedulableEntity;
import org.fortiss.af3.task.model.Message;
import org.fortiss.af3.task.model.Signal;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskInputPort;
import org.fortiss.af3.task.model.TaskOutputPort;
import org.fortiss.af3.task.model.allocation.ComponentToTaskAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskWcetTable;
import org.fortiss.af3.task.model.allocation.impl.TaskWcetTableStaticImpl;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.utils.AnnotationUtils;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class BasicDeploScheduleConstraint {
    static final int BITS_IN_A_BYTE = 8;
    static final int BITS_IN_A_MEGABIT = 1000000;

    public static List<IExplorationConstraint<?>> generateDeploScheduleConstraints(SuperSet<ResourceAllocation> resAllocSS, SuperSet<Task> taskSS, SuperSet<Signal> signalSS, SuperSet<ExecutionUnit> ecuSS, SuperSet<Route> routeSuperSet, SuperSet<ComponentToTaskAllocationEntry> co2ta, SuperSet<TaskWcetTable> wcetTable) {
        ArrayList generatedConstraints = new ArrayList();
        ArrayList<Object> assertions = new ArrayList<Object>();
        assertions = new ArrayList();
        assertions.addAll(BasicDeploScheduleConstraint.createStronglyCausalFunction(taskSS, co2ta));
        assertions.addAll(BasicDeploScheduleConstraint.createIsTaskFunction(resAllocSS));
        assertions.addAll(BasicDeploScheduleConstraint.createResAllocMapping(resAllocSS, taskSS, signalSS));
        assertions.addAll(BasicDeploScheduleConstraint.createDurationConstraints(resAllocSS, taskSS, signalSS, ecuSS, routeSuperSet, wcetTable));
        assertions.addAll(BasicDeploScheduleConstraint.createGreaterEqualZeroConstraints(resAllocSS));
        assertions.addAll(EnergyConstraintDefinition.createFrequencyConstraints(ecuSS));
        assertions.addAll(EnergyConstraintDefinition.createTileFrequencyConstraints(ecuSS));
        int i = 1;
        for (IBooleanExpression iBooleanExpression : assertions) {
            ExplorationConstraint ts = ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createUserDefinedDimension((String)"unused"), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)iBooleanExpression, (String)("Implicit Schedule Constraint " + i++), (boolean)true);
            generatedConstraints.add((IExplorationConstraint<?>)ts);
            UniqueIDUtils.prepareUniqueID((EObject)ts, co2ta);
        }
        return generatedConstraints;
    }

    public static List<IExplorationConstraint<?>> generateDeploScheduleSpecificConstraints(SuperSetMap superSets) {
        ExplorationConstraint ts;
        ArrayList generatedConstraints = new ArrayList();
        ArrayList<IBooleanExpression> assertions = new ArrayList<IBooleanExpression>();
        SuperSet resAllocSS = superSets.get(ResourceAllocation.class);
        SuperSet taskSS = superSets.get(Task.class);
        SuperSet ecuSS = superSets.get(ExecutionUnit.class);
        SuperSet signalSS = superSets.get(Signal.class);
        assertions.addAll(BasicDeploScheduleConstraint.createECUNonOverlappingConstraints((SuperSet<ResourceAllocation>)resAllocSS, (SuperSet<Task>)taskSS, (SuperSet<ExecutionUnit>)ecuSS));
        assertions.addAll(BasicDeploScheduleConstraint.createRoutesNonOverlappingConstraints((SuperSet<ResourceAllocation>)resAllocSS));
        int i = 1;
        for (IBooleanExpression expr : assertions) {
            ts = ExplorationModelElementFactory.createExplorationConstraint(Double.class, (IProblemDimension)ExplorationModelElementFactory.createTemporalDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IScheduleSynthesis.class}), (IExpression)expr, (String)("Non-Overlapping Constraint " + i++), (boolean)true);
            generatedConstraints.add((IExplorationConstraint<?>)ts);
            UniqueIDUtils.prepareUniqueID((EObject)ts, (EObject)superSets.get(ComponentToTaskAllocationEntry.class));
        }
        assertions.clear();
        assertions.addAll(BasicDeploScheduleConstraint.createCausalityConstraints((SuperSet<ResourceAllocation>)resAllocSS, (SuperSet<Task>)taskSS, (SuperSet<Signal>)signalSS, (SuperSet<ExecutionUnit>)ecuSS));
        i = 1;
        for (IBooleanExpression expr : assertions) {
            ts = ExplorationModelElementFactory.createExplorationConstraint(Double.class, (IProblemDimension)ExplorationModelElementFactory.createTemporalDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IScheduleSynthesis.class}), (IExpression)expr, (String)("Causality Constraint " + i++), (boolean)true);
            generatedConstraints.add((IExplorationConstraint<?>)ts);
            UniqueIDUtils.prepareUniqueID((EObject)ts, (EObject)superSets.get(ComponentToTaskAllocationEntry.class));
        }
        return generatedConstraints;
    }

    public static List<? extends IBooleanExpression> createGreaterEqualZeroConstraints(SuperSet<ResourceAllocation> rsAllocSet) {
        ArrayList<ForAll> assertions = new ArrayList<ForAll>();
        Set set = DSMLModelElementFactory.createSet(rsAllocSet, (String)"aResourceAllocations", ResourceAllocation.class);
        set.getEntries().addAll((Collection)rsAllocSet.getEntries());
        ArithmeticPropertyLiteral startSet1 = ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)set);
        ArithmeticLiteral literal = DSMLModelElementFactory.createArithmeticLiteral((BigDecimal)BigDecimal.ZERO);
        GreaterEqual gEquals = DSMLModelElementFactory.createGreaterEqual((IArithmeticExpression)startSet1, (IArithmeticExpression)literal);
        ForAll forAll1 = DSMLModelElementFactory.createForAll((Set)set, (IBooleanExpression)gEquals, (boolean)true);
        assertions.add(forAll1);
        return assertions;
    }

    public static List<? extends IBooleanExpression> createStronglyCausalFunction(SuperSet<Task> taskSS, SuperSet<ComponentToTaskAllocationEntry> co2ta) {
        ArrayList<ForAll> assertions = new ArrayList<ForAll>();
        for (Task task : taskSS.getEntries()) {
            Set taskSet = DSMLModelElementFactory.createSet(taskSS, (String)"aTask", Task.class);
            taskSet.getEntries().add((Object)task);
            Equal equality = ConstraintDefinitionUtils.defineStronglyCausal((Set<Task>)taskSet, ConstraintDefinitionUtils.isStronglyCausal(task, co2ta));
            ForAll formula = DSMLModelElementFactory.createForAll((Set)taskSet, (IBooleanExpression)equality, (boolean)true);
            assertions.add(formula);
        }
        return assertions;
    }

    public static List<? extends IBooleanExpression> createIsTaskFunction(SuperSet<ResourceAllocation> resAllocSS) {
        ArrayList<ForAll> assertions = new ArrayList<ForAll>();
        for (ResourceAllocation ra : resAllocSS.getEntries()) {
            Set raSet = DSMLModelElementFactory.createSet(resAllocSS, (String)"aResourceAllocation", ResourceAllocation.class);
            raSet.getEntries().add((Object)ra);
            IModelElement entity = ra.getSchedulableEntity().getModelElement();
            Equal equality = ConstraintDefinitionUtils.defineIsTask((Set<ResourceAllocation>)raSet, entity instanceof Task);
            ForAll formula = DSMLModelElementFactory.createForAll((Set)raSet, (IBooleanExpression)equality, (boolean)true);
            assertions.add(formula);
        }
        return assertions;
    }

    public static List<? extends IBooleanExpression> createResAllocMapping(SuperSet<ResourceAllocation> resAllocSS, SuperSet<Task> taskSS, SuperSet<Signal> signalSS) {
        ArrayList<ForAll> assertions = new ArrayList<ForAll>();
        for (ResourceAllocation resAlloc : resAllocSS.getEntries()) {
            ForAll formula;
            ForAll forAll;
            Equal equality;
            ModelElementLiteral ent;
            ScheduledSignal elem;
            Set raSet = DSMLModelElementFactory.createSet(resAllocSS, (String)"aResourceAllocation_Set", ResourceAllocation.class);
            raSet.getEntries().add((Object)resAlloc);
            SchedulableEntity entity = resAlloc.getSchedulableEntity();
            IModelElement modelElement = entity.getModelElement();
            if (modelElement instanceof Task) {
                Set entitySet = DSMLModelElementFactory.createSet(taskSS, (String)"xTask_Set", Task.class);
                entitySet.getEntries().add((Object)((Task)modelElement));
                elem = ConstraintDefinitionUtils.createScheduledTask(raSet, entitySet);
                ent = DSMLModelElementFactory.createModelElementLiteral((Set)entitySet);
                equality = DSMLModelElementFactory.createEquals((IExpression)elem, (IExpression)ent);
                forAll = DSMLModelElementFactory.createForAll((Set)entitySet, (IBooleanExpression)equality, (boolean)true);
                formula = DSMLModelElementFactory.createForAll((Set)raSet, (IBooleanExpression)forAll, (boolean)true);
                assertions.add(formula);
                continue;
            }
            if (!(modelElement instanceof TaskOutputPort)) continue;
            Set<Signal> signalSet = BasicDeploScheduleConstraint.createSignalSetFromMessage(signalSS, (Message)entity);
            elem = ConstraintDefinitionUtils.createScheduledSignal(raSet, signalSet);
            ent = DSMLModelElementFactory.createModelElementLiteral(signalSet);
            equality = DSMLModelElementFactory.createEquals((IExpression)elem, (IExpression)ent);
            forAll = DSMLModelElementFactory.createForAll(signalSet, (IBooleanExpression)equality, (boolean)true);
            formula = DSMLModelElementFactory.createForAll((Set)raSet, (IBooleanExpression)forAll, (boolean)true);
            assertions.add(formula);
        }
        return assertions;
    }

    public static List<IBooleanExpression> createECUNonOverlappingConstraints(SuperSet<ResourceAllocation> resAllocSS, SuperSet<Task> taskSS, SuperSet<ExecutionUnit> ecuSS) {
        ArrayList<IBooleanExpression> assertions = new ArrayList<IBooleanExpression>();
        Set raSet1 = DSMLModelElementFactory.createSet(resAllocSS, (Collection)resAllocSS.getEntries(), (String)"aResourceAllocation", ResourceAllocation.class);
        Set raSet2 = DSMLModelElementFactory.createSet(resAllocSS, (Collection)resAllocSS.getEntries(), (String)"bResourceAllocation", ResourceAllocation.class);
        Set taskSet1 = DSMLModelElementFactory.createSet(taskSS, (Collection)taskSS.getEntries(), (String)"cTask_Set", Task.class);
        Set taskSet2 = DSMLModelElementFactory.createSet(taskSS, (Collection)taskSS.getEntries(), (String)"dTask_Set", Task.class);
        Set ecuSet1 = DSMLModelElementFactory.createSet(ecuSS, (Collection)ecuSS.getEntries(), (String)"eECU", ExecutionUnit.class);
        ModelElementLiteral ra1 = DSMLModelElementFactory.createModelElementLiteral((Set)raSet1);
        ModelElementLiteral ra2 = DSMLModelElementFactory.createModelElementLiteral((Set)raSet2);
        NotEqual distinctRA = DSMLModelElementFactory.createNotEqual((IExpression)ra1, (IExpression)ra2);
        Equal isTask1 = ConstraintDefinitionUtils.defineIsTask((Set<ResourceAllocation>)raSet1, true);
        Equal isTask2 = ConstraintDefinitionUtils.defineIsTask((Set<ResourceAllocation>)raSet2, true);
        And yesTask = DSMLModelElementFactory.createAnd((IBooleanExpression)isTask1, (IBooleanExpression)isTask2);
        ScheduledTask elem1 = ConstraintDefinitionUtils.createScheduledTask(raSet1, taskSet1);
        ModelElementLiteral entity1 = DSMLModelElementFactory.createModelElementLiteral((Set)taskSet1);
        Equal schedTask1 = DSMLModelElementFactory.createEquals((IExpression)elem1, (IExpression)entity1);
        ScheduledTask elem2 = ConstraintDefinitionUtils.createScheduledTask(raSet2, taskSet2);
        ModelElementLiteral entity2 = DSMLModelElementFactory.createModelElementLiteral((Set)taskSet2);
        Equal schedTask2 = DSMLModelElementFactory.createEquals((IExpression)elem2, (IExpression)entity2);
        And schedTask = DSMLModelElementFactory.createAnd((IBooleanExpression)schedTask1, (IBooleanExpression)schedTask2);
        Allocation allocation1 = ConstraintDefinitionUtils.defineAllocation((Set<Task>)taskSet1, (Set<ExecutionUnit>)ecuSet1);
        Allocation allocation2 = ConstraintDefinitionUtils.defineAllocation((Set<Task>)taskSet2, (Set<ExecutionUnit>)ecuSet1);
        And resourceAllocs = DSMLModelElementFactory.createAnd((IBooleanExpression)allocation1, (IBooleanExpression)allocation2);
        And and1 = DSMLModelElementFactory.createAnd((IBooleanExpression)distinctRA, (IBooleanExpression)yesTask);
        And and2 = DSMLModelElementFactory.createAnd((IBooleanExpression)and1, (IBooleanExpression)schedTask);
        And premise = DSMLModelElementFactory.createAnd((IBooleanExpression)and2, (IBooleanExpression)resourceAllocs);
        ArithmeticPropertyLiteral startSet1 = ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)raSet1);
        ArithmeticPropertyLiteral startSet2 = ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)raSet2);
        ArithmeticPropertyLiteral durationSet1 = ExplorationTimingConstraintUtils.createDurationLiteral((Set)raSet1);
        ArithmeticPropertyLiteral durationSet2 = ExplorationTimingConstraintUtils.createDurationLiteral((Set)raSet2);
        Plus endSet1 = DSMLModelElementFactory.createPlus((IArithmeticExpression)startSet1, (IArithmeticExpression)durationSet1);
        Plus endSet2 = DSMLModelElementFactory.createPlus((IArithmeticExpression)startSet2, (IArithmeticExpression)durationSet2);
        ArithmeticPropertyLiteral startSet11 = ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)raSet1);
        ArithmeticPropertyLiteral startSet22 = ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)raSet2);
        LessEqual cond1 = DSMLModelElementFactory.createLessEqual((IArithmeticExpression)endSet1, (IArithmeticExpression)startSet22);
        LessEqual cond2 = DSMLModelElementFactory.createLessEqual((IArithmeticExpression)endSet2, (IArithmeticExpression)startSet11);
        Or conclusion = DSMLModelElementFactory.createOr((IBooleanExpression)cond1, (IBooleanExpression)cond2);
        Implies implication = DSMLModelElementFactory.createImplies((IBooleanExpression)premise, (IBooleanExpression)conclusion);
        ForAll forAllRes = DSMLModelElementFactory.createForAll((Set)ecuSet1, (IBooleanExpression)implication, (boolean)false);
        ForAll forAllEntity1 = DSMLModelElementFactory.createForAll((Set)taskSet2, (IBooleanExpression)forAllRes, (boolean)false);
        ForAll forAllEntity2 = DSMLModelElementFactory.createForAll((Set)taskSet1, (IBooleanExpression)forAllEntity1, (boolean)false);
        ForAll forAllRA2 = DSMLModelElementFactory.createForAll((Set)raSet2, (IBooleanExpression)forAllEntity2, (boolean)false);
        ForAll formula = DSMLModelElementFactory.createForAll((Set)raSet1, (IBooleanExpression)forAllRA2, (boolean)false);
        assertions.add((IBooleanExpression)formula);
        return assertions;
    }

    public static List<IBooleanExpression> createRoutesNonOverlappingConstraints(SuperSet<ResourceAllocation> resAllocSS) {
        ArrayList<IBooleanExpression> assertions = new ArrayList<IBooleanExpression>();
        Set raSet1 = DSMLModelElementFactory.createSet(resAllocSS, (Collection)resAllocSS.getEntries(), (String)"aResourceAllocation", ResourceAllocation.class);
        Set raSet2 = DSMLModelElementFactory.createSet(resAllocSS, (Collection)resAllocSS.getEntries(), (String)"bResourceAllocation", ResourceAllocation.class);
        ModelElementLiteral ra1 = DSMLModelElementFactory.createModelElementLiteral((Set)raSet1);
        ModelElementLiteral ra2 = DSMLModelElementFactory.createModelElementLiteral((Set)raSet2);
        NotEqual distinctRA = DSMLModelElementFactory.createNotEqual((IExpression)ra1, (IExpression)ra2);
        Equal isTask1 = ConstraintDefinitionUtils.defineIsTask((Set<ResourceAllocation>)raSet1, false);
        Equal isTask2 = ConstraintDefinitionUtils.defineIsTask((Set<ResourceAllocation>)raSet2, false);
        And notTask = DSMLModelElementFactory.createAnd((IBooleanExpression)isTask1, (IBooleanExpression)isTask2);
        And premise = DSMLModelElementFactory.createAnd((IBooleanExpression)distinctRA, (IBooleanExpression)notTask);
        ArithmeticPropertyLiteral startSet1 = ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)raSet1);
        ArithmeticPropertyLiteral startSet2 = ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)raSet2);
        ArithmeticPropertyLiteral durationSet1 = ExplorationTimingConstraintUtils.createDurationLiteral((Set)raSet1);
        ArithmeticPropertyLiteral durationSet2 = ExplorationTimingConstraintUtils.createDurationLiteral((Set)raSet2);
        Plus endSet1 = DSMLModelElementFactory.createPlus((IArithmeticExpression)startSet1, (IArithmeticExpression)durationSet1);
        Plus endSet2 = DSMLModelElementFactory.createPlus((IArithmeticExpression)startSet2, (IArithmeticExpression)durationSet2);
        ArithmeticPropertyLiteral startSet11 = ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)raSet1);
        ArithmeticPropertyLiteral startSet22 = ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)raSet2);
        LessEqual cond1 = DSMLModelElementFactory.createLessEqual((IArithmeticExpression)endSet1, (IArithmeticExpression)startSet22);
        LessEqual cond2 = DSMLModelElementFactory.createLessEqual((IArithmeticExpression)endSet2, (IArithmeticExpression)startSet11);
        Or conclusion = DSMLModelElementFactory.createOr((IBooleanExpression)cond1, (IBooleanExpression)cond2);
        Implies implication = DSMLModelElementFactory.createImplies((IBooleanExpression)premise, (IBooleanExpression)conclusion);
        ForAll forAllRA2 = DSMLModelElementFactory.createForAll((Set)raSet2, (IBooleanExpression)implication, (boolean)false);
        ForAll formula = DSMLModelElementFactory.createForAll((Set)raSet1, (IBooleanExpression)forAllRA2, (boolean)false);
        assertions.add((IBooleanExpression)formula);
        return assertions;
    }

    public static List<IBooleanExpression> createDurationConstraints(SuperSet<ResourceAllocation> resAllocSS, SuperSet<Task> taskSS, SuperSet<Signal> signalSS, SuperSet<ExecutionUnit> ecuSS, SuperSet<Route> routeSS, SuperSet<TaskWcetTable> taskWcets) {
        ArrayList<IBooleanExpression> assertions = new ArrayList<IBooleanExpression>();
        TaskWcetTable taskWcetTable = (TaskWcetTable)LambdaUtils.getFirst((Collection)taskWcets.getEntries()).get();
        for (ResourceAllocation currentRA : resAllocSS.getEntries()) {
            SchedulableEntity entity = currentRA.getSchedulableEntity();
            IModelElement modelElement = entity.getModelElement();
            if (modelElement instanceof Task) {
                BasicDeploScheduleConstraint.createTaskDuration(resAllocSS, taskSS, ecuSS, assertions, taskWcetTable, currentRA, modelElement);
                continue;
            }
            if (entity instanceof Message) {
                BasicDeploScheduleConstraint.createSignalDuration(resAllocSS, signalSS, routeSS, assertions, currentRA, entity, modelElement);
                continue;
            }
            Set oneElementSet = DSMLModelElementFactory.createSet(resAllocSS, (String)(currentRA.getName() + "_set"), ResourceAllocation.class);
            oneElementSet.getEntries().add((Object)currentRA);
            ArithmeticPropertyLiteral duration = ExplorationTimingConstraintUtils.createDurationLiteral((Set)oneElementSet);
            ArithmeticLiteral literal = DSMLModelElementFactory.createArithmeticLiteral((BigDecimal)currentRA.getDuration());
            Equal equals = DSMLModelElementFactory.createEquals((IExpression)literal, (IExpression)duration);
            ForAll formula = DSMLModelElementFactory.createForAll((Set)oneElementSet, (IBooleanExpression)equals, (boolean)true);
            assertions.add((IBooleanExpression)formula);
        }
        return assertions;
    }

    private static void createSignalDuration(SuperSet<ResourceAllocation> resAllocSS, SuperSet<Signal> signalSS, SuperSet<Route> routeSS, List<IBooleanExpression> assertions, ResourceAllocation currentRA, SchedulableEntity entity, IModelElement modelElement) {
        for (Route route : routeSS.getEntries()) {
            ArithmeticLiteral value;
            Set ra = DSMLModelElementFactory.createSet(resAllocSS, (IModelElement)currentRA, (String)"aResAllocSet", ResourceAllocation.class);
            Set routeSet = DSMLModelElementFactory.createSet(routeSS, (IModelElement)route, (String)"bRoute", Route.class);
            Set<Signal> signalSet = BasicDeploScheduleConstraint.createSignalSetFromMessage(signalSS, (Message)entity);
            ModelElementLiteral s = DSMLModelElementFactory.createModelElementLiteral(signalSet);
            ModelElementLiteral r = DSMLModelElementFactory.createModelElementLiteral((Set)routeSet);
            Allocation allocation = DSMLModelElementFactory.createAllocation((ModelElementLiteral)s, (ModelElementLiteral)r);
            ArithmeticPropertyLiteral durationLit = ExplorationTimingConstraintUtils.createDurationLiteral((Set)ra);
            if (ConstraintDefinitionUtils.isLocal(route)) {
                value = DSMLModelElementFactory.createArithmeticLiteral((BigDecimal)new BigDecimal(0));
            } else {
                int bandwidth;
                int durationValue;
                TaskOutputPort taskPort = (TaskOutputPort)modelElement;
                int messageSize = (Integer)AnnotationUtils.getAnnotationValue((IModelElement)taskPort, MessageSize.class, Integer.class);
                int minBandwidth = ConstraintDefinitionUtils.getMinBandwidth(route);
                if (minBandwidth == 0) {
                    minBandwidth = 1;
                }
                if ((durationValue = messageSize / (bandwidth = minBandwidth * 1000000)) == 0) {
                    durationValue = 1;
                }
                value = DSMLModelElementFactory.createArithmeticLiteral((BigDecimal)new BigDecimal(durationValue));
            }
            Equal duration = DSMLModelElementFactory.createEquals((IExpression)value, (IExpression)durationLit);
            Implies implication = DSMLModelElementFactory.createImplies((IBooleanExpression)allocation, (IBooleanExpression)duration);
            ForAll forAll0 = DSMLModelElementFactory.createForAll(signalSet, (IBooleanExpression)implication, (boolean)true);
            ForAll forAll1 = DSMLModelElementFactory.createForAll((Set)routeSet, (IBooleanExpression)forAll0, (boolean)true);
            ForAll formula = DSMLModelElementFactory.createForAll((Set)ra, (IBooleanExpression)forAll1, (boolean)true);
            assertions.add((IBooleanExpression)formula);
        }
    }

    private static void createTaskDuration(SuperSet<ResourceAllocation> resAllocSS, SuperSet<Task> taskSS, SuperSet<ExecutionUnit> ecuSS, List<IBooleanExpression> assertions, TaskWcetTable taskWcetTable, ResourceAllocation currentRA, IModelElement modelElement) {
        for (ExecutionUnit ecu : ecuSS.getEntries()) {
            List<Long> admissibleFreq = ConstraintDefinitionUtils.getAdmissibleFrequencies(ecu);
            for (long frequency : admissibleFreq) {
                Set ra = DSMLModelElementFactory.createSet(resAllocSS, (IModelElement)currentRA, (String)"aResAllocSet", ResourceAllocation.class);
                Set taskSet = DSMLModelElementFactory.createSet(taskSS, (IModelElement)((Task)modelElement), (String)"bTask", Task.class);
                ModelElementLiteral taskLiteral = DSMLModelElementFactory.createModelElementLiteral((Set)taskSet);
                Set ecuSet = DSMLModelElementFactory.createSet(ecuSS, (IModelElement)ecu, (String)"cECU", ExecutionUnit.class);
                ModelElementLiteral ecuLiteral = DSMLModelElementFactory.createModelElementLiteral((Set)ecuSet);
                Allocation allocation = DSMLModelElementFactory.createAllocation((ModelElementLiteral)taskLiteral, (ModelElementLiteral)ecuLiteral);
                FrequencyAssigned fa = ConstraintDefinitionUtils.createFrequencyAssigned((Set<ExecutionUnit>)ecuSet);
                ArithmeticLiteral val = DSMLModelElementFactory.createArithmeticLiteral((BigDecimal)new BigDecimal((int)frequency));
                Equal equalityFreq = DSMLModelElementFactory.createEquals((IExpression)fa, (IExpression)val);
                And premise = DSMLModelElementFactory.createAnd((IBooleanExpression)allocation, (IBooleanExpression)equalityFreq);
                ArithmeticPropertyLiteral duration = ExplorationTimingConstraintUtils.createDurationLiteral((Set)ra);
                BigDecimal wcet = TaskWcetTableStaticImpl.getWcet((TaskWcetTable)taskWcetTable, (Task)((Task)modelElement), (ExecutionUnit)ecu, (long)frequency);
                if (wcet == null) {
                    wcet = BigDecimal.valueOf(Double.MAX_VALUE);
                }
                ArithmeticLiteral wcetLiteral = DSMLModelElementFactory.createArithmeticLiteral((BigDecimal)wcet);
                Equal conclusion = DSMLModelElementFactory.createEquals((IExpression)duration, (IExpression)wcetLiteral);
                Implies implication = DSMLModelElementFactory.createImplies((IBooleanExpression)premise, (IBooleanExpression)conclusion);
                ForAll forall = DSMLModelElementFactory.createForAll((Set)ra, (IBooleanExpression)implication, (boolean)true);
                ForAll forall2 = DSMLModelElementFactory.createForAll((Set)ecuSet, (IBooleanExpression)forall, (boolean)true);
                ForAll formula = DSMLModelElementFactory.createForAll((Set)taskSet, (IBooleanExpression)forall2, (boolean)true);
                assertions.add((IBooleanExpression)formula);
            }
        }
    }

    private static Set<Signal> createSignalSetFromMessage(SuperSet<Signal> signalSS, Message message) {
        IModelElement modelElement = message.getModelElement();
        Signal signal = ConstraintDefinitionUtils.getSignal((TaskOutputPort)modelElement, (TaskInputPort)message.getReceivers().get(0), signalSS);
        Set signalSet = DSMLModelElementFactory.createSet(signalSS, (IModelElement)signal, (String)"ySignalSet", Signal.class);
        return signalSet;
    }

    public static List<IBooleanExpression> createCausalityConstraints(SuperSet<ResourceAllocation> raSS, SuperSet<Task> taskSS, SuperSet<Signal> signalSS, SuperSet<ExecutionUnit> ecuSS) {
        ArrayList<IBooleanExpression> assertions = new ArrayList<IBooleanExpression>();
        Set sigSet = DSMLModelElementFactory.createSet(signalSS, (Collection)signalSS.getEntries(), (String)"aSignal", Signal.class);
        Set tskSet1 = DSMLModelElementFactory.createSet(taskSS, (Collection)taskSS.getEntries(), (String)"bSourceTask", Task.class);
        Set tskSet2 = DSMLModelElementFactory.createSet(taskSS, (Collection)taskSS.getEntries(), (String)"cTargetTask", Task.class);
        Set raSet1 = DSMLModelElementFactory.createSet(raSS, (Collection)raSS.getEntries(), (String)"dResAll", ResourceAllocation.class);
        Set raSet2 = DSMLModelElementFactory.createSet(raSS, (Collection)raSS.getEntries(), (String)"eResAll", ResourceAllocation.class);
        Set raSet3 = DSMLModelElementFactory.createSet(raSS, (Collection)raSS.getEntries(), (String)"fResAll", ResourceAllocation.class);
        Set ecuSet1 = DSMLModelElementFactory.createSet(ecuSS, (Collection)ecuSS.getEntries(), (String)"gSourceExecutionUnit", ExecutionUnit.class);
        Set ecuSet2 = DSMLModelElementFactory.createSet(ecuSS, (Collection)ecuSS.getEntries(), (String)"hTargetExecutionUnit", ExecutionUnit.class);
        Equal p1 = DSMLModelElementFactory.createEquals((IExpression)ConstraintDefinitionUtils.createStart(sigSet, (Set<Task>)tskSet1), (IExpression)DSMLModelElementFactory.createModelElementLiteral((Set)tskSet1));
        Equal p2 = DSMLModelElementFactory.createEquals((IExpression)ConstraintDefinitionUtils.createEnd(sigSet, (Set<Task>)tskSet2), (IExpression)DSMLModelElementFactory.createModelElementLiteral((Set)tskSet2));
        Equal p3 = DSMLModelElementFactory.createEquals((IExpression)ConstraintDefinitionUtils.createScheduledTask(raSet1, tskSet1), (IExpression)DSMLModelElementFactory.createModelElementLiteral((Set)tskSet1));
        Equal p4 = DSMLModelElementFactory.createEquals((IExpression)ConstraintDefinitionUtils.createScheduledTask(raSet2, tskSet2), (IExpression)DSMLModelElementFactory.createModelElementLiteral((Set)tskSet2));
        Equal p5 = DSMLModelElementFactory.createEquals((IExpression)ConstraintDefinitionUtils.createScheduledSignal(raSet3, sigSet), (IExpression)DSMLModelElementFactory.createModelElementLiteral((Set)sigSet));
        Equal isTask1 = ConstraintDefinitionUtils.defineIsTask((Set<ResourceAllocation>)raSet1, true);
        Equal isTask2 = ConstraintDefinitionUtils.defineIsTask((Set<ResourceAllocation>)raSet2, true);
        Equal isTask3 = ConstraintDefinitionUtils.defineIsTask((Set<ResourceAllocation>)raSet3, false);
        And allocations = DSMLModelElementFactory.createAnd((IBooleanExpression)ConstraintDefinitionUtils.defineAllocation((Set<Task>)tskSet1, (Set<ExecutionUnit>)ecuSet1), (IBooleanExpression)ConstraintDefinitionUtils.defineAllocation((Set<Task>)tskSet2, (Set<ExecutionUnit>)ecuSet2));
        And and1 = DSMLModelElementFactory.createAnd((IBooleanExpression)DSMLModelElementFactory.createAnd((IBooleanExpression)allocations, (IBooleanExpression)p5), (IBooleanExpression)p4);
        And and2 = DSMLModelElementFactory.createAnd((IBooleanExpression)DSMLModelElementFactory.createAnd((IBooleanExpression)and1, (IBooleanExpression)p3), (IBooleanExpression)p2);
        And and3 = DSMLModelElementFactory.createAnd((IBooleanExpression)DSMLModelElementFactory.createAnd((IBooleanExpression)and2, (IBooleanExpression)isTask1), (IBooleanExpression)isTask2);
        And premise = DSMLModelElementFactory.createAnd((IBooleanExpression)DSMLModelElementFactory.createAnd((IBooleanExpression)and3, (IBooleanExpression)isTask3), (IBooleanExpression)p1);
        LessEqual le = DSMLModelElementFactory.createLessEqual((IArithmeticExpression)ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)raSet2), (IArithmeticExpression)ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)raSet1));
        Implies conjunct1 = DSMLModelElementFactory.createImplies((IBooleanExpression)ConstraintDefinitionUtils.defineStronglyCausal((Set<Task>)tskSet1, true), (IBooleanExpression)le);
        Equal ecus = DSMLModelElementFactory.createEquals((IExpression)DSMLModelElementFactory.createModelElementLiteral((Set)ecuSet1), (IExpression)DSMLModelElementFactory.createModelElementLiteral((Set)ecuSet2));
        Equal strongly = ConstraintDefinitionUtils.defineStronglyCausal((Set<Task>)tskSet1, false);
        And ecuStr = DSMLModelElementFactory.createAnd((IBooleanExpression)ecus, (IBooleanExpression)strongly);
        Plus t1End = DSMLModelElementFactory.createPlus((IArithmeticExpression)ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)raSet1), (IArithmeticExpression)ExplorationTimingConstraintUtils.createDurationLiteral((Set)raSet1));
        LessEqual le1 = DSMLModelElementFactory.createLessEqual((IArithmeticExpression)t1End, (IArithmeticExpression)ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)raSet2));
        Implies conjunct2 = DSMLModelElementFactory.createImplies((IBooleanExpression)ecuStr, (IBooleanExpression)le1);
        NotEqual ne = DSMLModelElementFactory.createNotEqual((IExpression)DSMLModelElementFactory.createModelElementLiteral((Set)ecuSet1), (IExpression)DSMLModelElementFactory.createModelElementLiteral((Set)ecuSet2));
        Plus t1bEnd = DSMLModelElementFactory.createPlus((IArithmeticExpression)ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)raSet1), (IArithmeticExpression)ExplorationTimingConstraintUtils.createDurationLiteral((Set)raSet1));
        LessEqual le2 = DSMLModelElementFactory.createLessEqual((IArithmeticExpression)t1bEnd, (IArithmeticExpression)ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)raSet3));
        Plus t3cEnd = DSMLModelElementFactory.createPlus((IArithmeticExpression)ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)raSet3), (IArithmeticExpression)ExplorationTimingConstraintUtils.createDurationLiteral((Set)raSet3));
        LessEqual le3 = DSMLModelElementFactory.createLessEqual((IArithmeticExpression)t3cEnd, (IArithmeticExpression)ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)raSet2));
        Implies impl = DSMLModelElementFactory.createImplies((IBooleanExpression)ConstraintDefinitionUtils.defineStronglyCausal((Set<Task>)tskSet1, false), (IBooleanExpression)le3);
        Implies conjunct3 = DSMLModelElementFactory.createImplies((IBooleanExpression)ne, (IBooleanExpression)DSMLModelElementFactory.createAnd((IBooleanExpression)le2, (IBooleanExpression)impl));
        And conclusion = DSMLModelElementFactory.createAnd((IBooleanExpression)conjunct1, (IBooleanExpression)DSMLModelElementFactory.createAnd((IBooleanExpression)conjunct2, (IBooleanExpression)conjunct3));
        Implies implication = DSMLModelElementFactory.createImplies((IBooleanExpression)premise, (IBooleanExpression)conclusion);
        ForAll forAll1 = DSMLModelElementFactory.createForAll((Set)ecuSet1, (IBooleanExpression)DSMLModelElementFactory.createForAll((Set)ecuSet2, (IBooleanExpression)implication, (boolean)false), (boolean)false);
        ForAll forAll2 = DSMLModelElementFactory.createForAll((Set)raSet2, (IBooleanExpression)DSMLModelElementFactory.createForAll((Set)raSet3, (IBooleanExpression)forAll1, (boolean)false), (boolean)false);
        ForAll forAll3 = DSMLModelElementFactory.createForAll((Set)tskSet2, (IBooleanExpression)DSMLModelElementFactory.createForAll((Set)raSet1, (IBooleanExpression)forAll2, (boolean)false), (boolean)false);
        ForAll formula = DSMLModelElementFactory.createForAll((Set)sigSet, (IBooleanExpression)DSMLModelElementFactory.createForAll((Set)tskSet1, (IBooleanExpression)forAll3, (boolean)false), (boolean)false);
        assertions.add((IBooleanExpression)formula);
        return assertions;
    }
}

