/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.smt.modeltransformation;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import javax.activation.UnsupportedDataTypeException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.exploration.dseml.model.booleanp.And;
import org.fortiss.af3.exploration.dseml.model.booleanp.ForAll;
import org.fortiss.af3.exploration.dseml.model.booleanp.IBooleanExpression;
import org.fortiss.af3.exploration.dseml.model.booleanp.Implies;
import org.fortiss.af3.exploration.dseml.model.booleanp.allocation.Allocation;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.Equal;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.dseml.model.expression.ModelElementLiteral;
import org.fortiss.af3.exploration.dseml.model.expression.Set;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.dseml.model.function.End;
import org.fortiss.af3.exploration.dseml.model.function.FunctionFactory;
import org.fortiss.af3.exploration.dseml.model.function.Start;
import org.fortiss.af3.exploration.model.IExplorationConstraint;
import org.fortiss.af3.exploration.model.IProblemDimension;
import org.fortiss.af3.exploration.model.synthesiscategory.IDeploymentSynthesis;
import org.fortiss.af3.exploration.smt.AF3ExplorationSMTActivator;
import org.fortiss.af3.exploration.util.DSMLModelElementFactory;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.Route;
import org.fortiss.af3.task.model.Signal;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskInputPort;
import org.fortiss.af3.task.model.TaskOutputPort;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class BasicDeploymentConstraint {
    public static List<IExplorationConstraint<?>> createBasicSignalConstraints(SuperSet<Signal> signalSuperSet, SuperSet<Task> taskSuperSet, SuperSet<ExecutionUnit> ecuSuperSet, SuperSet<Route> routeSuperSet) throws Exception {
        ArrayList constraints = new ArrayList();
        IExplorationConstraint<?> routingCstrs = BasicDeploymentConstraint.createBasicRoutingConstraints(signalSuperSet, routeSuperSet, taskSuperSet, ecuSuperSet);
        if (routingCstrs != null) {
            constraints.add(routingCstrs);
        }
        try {
            List<IExplorationConstraint<?>> startEndCstrs = BasicDeploymentConstraint.createStartEndConstraints(signalSuperSet, routeSuperSet, taskSuperSet, ecuSuperSet);
            constraints.addAll(startEndCstrs);
        }
        catch (UnsupportedDataTypeException e) {
            LoggingUtils.error((Plugin)AF3ExplorationSMTActivator.getDefault(), (String)e.getMessage());
        }
        return constraints;
    }

    private static IExplorationConstraint<?> createBasicRoutingConstraints(SuperSet<Signal> signalSuperSet, SuperSet<Route> routes, SuperSet<Task> taskSuperSet, SuperSet<ExecutionUnit> ecuSuperSet) throws Exception {
        Set channels = DSMLModelElementFactory.createSet(signalSuperSet, (List)signalSuperSet.getEntries(), Signal.class);
        if (signalSuperSet.getEntries().isEmpty() || signalSuperSet.getEntries().get(0) == null) {
            return null;
        }
        IModelElement modelElement = (IModelElement)signalSuperSet.getEntries().get(0);
        channels.setName(modelElement.getClass().getSimpleName());
        EList routeEntries = routes.getEntries();
        Set routeSet = DSMLModelElementFactory.createSet(routes, (List)routeEntries, Route.class);
        if (routeEntries.isEmpty() || routeEntries.get(0) == null) {
            return null;
        }
        IModelElement modelElement2 = (IModelElement)routeEntries.get(0);
        routeSet.setName(modelElement2.getClass().getSimpleName());
        ForAll forAllCH = DSMLModelElementFactory.createForAll();
        forAllCH.setSet(channels.getCastedSet(IModelElement.class));
        ForAll forAllRoutes = DSMLModelElementFactory.createForAll();
        forAllRoutes.setSet(routeSet.getCastedSet(IModelElement.class));
        forAllCH.setExpression((IBooleanExpression)forAllRoutes);
        ModelElementLiteral r = DSMLModelElementFactory.createModelElementLiteral((Set)routeSet);
        ModelElementLiteral s = DSMLModelElementFactory.createModelElementLiteral((Set)channels);
        Allocation allocationCH_Route = DSMLModelElementFactory.createAllocation((ModelElementLiteral)s, (ModelElementLiteral)r);
        Start startCH = BasicDeploymentConstraint.createStart(taskSuperSet, channels);
        Start startRoute = BasicDeploymentConstraint.createStart(ecuSuperSet, routeSet);
        Allocation allocationStartChStartRoute = DSMLModelElementFactory.createAllocation((ModelElementLiteral)startCH, (ModelElementLiteral)startRoute);
        End endCH = BasicDeploymentConstraint.createEnd(taskSuperSet, channels);
        End endRoute = BasicDeploymentConstraint.createEnd(ecuSuperSet, routeSet);
        Allocation allocationEndChEndRoute = DSMLModelElementFactory.createAllocation((ModelElementLiteral)endCH, (ModelElementLiteral)endRoute);
        And createAnd = DSMLModelElementFactory.createAnd((IBooleanExpression)allocationStartChStartRoute, (IBooleanExpression)allocationEndChEndRoute);
        Implies implies = DSMLModelElementFactory.createImplies((IBooleanExpression)allocationCH_Route, (IBooleanExpression)createAnd);
        forAllRoutes.setExpression((IBooleanExpression)implies);
        return ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createResourceDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)forAllCH, (String)"Basic Routing Constraint", (boolean)true);
    }

    private static <T extends IModelElement> Start createStart(SuperSet<T> superSet, Set<?> setReference) {
        Start start = FunctionFactory.eINSTANCE.createStart();
        ModelElementLiteral modelElementLiteral = DSMLModelElementFactory.createModelElementLiteral(setReference);
        start.setArgs(modelElementLiteral);
        start.setSetReference((Set)superSet.getCastedSet(IModelElement.class));
        return start;
    }

    private static <T extends IModelElement> End createEnd(SuperSet<T> superSet, Set<?> setReference) {
        End end = FunctionFactory.eINSTANCE.createEnd();
        ModelElementLiteral modelElementLiteral = DSMLModelElementFactory.createModelElementLiteral(setReference);
        end.setArgs(modelElementLiteral);
        end.setSetReference((Set)superSet.getCastedSet(IModelElement.class));
        return end;
    }

    private static List<IExplorationConstraint<?>> createStartEndConstraints(SuperSet<Signal> signalSuperSet, SuperSet<Route> routes, SuperSet<Task> taskSuperSet, SuperSet<ExecutionUnit> ecuSet) throws UnsupportedDataTypeException {
        ArrayList expressions = new ArrayList();
        BasicDeploymentConstraint.createRouteConstraints(routes, ecuSet, expressions);
        BasicDeploymentConstraint.createSignalConstraints(signalSuperSet, taskSuperSet, expressions);
        return expressions;
    }

    private static <S extends IModelElement, T extends IModelElement> IExplorationConstraint<Boolean> createStartEndConstraint(SuperSet<S> superSet1, SuperSet<T> superSet2, S element1, T element2, String element1Name, String element2Name, BiFunction<Set<IModelElement>, Set<IModelElement>, Equal> cmpFnc, String constraintName) {
        Set channels = DSMLModelElementFactory.createSet(superSet1, element1, (String)element1Name, element1.getClass());
        Set tasks = DSMLModelElementFactory.createSet(superSet2, element2, (String)element2Name, element2.getClass());
        Set channelsModelElementSet = channels.getCastedSet(IModelElement.class);
        ForAll forAllCH = DSMLModelElementFactory.createForAll();
        forAllCH.setUnfold(true);
        forAllCH.setSet(channelsModelElementSet);
        Set tasksModelElementSet = tasks.getCastedSet(IModelElement.class);
        ForAll forAllComp = DSMLModelElementFactory.createForAll();
        forAllComp.setUnfold(true);
        forAllComp.setSet(tasksModelElementSet);
        forAllCH.setExpression((IBooleanExpression)forAllComp);
        Equal equals = cmpFnc.apply((Set<IModelElement>)channelsModelElementSet, (Set<IModelElement>)tasksModelElementSet);
        forAllComp.setExpression((IBooleanExpression)equals);
        return ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createTemporalDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)forAllCH, (String)constraintName, (boolean)true);
    }

    private static void createSignalConstraints(SuperSet<Signal> signalSuperSet, SuperSet<Task> taskSuperSet, List<IExplorationConstraint<?>> expressions) throws UnsupportedDataTypeException {
        for (Signal channel : signalSuperSet.getEntries()) {
            TaskOutputPort s = channel.getSourceTaskPort();
            TaskInputPort t = channel.getTargetTaskPort();
            Task source = (Task)s.getOwner();
            Task target = (Task)t.getOwner();
            if (!taskSuperSet.getEntries().contains((Object)source)) {
                throw new UnsupportedDataTypeException("Source of connection " + String.valueOf(channel) + " can not be found");
            }
            if (!taskSuperSet.getEntries().contains((Object)target)) {
                throw new UnsupportedDataTypeException("Target of connection " + String.valueOf(channel) + " can not be found");
            }
            IExplorationConstraint<Boolean> startConstraint = BasicDeploymentConstraint.createStartEndConstraint(signalSuperSet, taskSuperSet, channel, source, "Signal", "Task", BasicDeploymentConstraint::start, "Start Channel Constraints");
            expressions.add(startConstraint);
            IExplorationConstraint<Boolean> endConstraint = BasicDeploymentConstraint.createStartEndConstraint(signalSuperSet, taskSuperSet, channel, target, "Signal", "Task", BasicDeploymentConstraint::end, "End Channel Constraints");
            expressions.add(endConstraint);
        }
    }

    private static void createRouteConstraints(SuperSet<Route> routes, SuperSet<ExecutionUnit> ecuSet, List<IExplorationConstraint<?>> expressions) throws UnsupportedDataTypeException {
        for (Route route : routes.getEntries()) {
            ExecutionUnit ecuStart = route.getSenderExecutionUnit();
            for (ExecutionUnit ecuEnd : route.getReceiverExecutionUnits()) {
                if (!ecuSet.getEntries().contains((Object)ecuStart)) {
                    throw new UnsupportedDataTypeException("Source of route " + String.valueOf(route) + " can not be found");
                }
                if (!ecuSet.getEntries().contains((Object)ecuEnd)) {
                    throw new UnsupportedDataTypeException("Target of route " + String.valueOf(route) + " can not be found");
                }
                IExplorationConstraint<Boolean> startConstraint = BasicDeploymentConstraint.createStartEndConstraint(routes, ecuSet, route, ecuStart, "Route", "ECU", BasicDeploymentConstraint::start, "Start Route Constraints");
                expressions.add(startConstraint);
                IExplorationConstraint<Boolean> endConstraint = BasicDeploymentConstraint.createStartEndConstraint(routes, ecuSet, route, ecuEnd, "Route", "ECU", BasicDeploymentConstraint::end, "End Route Constraints");
                expressions.add(endConstraint);
            }
        }
    }

    private static Equal end(Set<IModelElement> endArg, Set<IModelElement> returnType) {
        End endCH = FunctionFactory.eINSTANCE.createEnd();
        ModelElementLiteral s_3 = DSMLModelElementFactory.createModelElementLiteral(endArg);
        endCH.setArgs(s_3);
        endCH.setSetReference(returnType);
        ModelElementLiteral comp2 = DSMLModelElementFactory.createModelElementLiteral(returnType);
        Equal equals3 = DSMLModelElementFactory.createEquals((IExpression)endCH, (IExpression)comp2);
        return equals3;
    }

    private static Equal start(Set<IModelElement> startArg, Set<IModelElement> returnType) {
        Start startCH = FunctionFactory.eINSTANCE.createStart();
        ModelElementLiteral ch = DSMLModelElementFactory.createModelElementLiteral(startArg);
        startCH.setArgs(ch);
        startCH.setSetReference(returnType);
        ModelElementLiteral comp1 = DSMLModelElementFactory.createModelElementLiteral(returnType);
        Equal equals = DSMLModelElementFactory.createEquals((IExpression)startCH, (IExpression)comp1);
        return equals;
    }
}

