/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.smt.modeltransformation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.exploration.dseml.model.arithmetic.ArithmeticPropertyLiteral;
import org.fortiss.af3.exploration.dseml.model.arithmetic.IArithmeticExpression;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Plus;
import org.fortiss.af3.exploration.dseml.model.booleanp.And;
import org.fortiss.af3.exploration.dseml.model.booleanp.ForAll;
import org.fortiss.af3.exploration.dseml.model.booleanp.IBooleanExpression;
import org.fortiss.af3.exploration.dseml.model.booleanp.Implies;
import org.fortiss.af3.exploration.dseml.model.booleanp.Or;
import org.fortiss.af3.exploration.dseml.model.booleanp.allocation.Allocation;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.LessEqual;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.NotEqual;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.dseml.model.expression.ModelElementLiteral;
import org.fortiss.af3.exploration.dseml.model.expression.Set;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.model.ExplorationConstraint;
import org.fortiss.af3.exploration.model.IExplorationConstraint;
import org.fortiss.af3.exploration.model.IProblemDimension;
import org.fortiss.af3.exploration.model.synthesiscategory.IDeploymentSynthesis;
import org.fortiss.af3.exploration.smt.util.ConstraintDefinitionUtils;
import org.fortiss.af3.exploration.util.DSMLModelElementFactory;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.exploration.util.ExplorationTimingConstraintUtils;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.IPlatformResource;
import org.fortiss.af3.platform.model.Route;
import org.fortiss.af3.platform.model.Segment;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.schedule.model.ResourceSchedule;
import org.fortiss.af3.schedule.model.Schedule;
import org.fortiss.af3.schedule.model.SystemSchedule;
import org.fortiss.af3.schedule.utils.ScheduleUtils;
import org.fortiss.af3.task.model.Signal;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskPort;
import org.fortiss.af3.task.model.allocation.ComponentToTaskAllocationEntry;
import org.fortiss.af3.task.model.allocation.SignalToRouteAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationEntry;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class BasicScheduleConstraint {
    public static List<IExplorationConstraint<?>> generatePureScheduleConstraints(SuperSet<ResourceAllocation> rsAllocSet, SuperSet<Task> tasks, SuperSet<ExecutionUnit> execUnits, SuperSet<ComponentToTaskAllocationEntry> co2taSet, SuperSet<TaskToExecutionUnitAllocationEntry> task2ecuSS, SuperSet<SignalToRouteAllocationEntry> s2r) {
        ArrayList constraints = new ArrayList();
        ArrayList<IBooleanExpression> assertions = new ArrayList<IBooleanExpression>();
        assertions.addAll(BasicScheduleConstraint.createPureSchedulingCausalityConstraints(rsAllocSet, co2taSet, s2r));
        assertions.addAll(BasicScheduleConstraint.createPureSchedulingNonOverlappingConstraints(rsAllocSet));
        if (task2ecuSS != null) {
            assertions.addAll(BasicScheduleConstraint.createFixedDeploymentConstraints(tasks, execUnits, task2ecuSS));
        }
        int i = 0;
        for (IBooleanExpression expr : assertions) {
            ExplorationConstraint ts = ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createTemporalDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)expr, (String)("Implicit Pure Scheduling Constraint " + i++), (boolean)true);
            constraints.add((IExplorationConstraint<?>)ts);
            UniqueIDUtils.prepareUniqueID((EObject)ts, tasks);
        }
        return constraints;
    }

    public static List<IBooleanExpression> createFixedDeploymentConstraints(SuperSet<Task> taskSS, SuperSet<ExecutionUnit> ecuSS, SuperSet<TaskToExecutionUnitAllocationEntry> ta2hw) {
        ArrayList<IBooleanExpression> assertions = new ArrayList<IBooleanExpression>();
        for (TaskToExecutionUnitAllocationEntry entry : ta2hw.getEntries()) {
            for (Task task : entry.getTasks()) {
                Set taskSet = DSMLModelElementFactory.createSet(taskSS, (String)"aTask", Task.class);
                taskSet.getEntries().add((Object)task);
                Set ecuSet = DSMLModelElementFactory.createSet(ecuSS, (String)"bECU", ExecutionUnit.class);
                ecuSet.getEntries().add((Object)entry.getExecutionUnit());
                ModelElementLiteral t = DSMLModelElementFactory.createModelElementLiteral((Set)taskSet);
                ModelElementLiteral e = DSMLModelElementFactory.createModelElementLiteral((Set)ecuSet);
                Allocation allocation = DSMLModelElementFactory.createAllocation((ModelElementLiteral)t, (ModelElementLiteral)e);
                ForAll forall = DSMLModelElementFactory.createForAll((Set)ecuSet, (IBooleanExpression)allocation, (boolean)true);
                ForAll formula = DSMLModelElementFactory.createForAll((Set)taskSet, (IBooleanExpression)forall, (boolean)true);
                assertions.add((IBooleanExpression)formula);
            }
        }
        return assertions;
    }

    public static List<IBooleanExpression> createPureSchedulingCausalityConstraints(SuperSet<ResourceAllocation> rsAllocSet, SuperSet<ComponentToTaskAllocationEntry> co2taSet, SuperSet<SignalToRouteAllocationEntry> s2r) {
        ArrayList<IBooleanExpression> assertions = new ArrayList<IBooleanExpression>();
        BasicScheduleConstraint.createPureSchedulingTransmissionUnitCausalityConstraints(rsAllocSet, co2taSet, s2r, assertions);
        BasicScheduleConstraint.createPureSchedulingSameECUCausalityConstraints(rsAllocSet, co2taSet, assertions);
        return assertions;
    }

    private static void createPureSchedulingSameECUCausalityConstraints(SuperSet<ResourceAllocation> rsAllocSet, SuperSet<ComponentToTaskAllocationEntry> co2taSet, List<IBooleanExpression> assertions) {
        for (ResourceAllocation ra : rsAllocSet.getEntries()) {
            IModelElement element = ra.getSchedulableEntity().getModelElement();
            if (!(element instanceof Task)) continue;
            Task sourceTask = (Task)element;
            ResourceAllocation raSource = BasicScheduleConstraint.getResourceAllocation(rsAllocSet, sourceTask);
            for (TaskPort stp : sourceTask.getTaskPorts()) {
                for (Signal signal : stp.getOutGoingSignals()) {
                    LessEqual lessEqual;
                    Task targetTask = signal.getTargetTaskPort().getTask();
                    ResourceAllocation raTarget = BasicScheduleConstraint.getResourceAllocation(rsAllocSet, targetTask);
                    if (raTarget == null || ra.getResource() != null && raTarget.getResource() == raSource.getResource()) continue;
                    Set dest = DSMLModelElementFactory.createSet(rsAllocSet, (String)"destinationResourceAllocation", ResourceAllocation.class);
                    dest.getEntries().add((Object)raTarget);
                    Set source = DSMLModelElementFactory.createSet(rsAllocSet, (String)"sourceResourceAllocation", ResourceAllocation.class);
                    source.getEntries().add((Object)raSource);
                    ArithmeticPropertyLiteral destStart = ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)dest);
                    ArithmeticPropertyLiteral sourceStart = ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)source);
                    if (!ConstraintDefinitionUtils.isStronglyCausal(sourceTask, co2taSet)) {
                        ArithmeticPropertyLiteral sourceDuration = ExplorationTimingConstraintUtils.createDurationLiteral((Set)source);
                        Plus sourceEnd = DSMLModelElementFactory.createPlus((IArithmeticExpression)sourceStart, (IArithmeticExpression)sourceDuration);
                        lessEqual = DSMLModelElementFactory.createLessEqual((IArithmeticExpression)sourceEnd, (IArithmeticExpression)destStart);
                    } else {
                        lessEqual = DSMLModelElementFactory.createLessEqual((IArithmeticExpression)destStart, (IArithmeticExpression)sourceStart);
                    }
                    ForAll forAllSource = DSMLModelElementFactory.createForAll((Set)source, (IBooleanExpression)lessEqual, (boolean)true);
                    ForAll formula = DSMLModelElementFactory.createForAll((Set)dest, (IBooleanExpression)forAllSource, (boolean)true);
                    assertions.add((IBooleanExpression)formula);
                }
            }
        }
    }

    private static ResourceAllocation getResourceAllocation(SuperSet<ResourceAllocation> raSet, Task task) {
        return (ResourceAllocation)LambdaUtils.getFirst((Collection)raSet.getEntries(), r -> r.getSchedulableEntity().getModelElement() == task).get();
    }

    public static List<IBooleanExpression> createPureSchedulingNonOverlappingConstraints(SuperSet<ResourceAllocation> resAllocSS) {
        ArrayList<IBooleanExpression> assertions = new ArrayList<IBooleanExpression>();
        HashSet<IPlatformResource> alreadyChecked = new HashSet<IPlatformResource>();
        HashMultimap res2resAlloc = HashMultimap.create();
        resAllocSS.getEntries().forEach(arg_0 -> BasicScheduleConstraint.lambda$1((Multimap)res2resAlloc, arg_0));
        for (ResourceAllocation ra : resAllocSS.getEntries()) {
            IPlatformResource resource = ra.getPhysicalResource();
            if (alreadyChecked.contains(resource)) continue;
            alreadyChecked.add(resource);
            Collection raList = res2resAlloc.get((Object)resource);
            Set raSet1 = DSMLModelElementFactory.createSet(resAllocSS, (Collection)raList, (String)"aResourceAllocation", ResourceAllocation.class);
            Set raSet2 = DSMLModelElementFactory.createSet(resAllocSS, (Collection)raList, (String)"bResourceAllocation", ResourceAllocation.class);
            ArithmeticPropertyLiteral startSet1 = ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)raSet1);
            ArithmeticPropertyLiteral startSet2 = ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)raSet2);
            ArithmeticPropertyLiteral durationSet1 = ExplorationTimingConstraintUtils.createDurationLiteral((Set)raSet1);
            ArithmeticPropertyLiteral durationSet2 = ExplorationTimingConstraintUtils.createDurationLiteral((Set)raSet2);
            Plus endSet1 = DSMLModelElementFactory.createPlus((IArithmeticExpression)startSet1, (IArithmeticExpression)durationSet1);
            Plus endSet2 = DSMLModelElementFactory.createPlus((IArithmeticExpression)startSet2, (IArithmeticExpression)durationSet2);
            ArithmeticPropertyLiteral startSet11 = ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)raSet1);
            ArithmeticPropertyLiteral startSet22 = ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)raSet2);
            LessEqual cond1 = DSMLModelElementFactory.createLessEqual((IArithmeticExpression)endSet1, (IArithmeticExpression)startSet22);
            LessEqual cond2 = DSMLModelElementFactory.createLessEqual((IArithmeticExpression)endSet2, (IArithmeticExpression)startSet11);
            Or or = DSMLModelElementFactory.createOr((IBooleanExpression)cond1, (IBooleanExpression)cond2);
            ModelElementLiteral element1 = DSMLModelElementFactory.createModelElementLiteral((Set)raSet1);
            ModelElementLiteral element2 = DSMLModelElementFactory.createModelElementLiteral((Set)raSet2);
            NotEqual predicate = DSMLModelElementFactory.createNotEqual((IExpression)element1, (IExpression)element2);
            Implies implies = DSMLModelElementFactory.createImplies((IBooleanExpression)predicate, (IBooleanExpression)or);
            ForAll forAll2 = DSMLModelElementFactory.createForAll((Set)raSet2.getCastedSet(IModelElement.class), (IBooleanExpression)implies, (boolean)true);
            ForAll forAll1 = DSMLModelElementFactory.createForAll((Set)raSet1, (IBooleanExpression)forAll2, (boolean)true);
            assertions.add((IBooleanExpression)forAll1);
        }
        return assertions;
    }

    private static ResourceAllocation getNextSegmentResourceAllocation(Schedule schedule, Segment segment, Map<Segment, List<ResourceAllocation>> seg2RaMap) {
        if (schedule == null) {
            return null;
        }
        List<Object> raList = seg2RaMap.get(segment);
        if (raList == null) {
            raList = schedule.getResourceAllocationList().stream().filter(r -> r.getSchedulableEntity().getModelElement() == segment).collect(Collectors.toList());
            seg2RaMap.put(segment, raList);
        }
        return !raList.isEmpty() ? raList.remove(0) : null;
    }

    private static void createPureSchedulingTransmissionUnitCausalityConstraints(SuperSet<ResourceAllocation> rsAllocSet, SuperSet<ComponentToTaskAllocationEntry> co2taSet, SuperSet<SignalToRouteAllocationEntry> s2r, List<IBooleanExpression> assertions) {
        HashSet<Signal> processedSignals = new HashSet<Signal>();
        HashMap<Segment, List<ResourceAllocation>> seg2RaMap = new HashMap<Segment, List<ResourceAllocation>>();
        for (ResourceAllocation ra : rsAllocSet.getEntries()) {
            IModelElement entity = ra.getSchedulableEntity().getModelElement();
            if (!(entity instanceof Segment)) continue;
            Route route = ((Segment)entity).getRoute();
            for (Signal signal : BasicScheduleConstraint.getSignals(s2r, route)) {
                Plus sourceTaskEnd;
                IPlatformResource targetECU;
                IPlatformResource sourceECU;
                if (processedSignals.contains(signal)) continue;
                processedSignals.add(signal);
                Task sourceTask = signal.getSourceTaskPort().getTask();
                ResourceAllocation sourceTaskRa = BasicScheduleConstraint.getResourceAllocation(rsAllocSet, sourceTask);
                Task targetTask = signal.getTargetTaskPort().getTask();
                ResourceAllocation targetTaskRa = BasicScheduleConstraint.getResourceAllocation(rsAllocSet, targetTask);
                if (targetTaskRa == null || (sourceECU = sourceTaskRa.getResource()) == (targetECU = targetTaskRa.getResource()) || ConstraintDefinitionUtils.isStronglyCausal(sourceTask, co2taSet) && ConstraintDefinitionUtils.isStronglyCausal(targetTask, co2taSet)) continue;
                ForAll sourceTaskForAll = DSMLModelElementFactory.createForAll();
                sourceTaskForAll.setUnfold(true);
                Set sourceTaskSet = DSMLModelElementFactory.createSet(rsAllocSet, (String)"sourceTaskResourceAllocation", ResourceAllocation.class);
                sourceTaskSet.getEntries().add((Object)sourceTaskRa);
                sourceTaskForAll.setSet(sourceTaskSet.getCastedSet(IModelElement.class));
                ArithmeticPropertyLiteral sourceTaskStart = ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)sourceTaskSet);
                ArithmeticPropertyLiteral sourceTaskDuration = ExplorationTimingConstraintUtils.createDurationLiteral((Set)sourceTaskSet);
                Plus lastEnd = sourceTaskEnd = DSMLModelElementFactory.createPlus((IArithmeticExpression)sourceTaskStart, (IArithmeticExpression)sourceTaskDuration);
                ForAll lastForAll = sourceTaskForAll;
                Segment segment = route.getRootSegment();
                int i = 0;
                ArrayList<LessEqual> lessEqualList = new ArrayList<LessEqual>();
                SystemSchedule schedule = (SystemSchedule)KernelModelElementUtils.getParentElement((EObject)sourceTaskRa, SystemSchedule.class, (boolean)false);
                do {
                    Plus signalEnd;
                    IModelElement element = segment.getEntity();
                    ResourceSchedule resourceSchedule = ScheduleUtils.getResourceSchedule((SystemSchedule)schedule, (IPlatformResource)((IPlatformResource)element));
                    ResourceAllocation sourceTaskPortRa = BasicScheduleConstraint.getNextSegmentResourceAllocation((Schedule)resourceSchedule, segment, seg2RaMap);
                    if (element == targetECU) {
                        ForAll destTaskForAll = DSMLModelElementFactory.createForAll();
                        destTaskForAll.setUnfold(true);
                        lastForAll.setExpression((IBooleanExpression)destTaskForAll);
                        Set destTaskSet = DSMLModelElementFactory.createSet(rsAllocSet, (String)"destinationTaskResourceAllocation", ResourceAllocation.class);
                        destTaskSet.getEntries().add((Object)targetTaskRa);
                        destTaskForAll.setSet(destTaskSet.getCastedSet(IModelElement.class));
                        ArithmeticPropertyLiteral destTaskStart = ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)destTaskSet);
                        LessEqual lessEqualDest = DSMLModelElementFactory.createLessEqual((IArithmeticExpression)lastEnd, (IArithmeticExpression)destTaskStart);
                        IBooleanExpression leq = (IBooleanExpression)lessEqualList.remove(0);
                        And and = DSMLModelElementFactory.createAnd((IBooleanExpression)lessEqualDest, (IBooleanExpression)leq);
                        while (!lessEqualList.isEmpty()) {
                            leq = (IBooleanExpression)lessEqualList.remove(0);
                            and = DSMLModelElementFactory.createAnd((IBooleanExpression)and, (IBooleanExpression)leq);
                        }
                        destTaskForAll.setExpression((IBooleanExpression)and);
                        continue;
                    }
                    if (sourceTaskPortRa == null) continue;
                    ForAll forAllSignal = DSMLModelElementFactory.createForAll();
                    forAllSignal.setUnfold(true);
                    lastForAll.setExpression((IBooleanExpression)forAllSignal);
                    lastForAll = forAllSignal;
                    Set setSignal = DSMLModelElementFactory.createSet(rsAllocSet, (String)("signalResourceAllocation" + i++), ResourceAllocation.class);
                    setSignal.getEntries().add((Object)sourceTaskPortRa);
                    forAllSignal.setSet(setSignal.getCastedSet(IModelElement.class));
                    ArithmeticPropertyLiteral signalStart = ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)setSignal);
                    Object lessEqual = ConstraintDefinitionUtils.isStronglyCausal(sourceTask, co2taSet) && segment.getParentSegment() == route.getRootSegment() ? DSMLModelElementFactory.createBooleanLiteral((boolean)true) : DSMLModelElementFactory.createLessEqual((IArithmeticExpression)lastEnd, (IArithmeticExpression)signalStart);
                    lessEqualList.add((LessEqual)lessEqual);
                    ArithmeticPropertyLiteral signalDuration = ExplorationTimingConstraintUtils.createDurationLiteral((Set)setSignal);
                    ArithmeticPropertyLiteral signalStart2 = ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)setSignal);
                    lastEnd = signalEnd = DSMLModelElementFactory.createPlus((IArithmeticExpression)signalStart2, (IArithmeticExpression)signalDuration);
                } while ((segment = !segment.getNext().isEmpty() ? (Segment)segment.getNext().get(0) : null) != null);
                assertions.add((IBooleanExpression)sourceTaskForAll);
            }
        }
    }

    private static List<Signal> getSignals(SuperSet<SignalToRouteAllocationEntry> s2r, Route route) {
        return s2r.getEntries().stream().filter(e -> e.getRoute() == route).flatMap(e -> e.getSignals().stream()).collect(Collectors.toList());
    }

    private static /* synthetic */ void lambda$1(Multimap multimap, ResourceAllocation rA) {
        boolean bl = multimap.put((Object)rA.getPhysicalResource(), (Object)rA);
    }
}

