/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.smt.modeltransformation;

import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Z3Exception;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.activation.UnsupportedDataTypeException;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.dseml.model.expression.Set;
import org.fortiss.af3.exploration.smt.modeltransformation.ExpressionTransformator;
import org.fortiss.af3.exploration.smt.modeltransformation.IDSMLTransformationService;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class ConstraintTransformationAdapter {
    private Context context;
    private IDSMLTransformationService transformationService;
    private List<ExpressionTransformator> constraintTransformators;

    public ConstraintTransformationAdapter(Context context, IDSMLTransformationService transformationService, List<Class<? extends ExpressionTransformator>> transformatorClasses) {
        this.context = context;
        this.transformationService = transformationService;
        this.constraintTransformators = new ArrayList<ExpressionTransformator>();
        for (Class<? extends ExpressionTransformator> transformatorClass : transformatorClasses) {
            ExpressionTransformator transformatorInstance = null;
            try {
                transformatorInstance = transformatorClass.getDeclaredConstructor(this.getClass()).newInstance(this);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
            this.constraintTransformators.add(transformatorInstance);
        }
    }

    public Expr transform(IExpression expression, Map<Set<IModelElement>, IModelElement> modelElements) throws UnsupportedDataTypeException, Z3Exception {
        ExpressionTransformator transformator = (ExpressionTransformator)EcoreUtils.pickFirstInstanceOf(t -> t.isApplicableTo(expression), this.constraintTransformators);
        if (transformator == null) {
            throw new UnsupportedOperationException("No registered constraint transformator is applicable to the following expression: " + String.valueOf(expression));
        }
        return transformator.transform(expression, modelElements);
    }

    public Context getContext() {
        return this.context;
    }

    public IDSMLTransformationService getTransformationService() {
        return this.transformationService;
    }
}

