/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.smt.modeltransformation;

import com.microsoft.z3.ArithExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.EnumSort;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Symbol;
import com.microsoft.z3.Z3javaAPIWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.exploration.dseml.model.arithmetic.ArithmeticPropertyLiteral;
import org.fortiss.af3.exploration.dseml.model.expression.Set;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.dseml.model.function.AllocationType;
import org.fortiss.af3.exploration.dseml.model.function.Deploy;
import org.fortiss.af3.exploration.dseml.model.function.End;
import org.fortiss.af3.exploration.dseml.model.function.IsTask;
import org.fortiss.af3.exploration.dseml.model.function.MasterActive;
import org.fortiss.af3.exploration.dseml.model.function.MaxTime;
import org.fortiss.af3.exploration.dseml.model.function.ScheduledSignal;
import org.fortiss.af3.exploration.dseml.model.function.ScheduledTask;
import org.fortiss.af3.exploration.dseml.model.function.Start;
import org.fortiss.af3.exploration.dseml.model.function.StronglyCausal;
import org.fortiss.af3.exploration.dseml.model.function.Uses;
import org.fortiss.af3.exploration.dseml.model.function.Weight;
import org.fortiss.af3.exploration.model.SuperSetMap;
import org.fortiss.af3.exploration.smt.model.dseml.FrequencyAssigned;
import org.fortiss.af3.exploration.smt.modeltransformation.IDSMLTransformationService;
import org.fortiss.af3.exploration.smt.util.SMTTransformationUtils;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.FailureScenario;
import org.fortiss.af3.platform.model.Route;
import org.fortiss.af3.platform.model.TransmissionUnit;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.task.model.Signal;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.allocation.SignalToRouteAllocationEntry;
import org.fortiss.tooling.base.model.element.IModelElement;

public class DSMLTransformationService
implements IDSMLTransformationService {
    private Map<Set<? extends IModelElement>, EnumSort> existingSorts = new HashMap<Set<? extends IModelElement>, EnumSort>();
    private Map<EnumSort, Expr> existingSymbols = new HashMap<EnumSort, Expr>();
    private Map<IModelElement, Expr> existingInstances = new HashMap<IModelElement, Expr>();
    private Map<EnumSort, Map<EnumSort, FuncDecl>> allocations = new HashMap<EnumSort, Map<EnumSort, FuncDecl>>();
    private Context context;
    private Map<Set<?>, Expr> setRefToZ3Symbol = new HashMap();
    private static int I = 0;

    public DSMLTransformationService(SuperSetMap superSets, Context context) {
        this.context = context;
        this.extractSuperSet(context, superSets.get(ResourceAllocation.class));
        this.extractSuperSet(context, superSets.get(Task.class));
        this.extractSuperSet(context, superSets.get(Signal.class));
        this.extractSuperSet(context, superSets.get(ExecutionUnit.class));
        this.extractSuperSet(context, superSets.get(Route.class));
        this.extractSuperSet(context, superSets.get(SignalToRouteAllocationEntry.class));
        this.extractSuperSet(context, superSets.get(TransmissionUnit.class));
        this.extractSuperSet(context, superSets.get(FailureScenario.class));
    }

    @Override
    public Map<IModelElement, Expr> getExistingInstances() {
        return this.existingInstances;
    }

    private <T extends IModelElement> void extractSuperSet(Context context, SuperSet<T> s) {
        if (s == null) {
            return;
        }
        EList entries = s.getEntries();
        ArrayList<Symbol> symbols = new ArrayList<Symbol>();
        if (entries.isEmpty()) {
            return;
        }
        Symbol type = Z3javaAPIWrapper.createSymbol((Context)context, (String)((IModelElement)entries.get(0)).getClass().getSimpleName());
        for (IModelElement m : entries) {
            Symbol symbol = SMTTransformationUtils.createSymbol(context, m);
            symbols.add(symbol);
        }
        Symbol[] array = symbols.toArray(new Symbol[0]);
        EnumSort sort = Z3javaAPIWrapper.createEnumSort((Context)context, (Symbol)type, (Symbol[])array);
        this.addExistingSort((Set<T>)s, sort);
        Expr[] exprArray = sort.getConsts();
        int n = exprArray.length;
        int n2 = 0;
        while (n2 < n) {
            Expr expr = exprArray[n2];
            boolean added = false;
            for (IModelElement m : entries) {
                String name = SMTTransformationUtils.createUniqueASCIIModelName(m);
                if (!expr.toString().equals(name)) continue;
                this.addExistingInstance(m, expr);
                added = true;
                break;
            }
            if (!added) {
                throw new RuntimeException("Failed to register EnumSort \"" + String.valueOf(expr) + "\".");
            }
            ++n2;
        }
        String setName = s.getName();
        setName = setName != null && setName.length() > 0 ? setName.substring(0, 1).toLowerCase() : "x";
        Expr elementOfSort = context.mkConst(setName, (Sort)sort);
        this.addExistingSymbol(sort, elementOfSort);
    }

    private ArithExpr getZ3FunctionForModelElement(Context context, IModelElement modelElement, String name, EnumSort inputSort, Sort outputSort) {
        FuncDecl function = Z3javaAPIWrapper.createFunction((Context)context, (String)name, (Sort)inputSort, (Sort)outputSort);
        Expr[] exprArray = inputSort.getConsts();
        int n = exprArray.length;
        int n2 = 0;
        while (n2 < n) {
            Expr element = exprArray[n2];
            if (element.equals((Object)this.existingInstances.get(modelElement))) {
                return (ArithExpr)function.apply(new Expr[]{element});
            }
            ++n2;
        }
        return null;
    }

    @Override
    public ArithExpr getZ3Function(ArithmeticPropertyLiteral<? extends IModelElement, Number> arithExpr, IModelElement model, Sort outputSort) {
        String name = SMTTransformationUtils.getFunctionName(arithExpr);
        return this.getZ3FunctionForModelElement(this.context, model, name, this.getSort(model), outputSort);
    }

    @Override
    public FuncDecl getZ3FunctionDecl(Start start) {
        String name = "f_start";
        Set setReference = start.getArgs().getSetReference();
        EnumSort sort = this.searchForReferringZ3Set(setReference);
        EnumSort returnSort = this.searchForReferringZ3Set(start.getSetReference());
        FuncDecl function = Z3javaAPIWrapper.createFunction((Context)this.context, (String)name, (Sort)sort, (Sort)returnSort);
        return function;
    }

    @Override
    public FuncDecl getZ3FunctionDecl(Uses uses) {
        String name = "f_uses";
        Set arg0In = uses.getArg0().getSetReference();
        EnumSort sort0 = this.searchForReferringZ3Set(arg0In);
        Set arg1In = uses.getArg1().getSetReference();
        EnumSort sort1 = this.searchForReferringZ3Set(arg1In);
        FuncDecl function = Z3javaAPIWrapper.createFunction((Context)this.context, (String)name, (Sort[])new Sort[]{sort0, sort1}, (Sort)this.context.getBoolSort());
        return function;
    }

    @Override
    public FuncDecl getZ3FunctionDecl(StronglyCausal strc) {
        String name = "f_str_caus";
        Set arg0In = strc.getArg0().getSetReference();
        EnumSort sort0 = this.searchForReferringZ3Set(arg0In);
        FuncDecl function = Z3javaAPIWrapper.createFunction((Context)this.context, (String)name, (Sort[])new Sort[]{sort0}, (Sort)this.context.getBoolSort());
        return function;
    }

    @Override
    public FuncDecl getZ3FunctionDecl(IsTask isTask) {
        String name = "f_isTask";
        Set arg0In = isTask.getArg0().getSetReference();
        EnumSort sort0 = this.searchForReferringZ3Set(arg0In);
        FuncDecl function = Z3javaAPIWrapper.createFunction((Context)this.context, (String)name, (Sort[])new Sort[]{sort0}, (Sort)this.context.getBoolSort());
        return function;
    }

    @Override
    public Expr getZ3Function(StronglyCausal strc) {
        Set set0Reference = strc.getArg0().getSetReference();
        Expr element0 = this.getZ3SetSymbol(set0Reference);
        return this.getZ3FunctionDecl(strc).apply(new Expr[]{element0});
    }

    @Override
    public Expr getZ3Function(IsTask isTask) {
        Set set0Reference = isTask.getArg0().getSetReference();
        Expr element0 = this.getZ3SetSymbol(set0Reference);
        return this.getZ3FunctionDecl(isTask).apply(new Expr[]{element0});
    }

    @Override
    public FuncDecl getZ3FunctionDecl(Weight uses) {
        String name = "f_weight";
        Set setReference = uses.getArg0().getSetReference();
        EnumSort sort = this.searchForReferringZ3Set(setReference);
        FuncDecl function = Z3javaAPIWrapper.createFunction((Context)this.context, (String)name, (Sort)sort, (Sort)this.context.getRealSort());
        return function;
    }

    @Override
    public FuncDecl getZ3FunctionDecl(FrequencyAssigned frequency) {
        String name = "f_frequency";
        Set setReference = frequency.getArg0().getSetReference();
        EnumSort sort = this.searchForReferringZ3Set(setReference);
        FuncDecl function = Z3javaAPIWrapper.createFunction((Context)this.context, (String)name, (Sort)sort, (Sort)this.context.getRealSort());
        return function;
    }

    @Override
    public Expr getZ3FunctionDecl(MaxTime time) {
        String name = "f_max_time";
        Expr function = Z3javaAPIWrapper.createFunction((Context)this.context, (String)name, (Sort)this.context.getRealSort());
        return function;
    }

    @Override
    public FuncDecl getZ3FunctionDecl(MasterActive masterActive) {
        String name = "f_masterActive";
        Set taskIn = masterActive.getTask().getSetReference();
        EnumSort sortTask = this.searchForReferringZ3Set(taskIn);
        Set fsIn = masterActive.getFs().getSetReference();
        EnumSort sortFs = this.searchForReferringZ3Set(fsIn);
        FuncDecl function = Z3javaAPIWrapper.createFunction((Context)this.context, (String)name, (Sort[])new Sort[]{sortTask, sortFs}, (Sort)this.context.getBoolSort());
        return function;
    }

    @Override
    public FuncDecl getZ3FunctionDecl(Deploy deploy) {
        String name = "f_Deploy";
        Set taskIn = deploy.getTask().getSetReference();
        EnumSort sortTask = this.searchForReferringZ3Set(taskIn);
        Set ecuIn = deploy.getEcu().getSetReference();
        EnumSort sortEcu = this.searchForReferringZ3Set(ecuIn);
        Set fsIn = deploy.getFs().getSetReference();
        EnumSort sortFs = this.searchForReferringZ3Set(fsIn);
        FuncDecl function = Z3javaAPIWrapper.createFunction((Context)this.context, (String)name, (Sort[])new Sort[]{sortTask, sortEcu, sortFs}, (Sort)this.context.getIntSort());
        return function;
    }

    @Override
    public FuncDecl getZ3FunctionDecl(ScheduledSignal elem) {
        String name = "f_sched_signal";
        Set setReference = elem.getArgs().getSetReference();
        EnumSort sort = this.searchForReferringZ3Set(setReference);
        EnumSort returnSort = this.searchForReferringZ3Set(elem.getSetReference());
        FuncDecl function = Z3javaAPIWrapper.createFunction((Context)this.context, (String)name, (Sort)sort, (Sort)returnSort);
        return function;
    }

    @Override
    public FuncDecl getZ3FunctionDecl(ScheduledTask elem) {
        String name = "f_sched_task";
        Set setReference = elem.getArgs().getSetReference();
        EnumSort sort = this.searchForReferringZ3Set(setReference);
        EnumSort returnSort = this.searchForReferringZ3Set(elem.getSetReference());
        FuncDecl function = Z3javaAPIWrapper.createFunction((Context)this.context, (String)name, (Sort)sort, (Sort)returnSort);
        return function;
    }

    @Override
    public Expr getZ3Function(Weight uses) {
        String name = "f_weight";
        Set setReference = uses.getArg0().getSetReference();
        EnumSort sort = this.searchForReferringZ3Set(setReference);
        Expr element = this.getZ3SetSymbol(setReference);
        FuncDecl function = Z3javaAPIWrapper.createFunction((Context)this.context, (String)name, (Sort)sort, (Sort)this.context.getRealSort());
        return function.apply(new Expr[]{element});
    }

    @Override
    public Expr getZ3Function(FrequencyAssigned frequency) {
        String name = "f_frequency";
        Set setReference = frequency.getArg0().getSetReference();
        EnumSort sort = this.searchForReferringZ3Set(setReference);
        Expr element = this.getZ3SetSymbol(setReference);
        FuncDecl function = Z3javaAPIWrapper.createFunction((Context)this.context, (String)name, (Sort)sort, (Sort)this.context.getRealSort());
        return function.apply(new Expr[]{element});
    }

    @Override
    public Expr getZ3Function(MaxTime time) {
        String name = "f_max_time";
        Expr function = Z3javaAPIWrapper.createFunction((Context)this.context, (String)name, (Sort)this.context.getRealSort());
        return function;
    }

    @Override
    public Expr getZ3Function(AllocationType at) {
        String name = "f_allocation_type";
        Expr function = Z3javaAPIWrapper.createFunction((Context)this.context, (String)name, (Sort)this.context.getIntSort());
        return function;
    }

    @Override
    public Expr getZ3Function(MasterActive masterActive) {
        String name = "f_masterActive";
        Set taskIn = masterActive.getTask().getSetReference();
        EnumSort sortTask = this.searchForReferringZ3Set(taskIn);
        Expr task = this.getZ3SetSymbol(taskIn);
        Set fsIn = masterActive.getFs().getSetReference();
        EnumSort sortFs = this.searchForReferringZ3Set(fsIn);
        Expr fs = this.getZ3SetSymbol(fsIn);
        FuncDecl function = Z3javaAPIWrapper.createFunction((Context)this.context, (String)name, (Sort[])new Sort[]{sortTask, sortFs}, (Sort)this.context.getBoolSort());
        return function.apply(new Expr[]{task, fs});
    }

    @Override
    public Expr getZ3Function(Deploy deploy) {
        String name = "f_Deploy";
        Set taskIn = deploy.getTask().getSetReference();
        EnumSort sortTask = this.searchForReferringZ3Set(taskIn);
        Expr task = this.getZ3SetSymbol(taskIn);
        Set fsIn = deploy.getFs().getSetReference();
        EnumSort sortFs = this.searchForReferringZ3Set(fsIn);
        Expr fs = this.getZ3SetSymbol(fsIn);
        Set ecuIn = deploy.getEcu().getSetReference();
        EnumSort sortEcu = this.searchForReferringZ3Set(ecuIn);
        Expr ecu = this.getZ3SetSymbol(ecuIn);
        FuncDecl function = Z3javaAPIWrapper.createFunction((Context)this.context, (String)name, (Sort[])new Sort[]{sortTask, sortEcu, sortFs}, (Sort)this.context.getIntSort());
        return function.apply(new Expr[]{task, fs, ecu});
    }

    private EnumSort searchForReferringZ3Set(Set<?> setReference) {
        EnumSort sort = this.existingSorts.get(setReference);
        if (sort == null) {
            for (Map.Entry<Set<? extends IModelElement>, EnumSort> e : this.existingSorts.entrySet()) {
                if (!e.getKey().getEntries().containsAll((Collection)setReference.getEntries())) continue;
                sort = e.getValue();
                break;
            }
        }
        return sort;
    }

    @Override
    public Expr getZ3Function(Start start) {
        Set setReference = start.getArgs().getSetReference();
        Expr element = this.getZ3SetSymbol(setReference);
        return this.getZ3FunctionDecl(start).apply(new Expr[]{element});
    }

    @Override
    public Expr getZ3Function(ScheduledSignal elem) {
        Set setReference = elem.getArgs().getSetReference();
        Expr element = this.getZ3SetSymbol(setReference);
        return this.getZ3FunctionDecl(elem).apply(new Expr[]{element});
    }

    @Override
    public Expr getZ3Function(ScheduledTask elem) {
        Set setReference = elem.getArgs().getSetReference();
        Expr element = this.getZ3SetSymbol(setReference);
        return this.getZ3FunctionDecl(elem).apply(new Expr[]{element});
    }

    @Override
    public FuncDecl getZ3FunctionDecl(End end) {
        String name = "f_end";
        Set setReference = end.getArgs().getSetReference();
        EnumSort sort = this.searchForReferringZ3Set(setReference);
        EnumSort returnSort = this.searchForReferringZ3Set(end.getSetReference());
        FuncDecl function = Z3javaAPIWrapper.createFunction((Context)this.context, (String)name, (Sort)sort, (Sort)returnSort);
        return function;
    }

    @Override
    public Expr getZ3Function(End end) {
        Set setReference = end.getArgs().getSetReference();
        Expr element = this.getZ3SetSymbol(setReference);
        return this.getZ3FunctionDecl(end).apply(new Expr[]{element});
    }

    @Override
    public EnumSort getSort(Set<?> set) {
        EnumSort sort = this.existingSorts.get(set);
        if (sort != null) {
            return sort;
        }
        for (Map.Entry<Set<? extends IModelElement>, EnumSort> e : this.existingSorts.entrySet()) {
            if (!e.getKey().getEntries().containsAll((Collection)set.getEntries())) continue;
            return e.getValue();
        }
        return null;
    }

    @Override
    public EnumSort getSort(IModelElement element) {
        for (Map.Entry<Set<? extends IModelElement>, EnumSort> e : this.existingSorts.entrySet()) {
            if (!e.getKey().getEntries().contains((Object)element)) continue;
            return e.getValue();
        }
        return null;
    }

    @Override
    public IModelElement resolveAllocation(Expr expr) {
        java.util.Set<Map.Entry<Set<? extends IModelElement>, EnumSort>> entrySet = this.existingSorts.entrySet();
        for (Map.Entry<Set<? extends IModelElement>, EnumSort> e : entrySet) {
            Expr[] exprArray = e.getValue().getConsts();
            int n = exprArray.length;
            int n2 = 0;
            while (n2 < n) {
                Expr element = exprArray[n2];
                if (expr.toString().equals(element.toString()) || expr.toString().equals("|" + element.toString() + "|")) {
                    Predicate<IModelElement> namePred = me -> {
                        String uName = SMTTransformationUtils.createUniqueASCIIModelName(me);
                        return element.toString().equals(uName) || element.toString().equals("|" + uName + "|");
                    };
                    EList entries = e.getKey().getEntries();
                    Stream<IModelElement> filter = entries.stream().filter(namePred);
                    return filter.findFirst().orElse(null);
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public List<EnumSort> getLeftSidesOfAllocations() {
        ArrayList<EnumSort> lists = new ArrayList<EnumSort>();
        this.allocations.entrySet().stream().forEach(f -> {
            boolean bl = lists.add((EnumSort)f.getKey());
        });
        return lists;
    }

    @Override
    public FuncDecl getFunctionForLeftSideType(EnumSort leftSort) {
        java.util.Set<Map.Entry<EnumSort, FuncDecl>> entrySet = this.allocations.get(leftSort).entrySet();
        Map.Entry entry = (Map.Entry)entrySet.stream().findFirst().get();
        return (FuncDecl)entry.getValue();
    }

    @Override
    public FuncDecl getAllocFunctionForLeftSideType(IModelElement leftSort) {
        for (Map.Entry<Set<? extends IModelElement>, EnumSort> e : this.existingSorts.entrySet()) {
            if (!e.getKey().getEntries().contains((Object)leftSort)) continue;
            return this.getFunctionForLeftSideType(e.getValue());
        }
        return null;
    }

    @Override
    public Map<Set<? extends IModelElement>, EnumSort> getExistingSorts() {
        return this.existingSorts;
    }

    @Override
    public Map<EnumSort, Expr> getExistingSymbols() {
        return this.existingSymbols;
    }

    @Override
    public Expr getModelElementInstance(IModelElement element) {
        if (element != null) {
            return this.existingInstances.get(element);
        }
        return null;
    }

    private <T extends IModelElement> void addExistingSort(Set<T> set, EnumSort sort) {
        this.existingSorts.put(set, sort);
    }

    private void addExistingSymbol(EnumSort sort, Expr expr) {
        this.existingSymbols.put(sort, expr);
    }

    private void addExistingInstance(IModelElement model, Expr expr) {
        this.existingInstances.put(model, expr);
    }

    @Override
    public Expr getZ3SetSymbol(Set<?> set) {
        Expr expr = this.setRefToZ3Symbol.get(set);
        if (expr != null) {
            return expr;
        }
        EnumSort sort = this.searchForReferringZ3Set(set);
        String name = set.getName() != null && !set.getName().isEmpty() ? set.getName().substring(0, 1).toLowerCase() + I++ : "x" + I++;
        expr = this.context.mkConst(name, (Sort)sort);
        this.setRefToZ3Symbol.put(set, expr);
        return expr;
    }

    @Override
    public FuncDecl getAllocateFunction(EnumSort leftSort, EnumSort rightSort) {
        FuncDecl funcDecl;
        Map<EnumSort, FuncDecl> map = this.allocations.get(leftSort);
        if (map != null && (funcDecl = map.get(rightSort)) != null) {
            return funcDecl;
        }
        FuncDecl allocate = Z3javaAPIWrapper.createFunction((Context)this.context, (String)"allocate", (Sort)leftSort, (Sort)rightSort);
        HashMap<EnumSort, FuncDecl> newMap = new HashMap<EnumSort, FuncDecl>();
        newMap.put(rightSort, allocate);
        this.allocations.put(leftSort, newMap);
        return allocate;
    }
}

