/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.smt.modeltransformation;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.microsoft.z3.ArithExpr;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.EnumSort;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.IntNum;
import com.microsoft.z3.Model;
import com.microsoft.z3.RatNum;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3javaAPIWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.activation.UnsupportedDataTypeException;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fortiss.af3.allocation.model.AllocationEntry;
import org.fortiss.af3.allocation.utils.AllocationModelElementFactory;
import org.fortiss.af3.exploration.dseml.model.arithmetic.ArithmeticPropertyLiteral;
import org.fortiss.af3.exploration.dseml.model.expression.ExpressionFactory;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.dseml.model.expression.ModelElementLiteral;
import org.fortiss.af3.exploration.dseml.model.expression.Set;
import org.fortiss.af3.exploration.dseml.model.function.AllocationTypeEnum;
import org.fortiss.af3.exploration.dseml.model.function.Deploy;
import org.fortiss.af3.exploration.dseml.model.function.Maximize;
import org.fortiss.af3.exploration.dseml.model.function.Minimize;
import org.fortiss.af3.exploration.model.ExplorationSpecification;
import org.fortiss.af3.exploration.model.IExplorationConstraint;
import org.fortiss.af3.exploration.model.IExplorationObjective;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.smt.AF3ExplorationSMTActivator;
import org.fortiss.af3.exploration.smt.model.dseml.FrequencyAssigned;
import org.fortiss.af3.exploration.smt.modeltransformation.ConstraintTransformationAdapter;
import org.fortiss.af3.exploration.smt.modeltransformation.DSMLTransformationService;
import org.fortiss.af3.exploration.smt.modeltransformation.DefaultExpressionTransformator;
import org.fortiss.af3.exploration.smt.modeltransformation.ExpressionTransformator;
import org.fortiss.af3.exploration.smt.modeltransformation.IDSMLTransformationService;
import org.fortiss.af3.exploration.smt.modeltransformation.NonQuantifiedExpressionTransformator;
import org.fortiss.af3.exploration.smt.modeltransformation.QuantifiedExpressionTransformator;
import org.fortiss.af3.exploration.smt.solver.ContextWrapper;
import org.fortiss.af3.exploration.smt.util.ConstraintDefinitionUtils;
import org.fortiss.af3.exploration.smt.util.SMTTransformationUtils;
import org.fortiss.af3.exploration.util.DSMLModelElementFactory;
import org.fortiss.af3.exploration.util.DSMLUtils;
import org.fortiss.af3.exploration.util.ExplorationUtils;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.FailureScenario;
import org.fortiss.af3.platform.model.IPlatformResource;
import org.fortiss.af3.platform.model.Route;
import org.fortiss.af3.schedule.model.PeriodicTimeTrigger;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.schedule.model.ResourceSchedule;
import org.fortiss.af3.schedule.utils.AF3ScheduleModelElementFactory;
import org.fortiss.af3.task.model.Signal;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskReplica;
import org.fortiss.af3.task.model.allocation.SignalToRouteAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskAllocationFactory;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationEntry;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class DSMLtoSMTTransformator {
    private ContextWrapper context;
    private ConstraintTransformationAdapter constraintTransformationAdapter;
    private IDSMLTransformationService transformationService;
    private final BiMap<IExplorationTarget<?>, Expr> expressionCache = HashBiMap.create();
    private final BiMap<IExplorationTarget<?>, Expr> transformedExpressions = HashBiMap.create();
    private final Collection<Expr> elementPropertyExpressions = new ArrayList<Expr>();
    private final Map<BoolExpr, Pair<BoolExpr, IExplorationConstraint<?>>> constraintsToTrack = new HashMap();
    private final List<ArithExpr> toMinimize = new ArrayList<ArithExpr>();
    private final List<ArithExpr> toMaximize = new ArrayList<ArithExpr>();

    public DSMLtoSMTTransformator(ContextWrapper context, ExplorationSpecification explorationSpec) {
        this.context = context;
        this.transform(explorationSpec);
    }

    private boolean transform(ExplorationSpecification explorationSpec) {
        block12: {
            this.transformedExpressions.clear();
            this.transformationService = new DSMLTransformationService(explorationSpec.getSearchSpace(), this.context);
            ArrayList<Class<? extends ExpressionTransformator>> transformatorClasses = new ArrayList<Class<? extends ExpressionTransformator>>();
            transformatorClasses.add(DefaultExpressionTransformator.class);
            transformatorClasses.add(QuantifiedExpressionTransformator.class);
            transformatorClasses.add(NonQuantifiedExpressionTransformator.class);
            this.constraintTransformationAdapter = new ConstraintTransformationAdapter(this.context, this.transformationService, transformatorClasses);
            for (IExplorationTarget explorationTgt : explorationSpec.getTargets()) {
                if (this.getAndTrySetExpression(explorationTgt)) continue;
                try {
                    if (explorationTgt instanceof IExplorationConstraint) {
                        IExplorationConstraint smtConstraint = (IExplorationConstraint)explorationTgt;
                        this.extractSMTExpr(smtConstraint);
                        continue;
                    }
                    if (!(explorationTgt instanceof IExplorationObjective)) continue;
                    IExplorationObjective smtObjective = (IExplorationObjective)explorationTgt;
                    for (IExplorationConstraint constraint : smtObjective.getImplicitConstraints()) {
                        this.extractSMTExpr(constraint);
                    }
                    IExpression expression = smtObjective.getExpression();
                    ArithExpr arithExpr = (ArithExpr)this.extractObjective(smtObjective);
                    if (expression instanceof Minimize) {
                        this.toMinimize.add(arithExpr);
                    } else if (expression instanceof Maximize) {
                        this.toMaximize.add(arithExpr);
                    } else {
                        throw new UnsupportedOperationException("The function " + expression.getClass().getSimpleName() + " is not yet supported");
                    }
                    this.addExpression((Expr)arithExpr, (IExplorationTarget<?>)smtObjective);
                }
                catch (Z3Exception | UnsupportedDataTypeException e) {
                    LoggingUtils.error((Plugin)AF3ExplorationSMTActivator.getDefault(), (String)e.getMessage());
                    return false;
                }
            }
            try {
                this.elementPropertyExpressions.addAll(this.extractConstants(explorationSpec, this.context));
            }
            catch (Z3Exception e) {
                LoggingUtils.error((Plugin)AF3ExplorationSMTActivator.getDefault(), (String)e.getMessage());
            }
            catch (UnsupportedDataTypeException e) {
                if (!ExplorationUtils.isDebugVerboseEnabled()) break block12;
                LoggingUtils.error((Plugin)AF3ExplorationSMTActivator.getDefault(), (String)e.getMessage());
            }
        }
        return true;
    }

    private void addExpression(Expr expression, IExplorationTarget<?> target) {
        if (this.expressionCache.inverse().get((Object)expression) == null) {
            this.expressionCache.put(target, (Object)expression);
            this.transformedExpressions.put(target, (Object)expression);
        }
    }

    private boolean getAndTrySetExpression(IExplorationTarget<?> target) {
        Expr translatedExpr = (Expr)this.expressionCache.get(target);
        if (translatedExpr != null) {
            this.transformedExpressions.put(target, (Object)translatedExpr);
            return true;
        }
        return false;
    }

    private Expr extractSMTExpr(IExplorationConstraint<?> constraint) throws UnsupportedDataTypeException, Z3Exception {
        Expr smt = this.constraintTransformationAdapter.transform(constraint.getExpression(), new HashMap<Set<IModelElement>, IModelElement>());
        if (this.context.isTrackConstraints() && !constraint.isImplicit()) {
            BoolExpr trackExpr = Z3javaAPIWrapper.createBoolConst((Context)this.getContext(), (String)("tracking_" + smt.getId()));
            this.constraintsToTrack.put((BoolExpr)smt, Pair.of((Object)trackExpr, constraint));
        }
        this.addExpression(smt, (IExplorationTarget<?>)constraint);
        return smt;
    }

    private Expr extractObjective(IExplorationObjective<?> objective) throws UnsupportedDataTypeException, Z3Exception {
        Expr smt;
        IExpression expression = objective.getExpression();
        if (expression instanceof Minimize) {
            smt = this.constraintTransformationAdapter.transform((IExpression)((Minimize)expression).getArgs(), new HashMap<Set<IModelElement>, IModelElement>());
        } else if (expression instanceof Maximize) {
            smt = this.constraintTransformationAdapter.transform((IExpression)((Maximize)expression).getArgs(), new HashMap<Set<IModelElement>, IModelElement>());
        } else {
            throw new UnsupportedOperationException("The function " + expression.getClass().getSimpleName() + " is not yet supported");
        }
        return smt;
    }

    public EList<ResourceAllocation> computeSchedule(Model model) {
        BasicEList resAllList = new BasicEList();
        FuncDecl startFun = this.getStartTimeDecl(model);
        FuncDecl durationFun = this.getDurationDecl(model);
        for (Map.Entry<IModelElement, Expr> m : this.transformationService.getExistingInstances().entrySet()) {
            if (!(m.getKey() instanceof ResourceAllocation)) continue;
            ResourceAllocation inResAlloc = (ResourceAllocation)m.getKey();
            Expr startExpr = startFun.apply(new Expr[]{m.getValue()});
            RatNum startNum = (RatNum)model.eval(startExpr, true);
            Expr durationExpr = durationFun.apply(new Expr[]{m.getValue()});
            RatNum durationNum = (RatNum)model.eval(durationExpr, true);
            ResourceAllocation outResAlloc = (ResourceAllocation)EcoreUtil.copy((EObject)inResAlloc);
            PeriodicTimeTrigger periodicTimeTrigger = (PeriodicTimeTrigger)outResAlloc.getTrigger();
            periodicTimeTrigger.setStartTime(SMTTransformationUtils.toDecimal(startNum));
            PeriodicTimeTrigger inputTrigger = (PeriodicTimeTrigger)inResAlloc.getTrigger();
            periodicTimeTrigger.setPeriod(inputTrigger.getPeriod());
            outResAlloc.setDuration(SMTTransformationUtils.toDecimal(durationNum));
            resAllList.add((Object)outResAlloc);
        }
        return resAllList;
    }

    public <T extends IModelElement> Collection<T> extractIntermediateElements(Class<T> type) {
        return LambdaUtils.filterByType(this.transformationService.getExistingInstances().keySet(), type);
    }

    private FuncDecl getStartTimeDecl(Model model) {
        FuncDecl[] funcDeclArray = model.getDecls();
        int n = funcDeclArray.length;
        int n2 = 0;
        while (n2 < n) {
            FuncDecl decl = funcDeclArray[n2];
            if (decl.getName().toString().equals(SMTTransformationUtils.getFunctionName("VAR_StartTime"))) {
                return decl;
            }
            ++n2;
        }
        return null;
    }

    private FuncDecl getDurationDecl(Model model) {
        FuncDecl[] funcDeclArray = model.getDecls();
        int n = funcDeclArray.length;
        int n2 = 0;
        while (n2 < n) {
            FuncDecl decl = funcDeclArray[n2];
            if (decl.getName().toString().equals(SMTTransformationUtils.getFunctionName("VAR_Duration"))) {
                return decl;
            }
            ++n2;
        }
        return null;
    }

    public Map<FailureScenario, Map<TaskToExecutionUnitAllocationEntry, AllocationTypeEnum>> computeRedundantAllocations(Model model) {
        ArrayList<Map.Entry<IModelElement, Expr>> taskList = new ArrayList<Map.Entry<IModelElement, Expr>>();
        ArrayList<Map.Entry<IModelElement, Expr>> ecuList = new ArrayList<Map.Entry<IModelElement, Expr>>();
        ArrayList<Map.Entry<IModelElement, Expr>> fsList = new ArrayList<Map.Entry<IModelElement, Expr>>();
        for (Map.Entry<IModelElement, Expr> instance : this.transformationService.getExistingInstances().entrySet()) {
            IModelElement modelElement = instance.getKey();
            if (modelElement instanceof Task) {
                if (EcoreUtils.pickFirstInstanceOf(TaskReplica.class, (List)modelElement.getSpecifications()) != null) continue;
                taskList.add(instance);
                continue;
            }
            if (modelElement instanceof ExecutionUnit) {
                ecuList.add(instance);
                continue;
            }
            if (!(modelElement instanceof FailureScenario)) continue;
            fsList.add(instance);
        }
        HashMap<FailureScenario, Map<TaskToExecutionUnitAllocationEntry, AllocationTypeEnum>> rval = new HashMap<FailureScenario, Map<TaskToExecutionUnitAllocationEntry, AllocationTypeEnum>>();
        for (Map.Entry entry : fsList) {
            for (Map.Entry entry2 : taskList) {
                for (Map.Entry entry3 : ecuList) {
                    int deployType = this.getDeploymentType(model, entry2, entry3, entry);
                    if (deployType == 2) continue;
                    IModelElement task = (IModelElement)entry2.getKey();
                    IModelElement ecu = (IModelElement)entry3.getKey();
                    IModelElement fs = (IModelElement)entry.getKey();
                    this.createRedundantAllocationEntry(rval, task, ecu, fs, deployType);
                }
            }
        }
        return rval;
    }

    private ModelElementLiteral createModelElementLiteral(Map.Entry<IModelElement, Expr> entry) {
        Set taskSet = ExpressionFactory.eINSTANCE.createSet();
        taskSet.getEntries().add((Object)entry.getKey());
        ModelElementLiteral taskLit = DSMLModelElementFactory.createModelElementLiteral((Set)taskSet);
        return taskLit;
    }

    private int getDeploymentType(Model model, Map.Entry<IModelElement, Expr> taskEntry, Map.Entry<IModelElement, Expr> ecuEntry, Map.Entry<IModelElement, Expr> fsEntry) {
        ModelElementLiteral fsLit;
        ModelElementLiteral ecuLit;
        ModelElementLiteral taskLit = this.createModelElementLiteral(taskEntry);
        Deploy deploy = DSMLModelElementFactory.createDeploy((ModelElementLiteral)taskLit, (ModelElementLiteral)(ecuLit = this.createModelElementLiteral(ecuEntry)), (ModelElementLiteral)(fsLit = this.createModelElementLiteral(fsEntry)));
        Expr deployExpr = this.transformationService.getZ3FunctionDecl(deploy).apply(new Expr[]{taskEntry.getValue(), ecuEntry.getValue(), fsEntry.getValue()});
        Expr evalResult = model.eval(deployExpr, false);
        int deployType = ((IntNum)evalResult).getInt();
        if (deployType < 0 || deployType > 2) {
            throw new RuntimeException("Invalid deployment type: " + deployType + " for task " + String.valueOf(taskLit) + " on " + String.valueOf(ecuLit) + " in fs " + String.valueOf(fsLit) + ".");
        }
        return deployType;
    }

    private void createRedundantAllocationEntry(Map<FailureScenario, Map<TaskToExecutionUnitAllocationEntry, AllocationTypeEnum>> redundantAllocationMap, IModelElement task, IModelElement ecu, IModelElement fs, int deployType) {
        Map<TaskToExecutionUnitAllocationEntry, AllocationTypeEnum> entryMap = redundantAllocationMap.get(fs);
        if (entryMap == null) {
            entryMap = new HashMap<TaskToExecutionUnitAllocationEntry, AllocationTypeEnum>();
            redundantAllocationMap.put((FailureScenario)fs, entryMap);
        }
        boolean addedToExistingEntry = false;
        for (Map.Entry<TaskToExecutionUnitAllocationEntry, AllocationTypeEnum> t2eEntry : entryMap.entrySet()) {
            TaskToExecutionUnitAllocationEntry t2e = t2eEntry.getKey();
            if (t2e.getTargetElement() != ecu) continue;
            if (t2eEntry.getValue().getValue() == deployType) {
                t2e.getSourceElements().add((Object)task);
                addedToExistingEntry = true;
                break;
            }
            if (!t2e.getSourceElements().contains((Object)task)) continue;
            throw new RuntimeException("Inconsistent deployment for task " + String.valueOf(task) + " on " + String.valueOf(ecu) + " in " + String.valueOf(fs) + ".");
        }
        if (!addedToExistingEntry) {
            TaskToExecutionUnitAllocationEntry t2e = TaskAllocationFactory.eINSTANCE.createTaskToExecutionUnitAllocationEntry();
            t2e.getSourceElements().add((Object)task);
            t2e.setTargetElement(ecu);
            entryMap.put(t2e, AllocationTypeEnum.get((int)deployType));
        }
    }

    public List<AllocationEntry> computeAllocations(Model model) throws UnsupportedDataTypeException {
        BasicEList rval = new BasicEList();
        for (EnumSort enumSort : this.transformationService.getLeftSidesOfAllocations()) {
            FuncDecl functionForLeftSideType = this.transformationService.getFunctionForLeftSideType(enumSort);
            Expr[] exprArray = enumSort.getConsts();
            int n = exprArray.length;
            int n2 = 0;
            while (n2 < n) {
                Expr enumExpr = exprArray[n2];
                Expr eval = model.eval(functionForLeftSideType.apply(new Expr[]{enumExpr}), true);
                IModelElement source = this.transformationService.resolveAllocation(enumExpr);
                IModelElement target = this.transformationService.resolveAllocation(eval);
                if (source instanceof Task && target instanceof ExecutionUnit) {
                    alloc = (TaskToExecutionUnitAllocationEntry)AllocationModelElementFactory.createAllocationEntry(TaskToExecutionUnitAllocationEntry.class);
                    alloc.getSourceElements().add((Object)source);
                    alloc.setTargetElement(target);
                    rval.add((Object)alloc);
                } else if (source instanceof Signal && target instanceof Route) {
                    alloc = (SignalToRouteAllocationEntry)AllocationModelElementFactory.createAllocationEntry(SignalToRouteAllocationEntry.class);
                    alloc.getSourceElements().add((Object)source);
                    alloc.setTargetElement(target);
                    rval.add((Object)alloc);
                } else if (!(source instanceof Signal) || target != null) {
                    String sourceName = source != null ? source.toString() : "<source>";
                    String targetName = target != null ? target.toString() : "<target>";
                    throw new UnsupportedDataTypeException("Unknown allocation of " + sourceName + " to " + targetName);
                }
                ++n2;
            }
        }
        return rval;
    }

    public List<ResourceSchedule> computeFrequencies(Model model) {
        BasicEList returnList = new BasicEList();
        for (Map.Entry<IModelElement, Expr> instance : this.transformationService.getExistingInstances().entrySet()) {
            IModelElement modelElement = instance.getKey();
            if (!(modelElement instanceof ExecutionUnit)) continue;
            Set ecuSet = ExpressionFactory.eINSTANCE.createSet();
            ecuSet.getEntries().add((Object)((ExecutionUnit)modelElement));
            FrequencyAssigned fa = ConstraintDefinitionUtils.createFrequencyAssigned((Set<ExecutionUnit>)ecuSet);
            Expr frequencyExpr = this.transformationService.getZ3FunctionDecl(fa).apply(new Expr[]{instance.getValue()});
            RatNum frequencyNum = (RatNum)model.eval(frequencyExpr, true);
            ResourceSchedule resourceSchedule = AF3ScheduleModelElementFactory.createResourceSchedule((IPlatformResource)((IPlatformResource)modelElement), (String)("resSched_" + modelElement.toString()));
            resourceSchedule.setFrequency(frequencyNum.getNumerator().getInt64());
            returnList.add((Object)resourceSchedule);
        }
        return returnList;
    }

    private List<BoolExpr> extractConstants(ExplorationSpecification explorationSpec, Context context) throws UnsupportedDataTypeException, Z3Exception {
        int duplicates = 0;
        ArrayList<BoolExpr> results = new ArrayList<BoolExpr>();
        ArrayList aPropLits = new ArrayList();
        for (IExplorationTarget expTarget : explorationSpec.getTargets()) {
            EList currPropLits = EcoreUtils.getChildrenWithType((EObject)expTarget, ArithmeticPropertyLiteral.class);
            currPropLits.removeIf(pL -> pL.getName().startsWith("VAR_"));
            aPropLits.addAll(currPropLits);
        }
        for (ArithmeticPropertyLiteral aPLit : aPropLits) {
            EList modelElements = aPLit.getSetReference().getEntries();
            for (IModelElement modelElement : modelElements) {
                RatNum valueExpr;
                Number value = (Number)aPLit.getValue(modelElement);
                boolean isReal = DSMLUtils.isReal((Number)value);
                Object object = valueExpr = isReal ? Z3javaAPIWrapper.createReal((Context)context, (String)value.toString()) : Z3javaAPIWrapper.createInteger((Context)context, (int)value.intValue());
                if (valueExpr != null) {
                    ArithExpr z3Function = this.transformationService.getZ3Function((ArithmeticPropertyLiteral<? extends IModelElement, Number>)aPLit, modelElement, valueExpr.getSort());
                    BoolExpr createEqual = Z3javaAPIWrapper.createEqual((Context)context, (Expr)z3Function, (Expr)valueExpr);
                    Collection filter2 = LambdaUtils.filter(results, be -> be.toString().equals(createEqual.toString()));
                    Optional first = LambdaUtils.getFirst((Collection)filter2);
                    if (!first.isPresent()) {
                        results.add(createEqual);
                        continue;
                    }
                    ++duplicates;
                    continue;
                }
                throw new UnsupportedDataTypeException(aPLit.getName() + " is not yet implemented.");
            }
        }
        if (duplicates > 0) {
            LoggingUtils.warning((Plugin)AF3ExplorationSMTActivator.getDefault(), (String)(duplicates + " number of duplicate smt constraints found."));
        }
        return results;
    }

    public ContextWrapper getContext() {
        return this.context;
    }

    public Map<BoolExpr, Pair<BoolExpr, IExplorationConstraint<?>>> getConstraintToTrack() {
        return this.constraintsToTrack;
    }

    public List<ArithExpr> getToMaximize() {
        return this.toMaximize;
    }

    public List<ArithExpr> getToMinimize() {
        return this.toMinimize;
    }

    public Collection<Expr> getConstraints() {
        ArrayList<Expr> constraints = new ArrayList<Expr>();
        this.transformedExpressions.entrySet().stream().filter(e -> e.getKey() instanceof IExplorationConstraint).forEach(e -> {
            boolean bl = constraints.add((Expr)e.getValue());
        });
        constraints.addAll(this.elementPropertyExpressions);
        return constraints;
    }

    public Collection<Expr> getObjectives() {
        return this.transformedExpressions.entrySet().stream().filter(e -> e.getKey() instanceof IExplorationObjective).map(e -> (Expr)e.getValue()).collect(Collectors.toList());
    }

    public Map<Expr, IExplorationTarget<?>> getTargetMapping() {
        return this.transformedExpressions.inverse();
    }

    public Map<Expr, IExplorationObjective<?>> getObjectiveMapping() {
        return this.transformedExpressions.inverse().entrySet().stream().filter(e -> e.getValue() instanceof IExplorationObjective).collect(Collectors.toMap(e -> (Expr)e.getKey(), e -> (IExplorationObjective)e.getValue()));
    }

    public Map<Expr, IExplorationConstraint<?>> getConstraintMapping() {
        return this.transformedExpressions.inverse().entrySet().stream().filter(e -> e.getValue() instanceof IExplorationConstraint).collect(Collectors.toMap(e -> (Expr)e.getKey(), e -> (IExplorationConstraint)e.getValue()));
    }
}

